/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParamsTable;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpParameterValidator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodDialog
extends RefactoringDialog
implements PhpExtractMethodSettings {
    private static final String HELP_ID = "refactoring.extractMethod";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog#";
    private static Font defaultTableFont = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
    private JTextField myNameTextField;
    private JCheckBox myDeclareStaticCheckBox;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPrivateRadioButton;
    private JBTable myParametersTable;
    private JTextArea mySignaturePreviewArea;
    private JPanel myVisibilityPanel;
    private JPanel myNamePanel;
    private JCheckBox myReplaceBreakContinueWithReturnCheckBox;
    private JRadioButton myOutputByParametersRadioButton;
    private JRadioButton myOutputByReturnRadioButton;
    private JPanel myTransformationOptionsPanel;
    private JTextArea myOutputVariablesArea;
    private JPanel myOutputVariablesPanel;
    private JPanel mySignaturePreviewPanel;
    private JPanel myTopPanel;
    private JCheckBox myGeneratePhpDoc;
    private final PhpExtractMethodCodeFragment myFragment;
    private final PhpNameConflictDetector myNameConflictDetector;
    private List<PhpExtractMethodParameterInfo> myParameters;
    private ParametersTableModel myParametersTableModel;
    private final Set<PhpPsiElement> myOutputVariables;
    private final String myDimensionServiceKey;
    private final Project myProject;

    protected PhpExtractMethodDialog(@NotNull Project project, @NotNull Set<PhpPsiElement> outputVariables, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnAllowed, boolean isReplaceBreakContinueWithReturn, boolean isDeclareStaticAllowed, boolean isDeclareStaticEnabled, boolean isDeclareStatic, @Nullable PhpModifier.Access visibility, @NotNull String nameBorderTitle, @NotNull String dimensionServiceKeyPrefix) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(0);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(1);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(2);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(3);
        }
        if (nameBorderTitle == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(4);
        }
        if (dimensionServiceKeyPrefix == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(5);
        }
        super(project, false);
        this.myProject = project;
        this.myFragment = fragment;
        this.myNameConflictDetector = nameConflictDetector;
        this.myOutputVariables = outputVariables;
        this.$$$setupUI$$$();
        int outputVariablesSize = outputVariables.size();
        boolean isOutputValuesExists = outputVariablesSize > 0;
        this.myDimensionServiceKey = DIMENSION_SERVICE_KEY_BASE + dimensionServiceKeyPrefix + (isOutputValuesExists ? "1" : "0");
        StringBuilder outputVariablesBuilder = new StringBuilder();
        Iterator<PhpPsiElement> iterator = outputVariables.iterator();
        while (iterator.hasNext()) {
            outputVariablesBuilder.append("$").append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            outputVariablesBuilder.append(", ");
        }
        this.myOutputVariablesArea.setText(outputVariablesBuilder.toString());
        this.myOutputByReturnRadioButton.setSelected(true);
        this.myOutputVariablesPanel.setVisible(isOutputValuesExists);
        this.myTransformationOptionsPanel.setVisible(isReplaceBreakContinueWithReturnAllowed);
        this.myReplaceBreakContinueWithReturnCheckBox.setSelected(isReplaceBreakContinueWithReturn);
        this.myDeclareStaticCheckBox.setVisible(isDeclareStaticAllowed);
        this.myDeclareStaticCheckBox.setEnabled(isDeclareStaticEnabled);
        this.myDeclareStaticCheckBox.setSelected(isDeclareStatic);
        if (visibility != null) {
            block0 : switch (visibility) {
                case PUBLIC: {
                    PhpModifier.Access defaultVisibility = PhpRefactoringSettings.getInstance().EXTRACT_METHOD_DEFAULT_VISIBILITY;
                    switch (defaultVisibility) {
                        case PUBLIC: {
                            this.myPublicRadioButton.setSelected(true);
                            break block0;
                        }
                        case PROTECTED: {
                            this.myProtectedRadioButton.setSelected(true);
                            break block0;
                        }
                        case PRIVATE: {
                            this.myPrivateRadioButton.setSelected(true);
                        }
                    }
                    break;
                }
                case PROTECTED: {
                    this.myProtectedRadioButton.setSelected(true);
                    break;
                }
                case PRIVATE: {
                    this.myPrivateRadioButton.setSelected(true);
                }
            }
        } else {
            this.myVisibilityPanel.setVisible(false);
        }
        this.myNamePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)nameBorderTitle, (boolean)true));
    }

    private void createUIComponents() {
        this.myParametersTableModel = new ParametersTableModel();
        this.myParametersTable = new PhpExtractMethodParamsTable(this.myParametersTableModel);
        this.myParametersTable.setRowHeight(20);
    }

    @NotNull
    public static PhpExtractMethodDialog createExtractFunctionDialog(@NotNull Project project, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnEnabled, boolean isReplaceBreakContinueWithReturn) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(6);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(7);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(8);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(9);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(10);
        }
        PhpExtractMethodDialog dialog = new PhpExtractMethodDialog(project, outputVariables, fragment, nameConflictDetector, isReplaceBreakContinueWithReturnEnabled, isReplaceBreakContinueWithReturn, false, false, false, null, PhpBundle.message("PhpExtractMethodDialog.function", new Object[0]), "function");
        dialog.init(fragment.getScopeHolder(), inputVariables, outputVariables);
        dialog.setTitle(PhpBundle.message("PhpExtractMethodDialog.extract.function", new Object[0]));
        dialog.init();
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(11);
        }
        return phpExtractMethodDialog;
    }

    @NotNull
    public static PhpExtractMethodDialog createExtractMethodDialog(@NotNull Project project, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, Set<PhpPsiElement> outputVariables, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnEnabled, boolean isReplaceBreakContinueWithReturn, boolean isDeclareStaticEnabled, boolean isDeclareStatic, @NotNull PhpModifier.Access visibility) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(12);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(13);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(14);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(15);
        }
        if (visibility == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(16);
        }
        PhpExtractMethodDialog dialog = new PhpExtractMethodDialog(project, outputVariables, fragment, nameConflictDetector, isReplaceBreakContinueWithReturnEnabled, isReplaceBreakContinueWithReturn, true, isDeclareStaticEnabled, isDeclareStatic, visibility, PhpBundle.message("PhpExtractMethodDialog.method", new Object[0]), "method");
        dialog.init(fragment.getScopeHolder(), inputVariables, outputVariables);
        dialog.setTitle(PhpBundle.message("PhpExtractMethodDialog.extract.method", new Object[0]));
        dialog.init();
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(17);
        }
        return phpExtractMethodDialog;
    }

    private void init(@NotNull PhpScopeHolder scopeHolder, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (scopeHolder == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(18);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(19);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(20);
        }
        this.myParameters = PhpExtractMethodDialog.getParameterItems(scopeHolder, inputVariables, outputVariables);
        this.myParametersTableModel.init(this.myParameters);
        this.myParametersTable.setModel((TableModel)((Object)this.myParametersTableModel));
        this.configureTableSelectionModel();
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$1", "textChanged"));
            }
        });
        ActionListener updateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        };
        ActionListener updateTableModelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isPassByReference = PhpExtractMethodDialog.this.isPassOutputByReference();
                List infos = PhpExtractMethodDialog.this.getParametersByReturnType(isPassByReference);
                PhpExtractMethodDialog.this.updateParameters(infos, isPassByReference);
                PhpExtractMethodDialog.this.myParametersTableModel.setReturnByRefMode(isPassByReference);
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        };
        this.myOutputByParametersRadioButton.addActionListener(updateTableModelListener);
        this.myOutputByReturnRadioButton.addActionListener(updateTableModelListener);
        this.myDeclareStaticCheckBox.addActionListener(updateActionListener);
        this.myPublicRadioButton.addActionListener(updateActionListener);
        this.myProtectedRadioButton.addActionListener(updateActionListener);
        this.myPrivateRadioButton.addActionListener(updateActionListener);
        this.myParametersTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        });
        this.updateSignaturePreview();
    }

    private void configureTableSelectionModel() {
        ListSelectionModel model = this.myParametersTable.getSelectionModel();
        model.setSelectionMode(0);
        model.setSelectionInterval(0, 0);
        this.myParametersTable.setSelectionModel(model);
        TableColumnModel columnModel = this.myParametersTable.getColumnModel();
        ListSelectionModel columnSelectionModel = columnModel.getSelectionModel();
        columnSelectionModel.setSelectionInterval(0, 0);
        this.myParametersTable.setColumnModel(columnModel);
    }

    protected JComponent createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout(0, 2));
        northPanel.add((Component)this.myTopPanel, "North");
        northPanel.add((Component)this.myOutputVariablesPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createParametersPanel(), "Center");
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)this.myTransformationOptionsPanel, "North");
        bottom.add((Component)this.createSignaturePanel(), "South");
        panel.add((Component)bottom, "South");
        panel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
        return panel;
    }

    private JPanel createParametersPanel() {
        this.myParametersTable.setFont(defaultTableFont);
        this.myParametersTable.setStriped(true);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myParametersTable);
        decorator.disableAddAction();
        decorator.disableRemoveAction();
        return decorator.createPanel();
    }

    private JComponent createSignaturePanel() {
        this.mySignaturePreviewArea.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN));
        this.mySignaturePreviewArea.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR));
        Dimension size = new Dimension(-1, 130);
        this.mySignaturePreviewPanel.setPreferredSize(size);
        this.mySignaturePreviewPanel.setMinimumSize(size);
        return this.mySignaturePreviewPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    private void updateParameters(@NotNull List<PhpExtractMethodParameterInfo> parameters, boolean isReturnByRef) {
        if (parameters == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(21);
        }
        for (PhpExtractMethodParameterInfo parameter : parameters) {
            parameter.setIsReturnByRefMode(this.myProject, isReturnByRef);
        }
    }

    private void updateSignaturePreview() {
        this.mySignaturePreviewArea.setText(PhpFunctionCodeGenerator.PREVIEW.generate(this));
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected ValidationInfo doValidate() {
        String nameConflicts;
        if ((!this.myNameTextField.hasFocus() || StringUtil.isNotEmpty((String)this.getName())) && (nameConflicts = this.myNameConflictDetector.findConflicts(this.getName())) != null) {
            return new ValidationInfo(nameConflicts, (JComponent)this.myNameTextField);
        }
        return this.myParametersTable.isEditing() ? null : PhpParameterValidator.validate(this.myProject, this.myParametersTableModel.getItems());
    }

    private String validateAndCommitData() {
        String newName = this.getName();
        if (!PhpNameUtil.isValidFunctionName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        ValidationInfo info = PhpParameterValidator.validateAndCommit(this.myProject, this.myParametersTableModel.getItems());
        return info == null ? null : info.message;
    }

    protected void doAction() {
        String message;
        if (this.myParametersTable != null) {
            TableUtil.stopEditing((JTable)this.myParametersTable);
        }
        if (StringUtil.isNotEmpty((String)(message = this.validateAndCommitData()))) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
        } else {
            PhpModifier.Access visibility = this.getVisibility();
            if (visibility != null) {
                PhpRefactoringSettings.getInstance().EXTRACT_METHOD_DEFAULT_VISIBILITY = visibility;
            }
            this.close(0);
        }
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myNameTextField.getText().trim();
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PhpExtractMethodParameterInfo> getParameters() {
        List list = ((ListTableModel)this.myParametersTable.getModel()).getItems();
        if (list == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(23);
        }
        return list;
    }

    private List<PhpExtractMethodParameterInfo> getParametersByReturnType(boolean returnByRef) {
        return PhpExtractMethodDialog.filterParametersByReturnType(this.myParameters, returnByRef);
    }

    protected static List<PhpExtractMethodParameterInfo> filterParametersByReturnType(List<? extends PhpExtractMethodParameterInfo> parameters, boolean returnByRef) {
        ArrayList<PhpExtractMethodParameterInfo> parameterForReturnType = new ArrayList<PhpExtractMethodParameterInfo>(parameters.size());
        for (PhpExtractMethodParameterInfo phpExtractMethodParameterInfo : parameters) {
            if (!phpExtractMethodParameterInfo.isEnabled(returnByRef)) continue;
            parameterForReturnType.add(phpExtractMethodParameterInfo);
        }
        return parameterForReturnType;
    }

    @Override
    @Nullable
    public PhpModifier.Access getVisibility() {
        if (this.myPublicRadioButton.isSelected()) {
            return PhpModifier.Access.PUBLIC;
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return PhpModifier.Access.PROTECTED;
        }
        if (this.myPrivateRadioButton.isSelected()) {
            return PhpModifier.Access.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isDeclareStatic() {
        return this.myDeclareStaticCheckBox.isSelected();
    }

    @Override
    @NotNull
    public String getFunctionBody() {
        String string = this.myFragment.generateCodeText();
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public String getReturnType() {
        if ("" == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(25);
        }
        return "";
    }

    @Override
    public boolean isPassOutputByReference() {
        return this.myOutputByParametersRadioButton.isSelected();
    }

    @Override
    public boolean isReplaceBreakContinueWithReturn() {
        return this.myReplaceBreakContinueWithReturnCheckBox.isSelected();
    }

    @Override
    public boolean generatePhpDoc() {
        return this.myGeneratePhpDoc.isSelected();
    }

    @Override
    @NotNull
    public Set<PhpPsiElement> getOutputVariables() {
        Set<PhpPsiElement> set = this.myOutputVariables;
        if (set == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    public static List<PhpExtractMethodParameterInfo> getParameterItems(@NotNull PhpScopeHolder scopeHolder, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (scopeHolder == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(27);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(28);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(29);
        }
        Set inputVariablesNames = ContainerUtil.map2Set(inputVariables, NavigationItem::getName);
        Set outputVariablesNames = ContainerUtil.map2Set(outputVariables, NavigationItem::getName);
        ArrayList<PhpExtractMethodParameterInfo> parameterInfos = new ArrayList<PhpExtractMethodParameterInfo>();
        THashSet addedVariables = new THashSet();
        if (scopeHolder instanceof Function) {
            Parameter[] parameters;
            for (Parameter parameter : parameters = ((Function)scopeHolder).getParameters()) {
                String type;
                String name = parameter.getName();
                boolean isInOutput = outputVariablesNames.contains(name);
                if (inputVariablesNames.contains(name)) {
                    type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
                    PhpExtractMethodParameterInfo.ParameterType parameterType = isInOutput ? PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF_OR_VALUE : PhpExtractMethodParameterInfo.ParameterType.NOT_FOR_RETURN;
                    parameterInfos.add(new PhpExtractMethodParameterInfo(parameterType, type, name, parameter.isPassByRef()));
                    addedVariables.add(name);
                    continue;
                }
                if (!isInOutput) continue;
                type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
                parameterInfos.add(new PhpExtractMethodParameterInfo(PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF, type, name, true));
                addedVariables.add(name);
            }
        }
        for (PhpPsiElement inputVariable : inputVariables) {
            String name = StringUtil.notNullize((String)inputVariable.getName());
            if (addedVariables.contains(name)) continue;
            PhpExtractMethodParameterInfo.ParameterType parameterType = outputVariablesNames.contains(name) ? PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF_OR_VALUE : PhpExtractMethodParameterInfo.ParameterType.NOT_FOR_RETURN;
            parameterInfos.add(new PhpExtractMethodParameterInfo(parameterType, PhpExtractMethodDialog.createTypeHint(scopeHolder, inputVariable), name, false));
            addedVariables.add(name);
        }
        for (PhpPsiElement outputVariable : outputVariables) {
            String name = StringUtil.notNullize((String)outputVariable.getName());
            if (addedVariables.contains(name)) continue;
            parameterInfos.add(new PhpExtractMethodParameterInfo(PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF, "", name, true));
        }
        ArrayList<PhpExtractMethodParameterInfo> arrayList = parameterInfos;
        if (arrayList == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    private static String createTypeHint(@NotNull PhpScopeHolder scopeHolder, PhpPsiElement inputVariable) {
        if (scopeHolder == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(31);
        }
        String string = StringUtil.notNullize((String)PhpAddMethodDeclarationQuickFix.createParameterTypeHint((PsiElement)inputVariable, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)scopeHolder), false));
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(32);
        }
        return string;
    }

    static {
        defaultTableFont = new Font(defaultTableFont.getFontName(), defaultTableFont.getStyle(), 12);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVariables";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConflictDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameBorderTitle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionServiceKeyPrefix";
                break;
            }
            case 8: 
            case 14: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 18: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractFunctionDialog";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractMethodDialog";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionBody";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterItems";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createExtractFunctionDialog";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createExtractMethodDialog";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateParameters";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterItems";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTypeHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextArea jTextArea;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JTextArea jTextArea2;
        JPanel jPanel3;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel4;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTopPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myNamePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.name"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDeclareStaticCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.declare.static"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myGeneratePhpDoc = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.generate.php.doc"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 1, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPublicRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.public"));
        jPanel4.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.protected"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrivateRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.private"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.visibility"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySignaturePreviewPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel7.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.signature.preview"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySignaturePreviewArea = jTextArea2 = new JTextArea();
        jTextArea2.setColumns(10);
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setRows(2);
        ((Component)jTextArea2).setVisible(true);
        jTextArea2.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setVisible(true);
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel7.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.parameters"), (int)0, (int)0, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel9.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myParametersTable;
        jBTable.setShowVerticalLines(true);
        jBTable.setToolTipText(ResourceBundle.getBundle("messages/PhpBundle").getString("refactoring.extract.method.tooltip"));
        jBScrollPane2.setViewportView((Component)jBTable);
        this.myTransformationOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.transformation.options"), (int)0, (int)0, null, null));
        this.myReplaceBreakContinueWithReturnCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.replace.tail.break.continue.with.return"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputVariablesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.output.variables"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputVariablesArea = jTextArea = new JTextArea();
        jTextArea.setColumns(10);
        jTextArea.setEditable(false);
        jTextArea.setRows(1);
        jTextArea.setText("");
        jTextArea.setWrapStyleWord(true);
        jBScrollPane3.setViewportView(jTextArea);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.return.output.through"));
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOutputByReturnRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.return.output.through.return"));
        jPanel10.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myOutputByParametersRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.return.output.through.ref.parameters"));
        jPanel10.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        jBLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ParameterColumnInfo
    extends ColumnInfo<PhpExtractMethodParameterInfo, String> {
        private ParameterColumnInfo() {
            super("Parameter");
        }

        public String valueOf(PhpExtractMethodParameterInfo parameterInfo) {
            return parameterInfo.getParameterPreviewText();
        }

        public boolean isCellEditable(PhpExtractMethodParameterInfo info) {
            return true;
        }

        public void setValue(PhpExtractMethodParameterInfo info, String value) {
            info.setParameterText(value);
        }
    }

    private static class ParametersTableModel
    extends ListTableModel<PhpExtractMethodParameterInfo> {
        private final Map<Integer, PhpExtractMethodParameterInfo> rowNumToParameter = new THashMap();
        private int rowCount = 0;
        private boolean myReturnByRefMode = true;

        ParametersTableModel() {
            super(new ColumnInfo[]{new ParameterColumnInfo()});
        }

        public void init(@NotNull List<PhpExtractMethodParameterInfo> parameterInfos) {
            if (parameterInfos == null) {
                ParametersTableModel.$$$reportNull$$$0(0);
            }
            this.rowCount = parameterInfos.size();
            this.setItems(parameterInfos);
            this.setReturnByRefMode(false);
        }

        public void setReturnByRefMode(boolean returnByRefMode) {
            if (returnByRefMode != this.myReturnByRefMode) {
                List currentItems = this.getItems();
                ArrayList<PhpExtractMethodParameterInfo> resultItems = new ArrayList<PhpExtractMethodParameterInfo>(10);
                if (returnByRefMode) {
                    int addedFromCurrent = 0;
                    for (int i = 0; i < this.rowCount; ++i) {
                        if (this.rowNumToParameter.containsKey(i)) {
                            resultItems.add(this.rowNumToParameter.remove(i));
                            continue;
                        }
                        resultItems.add((PhpExtractMethodParameterInfo)currentItems.get(addedFromCurrent));
                        ++addedFromCurrent;
                    }
                    this.setItems(resultItems);
                } else {
                    for (int i = 0; i < currentItems.size(); ++i) {
                        PhpExtractMethodParameterInfo item = (PhpExtractMethodParameterInfo)currentItems.get(i);
                        if (item.isEnabled(returnByRefMode)) {
                            resultItems.add(item);
                            continue;
                        }
                        this.rowNumToParameter.put(i, item);
                    }
                }
                this.setItems(resultItems);
                this.myReturnByRefMode = returnByRefMode;
                this.fireTableDataChanged();
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            super.setValueAt(aValue, rowIndex, columnIndex);
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfos", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$ParametersTableModel", "init"));
        }
    }
}

