/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableImpl
extends PhpNamedElementImpl<PhpVariableStub>
implements Variable {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.lang.psi.elements.impl.VariableImpl");
    private static final OffsetComparator OFFSET_COMPARATOR = new OffsetComparator();
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.VARIABLE_NAME});
    private static final ResolveCache.PolyVariantResolver<PhpReference> MY_RESOLVER = (expression, incompleteCode) -> {
        Collection globals = expression.resolveGlobal(incompleteCode);
        return PsiElementResolveResult.createResults((Collection)globals);
    };
    public static final SLRUMap<PsiElement, THashMap<String, TreeSet<PhpNamedElement>>> VISITOR_RESULT_CACHE = new SLRUMap(100, 100);
    public static final SLRUMap<PsiElement, THashMap<String, TreeSet<PhpNamedElement>>> VISITOR_RESULT_CACHE_GLOBAL = new SLRUMap(100, 100);
    public static final String VISITOR_RESULT_CACHE_LOCK = "VISITOR_RESULT_CACHE_LOCK";
    public static final boolean USE_VISITOR_RESULT_CACHE = true;

    public VariableImpl(ASTNode node) {
        super(node);
    }

    public VariableImpl(PhpVariableStub stub) {
        super(stub, PhpStubElementTypes.VARIABLE);
    }

    @Override
    @NotNull
    public String getName() {
        PhpVariableStub stub = (PhpVariableStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.canReadName()) {
            String name = this.getNameNode().getText();
            String string = name.charAt(0) == '$' ? name.substring(1) : name;
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("" == null) {
            VariableImpl.$$$reportNull$$$0(2);
        }
        return "";
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        PhpVariableStub stub = (PhpVariableStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        CharSequence name = nameNode != null ? nameNode.getChars() : "";
        CharSequence charSequence = name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
        if (charSequence == null) {
            VariableImpl.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @Override
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            VariableImpl.$$$reportNull$$$0(5);
        }
        if (this.canReadName() && !PhpLangUtil.equalsVariableNames(this.getName(), name)) {
            ASTNode nameNode = this.getNameNode();
            assert (nameNode != null);
            ASTNode newNameNode = PhpPsiElementFactory.createVariable(this.getProject(), name, nameNode.getChars().charAt(0) == '$').getNameNode();
            if (newNameNode != null) {
                nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
            }
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            VariableImpl.$$$reportNull$$$0(6);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpVariable((Variable)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    public boolean isDeclarationGlobal() {
        return this.isWriteAccess();
    }

    public boolean isDeclaration() {
        return this.isWriteAccess(false);
    }

    public boolean canReadName() {
        ASTNode node = this.getNode();
        return node.getChildren(null).length > 0 && node.findChildByType(PhpTokenTypes.DOLLAR) == null && node.findChildByType(PhpTokenTypes.VARIABLE) != null;
    }

    public PsiReference getReference() {
        if (this.canReadName()) {
            return this;
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        VariableImpl variableImpl = this;
        if (variableImpl == null) {
            VariableImpl.$$$reportNull$$$0(7);
        }
        return variableImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = new TextRange(0, this.getTextLength());
        if (textRange == null) {
            VariableImpl.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            VariableImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String s) throws IncorrectOperationException {
        if (s == null) {
            VariableImpl.$$$reportNull$$$0(10);
        }
        return this.setName(s);
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            VariableImpl.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException("Method bindToElement is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            VariableImpl.$$$reportNull$$$0(12);
        }
        if (psiElement instanceof PhpClass && PhpLangUtil.isThisReference((PsiElement)this) || (psiElement instanceof Variable || psiElement instanceof Parameter || psiElement instanceof PhpDocVariable) && PhpLangUtil.equalsVariableNames(this.getNameCS(), ((PhpNamedElement)psiElement).getNameCS())) {
            ResolveResult[] results;
            if (PhpPsiUtil.getParentByCondition(psiElement, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF) == PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF)) {
                return true;
            }
            for (ResolveResult result : results = this.multiResolve(false)) {
                if (psiElement != result.getElement()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        Function f = (Function)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (f != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)f);
            if (localSearchScope == null) {
                VariableImpl.$$$reportNull$$$0(13);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            VariableImpl.$$$reportNull$$$0(14);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.VARIABLE;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getVarPresentation(this);
    }

    public boolean isWriteAccess() {
        return this.isWriteAccess(true);
    }

    public boolean isWriteAccess(boolean global) {
        VariableImpl that = this;
        PsiElement parent = this.getParent();
        if (parent == null) {
            return false;
        }
        IElementType parentType = parent.getNode().getElementType();
        while (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(parentType)) {
            that = parent;
            parent = parent.getParent();
            parentType = parent.getNode().getElementType();
        }
        MultiassignmentExpression multi = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (multi != null && !PsiTreeUtil.isAncestor((PsiElement)multi.getValue(), (PsiElement)parent, (boolean)false)) {
            return true;
        }
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getVariable() == that;
        }
        if (parent instanceof PhpUnset) {
            return true;
        }
        if (parent instanceof UnaryExpression && (parentType == PhpElementTypes.INFIX_WRITE_EXPRESSION || parentType == PhpElementTypes.POSTFIX_EXPRESSION)) {
            return true;
        }
        if (PhpElementTypes.STATIC_STATEMENT.equals(parentType)) {
            return true;
        }
        if (parent instanceof ForeachStatement) {
            ForeachStatement foreach = (ForeachStatement)parent;
            return foreach.getKey() == this || foreach.getValue() == this || foreach.getVariables().contains((Object)this);
        }
        if (parent instanceof Catch) {
            return ((Catch)parent).getException() == this;
        }
        if (parent instanceof PhpUseList) {
            return true;
        }
        if (parent instanceof Global) {
            return ArrayUtilRt.find((Object[])((Global)parent).getVariables(), (Object)((Object)this)) > -1;
        }
        return PhpCodeInsightUtil.isPassByRefParameter((PsiElement)this, global);
    }

    @NotNull
    public static LookupElement[] getVariableVariants(@NotNull PsiElement point, boolean includeGlobal) {
        PhpClass phpClass;
        if (point == null) {
            VariableImpl.$$$reportNull$$$0(15);
        }
        Project project = point.getProject();
        THashSet locals = new THashSet();
        ArrayList<Object> allVariants = new ArrayList<Object>();
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(point, true, null);
        for (PhpNamedElement phpNamedElement : declarations) {
            String name;
            if (phpNamedElement == point || locals.contains(name = phpNamedElement.getName())) continue;
            locals.add(name);
            LookupElement lookupElement = PhpVariantsUtil.getLookupElementForVariable(phpNamedElement);
            if (lookupElement == null) continue;
            allVariants.add(lookupElement);
        }
        if (!locals.contains("this") && (phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)point, PhpClass.class)) != null) {
            allVariants.add((Object)new PhpLookupElement("this", PhpVariableIndex.KEY, PhpIcons.VARIABLE, phpClass.getType(), project, PhpVariableInsertHandler.getInstance()));
        }
        if (includeGlobal) {
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            Collection collection = phpIndex.getAllVariableNames(null);
            ArrayList<PhpLookupElement> globals = new ArrayList<PhpLookupElement>(collection.size());
            for (String global : collection) {
                if (!StringUtil.isNotEmpty((String)global) || locals.contains(global)) continue;
                globals.add(new PhpLookupElement(global, PhpVariableIndex.KEY, project, PhpVariableInsertHandler.getInstance()));
            }
            allVariants.addAll(globals);
        }
        LookupElement[] lookupElementArray = allVariants.toArray(LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            VariableImpl.$$$reportNull$$$0(16);
        }
        return lookupElementArray;
    }

    @Nullable
    public PsiElement resolve() {
        return VariableImpl.getLeastByPathAndOffset(this.multiResolve(false));
    }

    @Nullable
    public static PsiElement getLeastByPathAndOffset(@NotNull ResolveResult[] results) {
        if (results == null) {
            VariableImpl.$$$reportNull$$$0(17);
        }
        if (results.length == 0) {
            return null;
        }
        if (results.length > 1) {
            PsiElement result = null;
            int resultId = Integer.MAX_VALUE;
            int resultTextOffset = Integer.MAX_VALUE;
            for (ResolveResult aR : results) {
                int candidateTextOffset;
                int candidateId;
                PsiElement candidate = aR.getElement();
                if (candidate == null || !candidate.isValid()) continue;
                VirtualFile f = candidate.getContainingFile().getVirtualFile();
                if (f instanceof LightVirtualFile) {
                    f = ((LightVirtualFile)f).getOriginalFile();
                }
                int n = candidateId = f instanceof VirtualFileWithId ? ((VirtualFileWithId)f).getId() : 0;
                if (candidateId < resultId) {
                    candidateTextOffset = candidate.getTextOffset();
                    result = candidate;
                    resultId = candidateId;
                    resultTextOffset = candidateTextOffset;
                    continue;
                }
                if (candidateId != resultId || (candidateTextOffset = candidate.getTextOffset()) >= resultTextOffset) continue;
                result = candidate;
                resultTextOffset = candidateTextOffset;
            }
            return result;
        }
        return results[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
            if (resolveResultArray == null) {
                VariableImpl.$$$reportNull$$$0(18);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = MY_RESOLVER.resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            VariableImpl.$$$reportNull$$$0(19);
        }
        return resolveResultArray;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Set<? extends PhpNamedElement> set = VariableImpl.resolveLocal(this);
        if (set == null) {
            VariableImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = this.getType();
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(21);
        }
        return phpType;
    }

    @NotNull
    public static Set<? extends PhpNamedElement> resolveLocal(@NotNull VariableImpl variable) {
        if (variable == null) {
            VariableImpl.$$$reportNull$$$0(22);
        }
        Set<? extends PhpNamedElement> set = variable.resolveInFile(false);
        if (set == null) {
            VariableImpl.$$$reportNull$$$0(23);
        }
        return set;
    }

    @NotNull
    private Set<? extends PhpNamedElement> resolveInFile(boolean allowGlobalLookup) {
        PhpClass aClass;
        if ("this".equalsIgnoreCase(this.getName()) && (aClass = PhpClassImpl.getContainingClass(this)) != null) {
            Set<PhpClass> set = Collections.singleton(aClass);
            if (set == null) {
                VariableImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<? extends PhpNamedElement> set = VariableImpl.collectDeclarations((PsiElement)this, allowGlobalLookup, this.getName());
        if (set == null) {
            VariableImpl.$$$reportNull$$$0(25);
        }
        return set;
    }

    public static Set<? extends PhpNamedElement> collectDeclarations(@NotNull PsiElement position, boolean allowGlobalLookup, @Nullable String name) {
        if (position == null) {
            VariableImpl.$$$reportNull$$$0(26);
        }
        PhpScopeHolder scope = PhpPsiUtil.getScopeHolder(position);
        PsiFile containingFile = position.getContainingFile().getOriginalFile();
        if (scope == null || scope instanceof PsiFile) {
            scope = containingFile;
        }
        return VariableImpl.collectDeclarationsByScope((PsiElement)scope, allowGlobalLookup, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Set<? extends PhpNamedElement> collectDeclarationsByScope(@NotNull PsiElement scope, boolean allowGlobalLookup, @Nullable String name) {
        if (scope == null) {
            VariableImpl.$$$reportNull$$$0(27);
        }
        TreeSet<PhpNamedElement> decls = new TreeSet<PhpNamedElement>(OFFSET_COMPARATOR);
        SLRUMap<PsiElement, THashMap<String, TreeSet<PhpNamedElement>>> cache = allowGlobalLookup ? VISITOR_RESULT_CACHE_GLOBAL : VISITOR_RESULT_CACHE;
        String string = VISITOR_RESULT_CACHE_LOCK;
        // MONITORENTER : "VISITOR_RESULT_CACHE_LOCK"
        THashMap scopeMap = (THashMap)cache.get((Object)scope);
        // MONITOREXIT : string
        if (scopeMap != null && (!scope.getContainingFile().isPhysical() || ApplicationManager.getApplication().isEAP())) {
            Object value;
            Set<Object> values = name != null ? ((value = (TreeSet)scopeMap.get((Object)name)) != null ? Collections.singleton(value) : Collections.emptySet()) : scopeMap.values();
            block4: for (Object elements : values) {
                Iterator iterator = ((TreeSet)elements).iterator();
                while (iterator.hasNext()) {
                    PhpNamedElement element = (PhpNamedElement)iterator.next();
                    if (element.isValid()) continue;
                    scopeMap = null;
                    if (!scope.getContainingFile().isPhysical()) break block4;
                    LOG.error("Invalid element of type " + element.getNode().getElementType() + " is found in cache. Cache is invalidated. Debug info: scope of type " + scope.getNode().getElementType() + " is " + (scope.isValid() ? "valid" : "invalid") + ", amount of elements by name is " + ((TreeSet)elements).size() + ". Name is " + (name != null ? "" : "not ") + "provided.");
                    break block4;
                }
            }
        }
        if (scopeMap == null) {
            DeclarationCollector collector = new DeclarationCollector(allowGlobalLookup);
            scope.accept((PsiElementVisitor)collector);
            Map all = collector.myAllDecls;
            for (PsiElement psiElement : all.keySet()) {
                if (psiElement == scope) {
                    scopeMap = (THashMap)all.get(psiElement);
                }
                String string2 = VISITOR_RESULT_CACHE_LOCK;
                // MONITORENTER : "VISITOR_RESULT_CACHE_LOCK"
                cache.put((Object)psiElement, all.get(psiElement));
                // MONITOREXIT : string2
            }
        }
        if (scopeMap == null) return decls;
        if (name != null) {
            Collection declarations = (Collection)scopeMap.get((Object)name);
            if (declarations == null) return decls;
            decls.addAll(declarations);
            return decls;
        }
        Collection treeSetCollection = scopeMap.values();
        Iterator iterator = treeSetCollection.iterator();
        while (iterator.hasNext()) {
            TreeSet phpNamedElements = (TreeSet)iterator.next();
            decls.addAll(phpNamedElements);
        }
        return decls;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection glob;
        boolean globOnly;
        boolean superglobal = SUPERGLOBALS.contains(this.getName());
        Collection<Object> result = !superglobal ? this.resolveInFile(true) : EMPTY_SET;
        boolean bl = globOnly = superglobal || PsiTreeUtil.getParentOfType((PsiElement)this, Function.class, (boolean)false) == null && result.size() == 0 || result.size() > 0 && PhpPsiUtil.getParentByCondition((PsiElement)result.iterator().next(), (Condition<? super PsiElement>)Global.INSTANCEOF) != null;
        if (globOnly && (glob = PhpIndex.getInstance((Project)this.getProject()).getVariablesByName(this.getName())).size() > 0) {
            result = glob;
        }
        Collection<? extends PhpNamedElement> collection = result = VariableImpl.updateDeclarationsWithExternalRef(result, this);
        if (collection == null) {
            VariableImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> collectDeclarationsWithExternalRef(@NotNull PhpNamedElement element, boolean allowGlobalLookup) {
        if (element == null) {
            VariableImpl.$$$reportNull$$$0(29);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)element, allowGlobalLookup, element.getName());
        return VariableImpl.updateDeclarationsWithExternalRef(declarations, element);
    }

    private static Collection<? extends PhpNamedElement> updateDeclarationsWithExternalRef(@NotNull Collection<? extends PhpNamedElement> declarations, @NotNull PhpNamedElement element) {
        Set<? extends PhpNamedElement> set;
        Function my;
        if (declarations == null) {
            VariableImpl.$$$reportNull$$$0(30);
        }
        if (element == null) {
            VariableImpl.$$$reportNull$$$0(31);
        }
        if (VariableImpl.hasExternalRefInDeclaration(declarations) && (my = (Function)PhpPsiUtil.getParentByCondition((PsiElement)element, true, (Condition<? super PsiElement>)Function.INSTANCEOF)) != null && (set = VariableImpl.collectDeclarations(my.getParent(), false, element.getName())).size() > 0) {
            declarations = set;
        }
        return declarations;
    }

    private static boolean hasExternalRefInDeclaration(@NotNull Collection<? extends PhpNamedElement> result) {
        if (result == null) {
            VariableImpl.$$$reportNull$$$0(32);
        }
        for (PhpNamedElement phpNamedElement : result) {
            StubElement stub;
            StubElement stubElement = stub = phpNamedElement instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)phpNamedElement).getStub() : null;
            if (stub != null && !VariableImpl.stubParentIsClosure(stub) || !(phpNamedElement.getParent() instanceof PhpUseList)) continue;
            return true;
        }
        return false;
    }

    private static boolean stubParentIsClosure(@NotNull StubElement stub) {
        PsiElement psi;
        if (stub == null) {
            VariableImpl.$$$reportNull$$$0(33);
        }
        return (psi = stub.getParentStub().getPsi()) instanceof Function && ((Function)psi).isClosure();
    }

    @NotNull
    public String getSignature() {
        PsiElement element;
        PhpClass phpClass;
        Function f;
        boolean isThis = "this".equalsIgnoreCase(this.getName());
        if (isThis && (f = (Function)PsiTreeUtil.getParentOfType((PsiElement)this, Function.class)) instanceof Method && (phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class)) != null) {
            String string = PhpTypeSignatureKey.CLASS.sign((CharSequence)phpClass.getFQN());
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(34);
            }
            return string;
        }
        Set<? extends PhpNamedElement> vars = VariableImpl.resolveLocal(this);
        if (vars.size() >= 1) {
            PhpNamedElement decl = vars.iterator().next();
            if (isThis || decl instanceof Parameter || decl instanceof PhpDocVariable || decl instanceof Variable && ((Variable)decl).isDeclaration() && PhpPsiUtil.getParentByCondition((PsiElement)decl, (Condition<? super PsiElement>)Global.INSTANCEOF) == null && !(decl.getParent() instanceof ParameterList)) {
                PhpType type = decl.getType();
                String string = type.getTypes().stream().filter(s -> !PhpType.isPrimitiveType((String)s)).map(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.CLASS).signIfUnsigned(arg_0)).reduce((s, s2) -> s + "|" + s2).orElseGet(String::new);
                if (string == null) {
                    VariableImpl.$$$reportNull$$$0(35);
                }
                return string;
            }
        }
        if (this.getParent() instanceof ParameterList && (element = this.getParent().getParent()) instanceof FunctionReference) {
            String func = ((FunctionReference)element).getSignature();
            String string = StringUtil.join((Collection)StringUtil.split((String)func, (String)"|").stream().map(s -> PhpTypeSignatureKey.PARAMETER.sign((CharSequence)(s + "." + PhpCodeInsightUtil.getParameterIndex((PsiElement)this)))).collect(Collectors.toList()), (String)"|");
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = PhpTypeSignatureKey.VARIABLE.sign((CharSequence)this.getName());
        if (string == null) {
            VariableImpl.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public String getImmediateNamespaceName() {
        if ("" == null) {
            VariableImpl.$$$reportNull$$$0(38);
        }
        return "";
    }

    public boolean isAbsolute() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + (this.isDeclaration() ? "Decl" : "");
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                VariableImpl.$$$reportNull$$$0(39);
            }
            return phpType;
        }
        PhpType phpType = super.getType();
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(40);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDocType() {
        PhpDocParamTag varTag;
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null && (varTag = docComment.getVarTag()) != null && PhpLangUtil.equalsVariableNames(varTag.getVarName(), this.getName())) {
            PhpType phpType = varTag.getType();
            if (phpType == null) {
                VariableImpl.$$$reportNull$$$0(41);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(42);
        }
        return phpType;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        PhpDocComment docComment = PhpPsiUtil.getDocCommentFor(this, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)element -> (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)element, true, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)));
        return docComment != null ? docComment : super.getDocComment();
    }

    public static boolean isVariableVariable(@NotNull Variable variable) {
        PhpPsiElement child;
        if (variable == null) {
            VariableImpl.$$$reportNull$$$0(43);
        }
        return !(variable.getParent() instanceof StringLiteralExpression) && (!variable.canReadName() ? (child = variable.getFirstPsiChild()) instanceof Variable || child instanceof ArrayAccessExpression : PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)variable, true), PhpTokenTypes.ARROW) && !PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)variable, true), PhpTokenTypes.chLPAREN));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/VariableImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 22: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/VariableImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableVariants";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateNamespaceName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVariableVariants";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLeastByPathAndOffset";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarationsByScope";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarationsWithExternalRef";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateDeclarationsWithExternalRef";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasExternalRefInDeclaration";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stubParentIsClosure";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isVariableVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeclarationCollector
    extends PhpRecursiveElementVisitor {
        private final Stack<PsiElement> myScope = new Stack();
        private THashMap<String, TreeSet<PhpNamedElement>> myDecls;
        private final Map<PsiElement, THashMap<String, TreeSet<PhpNamedElement>>> myAllDecls = ContainerUtil.createWeakMap();
        private final boolean global;

        DeclarationCollector(boolean global) {
            this.myDecls = new THashMap();
            this.global = global;
        }

        public void visitPhpFile(PhpFile phpFile) {
            this.myScope.push((PsiElement)phpFile);
            super.visitPhpFile(phpFile);
            this.myScope.pop();
        }

        public void visitPhpFunction(Function function) {
            this.myScope.push((PsiElement)function);
            super.visitPhpFunction(function);
            this.myScope.pop();
        }

        public void visitPhpNamespace(PhpNamespace namespace) {
            this.myScope.push((PsiElement)namespace);
            super.visitPhpNamespace(namespace);
            this.myScope.pop();
        }

        public void visitPhpMethod(Method method) {
            this.myScope.push((PsiElement)method);
            super.visitPhpMethod(method);
            this.myScope.pop();
        }

        public void visitPhpClass(PhpClass phpClass) {
            this.myScope.push((PsiElement)phpClass);
            super.visitPhpClass(phpClass);
            this.myScope.pop();
        }

        public void visitPhpVariable(Variable element) {
            if (element.isWriteAccess(this.global)) {
                this.save((PhpNamedElement)element);
            }
        }

        public void visitPhpParameter(Parameter parameter) {
            this.save((PhpNamedElement)parameter);
        }

        public void visitPhpDocVariable(PhpDocVariable expression) {
            String name;
            PhpDocTag tag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
            if (tag != null && ("@var".equals(name = tag.getName()) || "@type".equals(name))) {
                this.save((PhpNamedElement)expression);
            }
        }

        private void save(PhpNamedElement namedElement) {
            String name;
            TreeSet<PhpNamedElement> decls;
            if (this.myScope.isEmpty()) {
                this.myScope.push((PsiElement)namedElement.getContainingFile());
            }
            this.myDecls = this.myAllDecls.get(this.myScope.peek());
            if (this.myDecls == null) {
                this.myDecls = new THashMap();
                this.myAllDecls.put(this.myScope.peek(), this.myDecls);
            }
            if ((decls = (TreeSet<PhpNamedElement>)this.myDecls.get((Object)(name = namedElement.getName()))) == null) {
                decls = new TreeSet<PhpNamedElement>(OFFSET_COMPARATOR);
                this.myDecls.put((Object)name, decls);
            }
            decls.add(namedElement);
        }
    }

    private static class OffsetComparator
    implements Comparator<PhpNamedElement> {
        private OffsetComparator() {
        }

        @Override
        public int compare(PhpNamedElement o1, PhpNamedElement o2) {
            return o1.getTextOffset() - o2.getTextOffset();
        }
    }
}

