/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.math;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.math.MultiplicativeExpression;

public class AdditiveExpression {
    private static final TokenSet ADDITIVE_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS, PhpTokenTypes.opCONCAT});
    private static final int MAX_DEPTH = 300;

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = MultiplicativeExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compare(ADDITIVE_OPERATORS)) {
            IElementType curType = builder.getTokenType();
            builder.advanceLexer();
            boolean ignorePrecede = false;
            int curDepth = 0;
            result = AdditiveExpression.subParse(builder);
            if (PhpTokenTypes.opCONCAT.equals(curType)) {
                marker.done(PhpElementTypes.CONCATENATION_EXPRESSION);
            } else {
                marker.done(PhpElementTypes.ADDITIVE_EXPRESSION);
            }
            marker = marker.precede();
            ++curDepth;
            while (ADDITIVE_OPERATORS.contains(builder.getTokenType())) {
                curType = builder.getTokenType();
                builder.advanceLexer();
                result = AdditiveExpression.subParse(builder);
                if (!ignorePrecede && curDepth > 300) {
                    ignorePrecede = true;
                }
                if (ignorePrecede) continue;
                if (PhpTokenTypes.opCONCAT.equals(curType)) {
                    marker.done(PhpElementTypes.CONCATENATION_EXPRESSION);
                } else {
                    marker.done(PhpElementTypes.ADDITIVE_EXPRESSION);
                }
                marker = marker.precede();
                ++curDepth;
            }
            if (ignorePrecede) {
                if (PhpTokenTypes.opCONCAT.equals(curType)) {
                    marker.done(PhpElementTypes.CONCATENATION_EXPRESSION);
                } else {
                    marker.done(PhpElementTypes.ADDITIVE_EXPRESSION);
                }
                marker = marker.precede();
            }
        }
        marker.drop();
        return result;
    }

    private static IElementType subParse(PhpPsiBuilder builder) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = MultiplicativeExpression.parse(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error("Expected: expression");
        }
        return result;
    }
}

