/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowsTagQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpDocMissingThrowsInspection
extends PhpInspection {
    private static final LocalQuickFix[] UPDATE_PHP_DOC_QUICK_FIX = new LocalQuickFix[]{PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX};
    private static final String MESSAGE = PhpBundle.message("inspection.doc.throws.problem", new Object[0]);
    public boolean SKIP_ON_EMPTY_PHPDOC = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                if (PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC && docComment.getReturnTag() == null && docComment.getParamTags().isEmpty() && docComment.getTagElementsByName("@throws").length == 0) {
                    return;
                }
                Set docExceptions = StreamEx.of(PhpDocUtil.collectTagsConsideringInheritance(function, "@throws")).append((Object[])docComment.getTagElementsByName("@expectedException")).map(PhpTypedElement::getType).toSet();
                Set<PhpType> thrownExceptions = PhpThrownExceptionsAnalyzer.getExceptionClasses((PhpScopeHolder)function);
                Collection<PhpType> undocumentedExceptions = PhpDocMissingThrowsInspection.getUndocumentedExceptions(thrownExceptions, docExceptions, function);
                if (!undocumentedExceptions.isEmpty()) {
                    if (undocumentedExceptions.size() == 1) {
                        PhpType undocumentedException = undocumentedExceptions.iterator().next();
                        PhpAddThrowsTagQuickFix addThrowsTagQuickFix = new PhpAddThrowsTagQuickFix(undocumentedException);
                        holder.registerProblem((PsiElement)docComment, MESSAGE, new LocalQuickFix[]{addThrowsTagQuickFix, PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX});
                    } else {
                        holder.registerProblem((PsiElement)docComment, MESSAGE, UPDATE_PHP_DOC_QUICK_FIX);
                    }
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
        if (phpElementVisitor == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public static Collection<PhpType> getUndocumentedExceptions(@NotNull Collection<PhpType> thrownExceptions, @NotNull Collection<? extends PhpType> docExceptions, @NotNull Function function) {
        if (thrownExceptions == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(2);
        }
        if (docExceptions == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(3);
        }
        if (function == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(4);
        }
        if (docExceptions.isEmpty()) {
            return thrownExceptions;
        }
        PhpType docException = docExceptions.stream().map(type -> {
            if (function == null) {
                PhpDocMissingThrowsInspection.$$$reportNull$$$0(7);
            }
            return type.globalLocationAware((PsiElement)function);
        }).reduce(new PhpType(), (acc, type) -> acc.add(type));
        PhpIndex index = PhpIndex.getInstance((Project)function.getProject());
        return ((StreamEx)StreamEx.of(thrownExceptions).filter(thrownException -> !docException.isConvertibleFrom(thrownException, index))).toList();
    }

    @NotNull
    public static Consumer<DataContext> getConsumer() {
        Consumer<DataContext> consumer = context -> {
            if (context != null) {
                Settings settings = (Settings)Settings.KEY.getData(context);
                if (settings != null) {
                    PhpProjectConfigurable configurable = (PhpProjectConfigurable)settings.find(PhpProjectConfigurable.class);
                    assert (configurable != null);
                    PhpDocMissingThrowsInspection.selectAnalysisTab(configurable);
                    settings.select((Configurable)configurable);
                } else {
                    Project project = (Project)context.getData(CommonDataKeys.PROJECT);
                    assert (project != null);
                    PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                    PhpDocMissingThrowsInspection.selectAnalysisTab(configurable);
                    PhpUiUtil.editConfigurable(project, (Configurable)configurable);
                }
            }
        };
        if (consumer == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(5);
        }
        return consumer;
    }

    private static void selectAnalysisTab(@NotNull PhpProjectConfigurable configurable) {
        if (configurable == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(6);
        }
        JBTabbedPane pane = (JBTabbedPane)UIUtil.findComponentOfType((JComponent)configurable.createComponent(), JBTabbedPane.class);
        assert (pane != null);
        assert (pane.getTabCount() > 2);
        JLabel label = (JLabel)pane.getTabComponentAt(2);
        assert (PhpBundle.message("PhpProjectConfigurable.analysis", new Object[0]).equals(label.getText()));
        pane.setSelectedIndex(2);
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownExceptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docExceptions";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUndocumentedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectAnalysisTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUndocumentedExceptions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox mySkipOnEmpty;
        private HyperlinkLabel mySettingsLink;

        private void createUIComponents() {
            this.mySettingsLink = new HyperlinkLabel(PhpBundle.message("exception.analysis.settings.path", new Object[0]));
        }

        private OptionsPanel() {
            this.$$$setupUI$$$();
            this.mySkipOnEmpty.setSelected(PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC);
            this.mySkipOnEmpty.getModel().addChangeListener(e -> {
                PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC = this.mySkipOnEmpty.isSelected();
            });
            this.mySettingsLink.addHyperlinkListener(e -> DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(PhpDocMissingThrowsInspection.getConsumer()));
        }

        private JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.createUIComponents();
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.mySkipOnEmpty = jBCheckBox;
            jBCheckBox.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.doc.throws.option.skip.on.empty.phpdoc"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Additional settings:");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            HyperlinkLabel hyperlinkLabel = this.mySettingsLink;
            jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

