/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpGotoLabelDefinitionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpExchangeExtendsImplementsQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAnnotatorVisitor
extends PhpElementVisitor {
    private final AnnotationHolder holder;
    private static final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();

    public PhpAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public void visitElement(PsiElement element) {
        PsiElement grandParent;
        if (element instanceof LeafPsiElement && PhpPsiUtil.isOfType(element, PhpTokenTypes.PHP_CLOSING_TAG) && "__halt_compiler();".equals(element.getText()) && !((grandParent = element.getParent().getParent()) instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, "__halt_compiler() can only be used from the outermost scope.");
        }
    }

    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        PsiElement child = groupStatement.getFirstChild();
        if (PhpPsiUtil.isOfType(child, PhpElementTypes.EMPTY_INPUT)) {
            this.holder.createWeakWarningAnnotation(child, "Code fragment is too complex to parse. \nThis piece of code will be treated as plain text! \n");
        }
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        PsiElement firstChild;
        PsiElement parent;
        PhpPsiElement nextPsiSibling;
        PhpPsiElement prevPsiSibling;
        PsiElement firstChild2;
        this.checkControlFlow((PhpScopeHolder)namespace);
        if ("\\".equals(namespace.getFQN()) && !namespace.isBraced() && (firstChild2 = namespace.getFirstChild()) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild2, "Global namespace should use braced syntax");
        }
        if (!((prevPsiSibling = namespace.getPrevPsiSibling()) == null || prevPsiSibling instanceof PhpNamespace || prevPsiSibling instanceof PhpDocComment || PhpPsiUtil.isOfType((PsiElement)prevPsiSibling, PhpElementTypes.DECLARE) || PhpPsiUtil.isOfType((PsiElement)prevPsiSibling, PhpElementTypes.HTML))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)prevPsiSibling, "Global code should be enclosed in global namespace declaration");
        }
        if ((nextPsiSibling = namespace.getNextPsiSibling()) != null && !(nextPsiSibling instanceof PhpNamespace) && !(nextPsiSibling instanceof PhpDocComment)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)nextPsiSibling, "Global code should be enclosed in global namespace declaration");
        }
        if (!((parent = namespace.getParent()) instanceof GroupStatement && parent.getParent() instanceof PhpFile || (firstChild = namespace.getFirstChild()) == null)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, "Namespace declarations cannot be nested");
        }
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        for (AssignmentExpression expression : staticStatement.getDeclarations()) {
            PhpPsiElement value = expression.getValue();
            if (value == null || PhpCodeValidationUtil.isAllowedAsStaticValue((PsiElement)value)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, "expression is not allowed as static initializer");
        }
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        PhpPsiElement element = expr.getVariable();
        if (element instanceof Variable && PhpLangUtil.equalsVariableNames("this", ((Variable)element).getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("this.reassignment.is.not.allowed", new Object[0]));
        }
    }

    public void visitPhpExpression(PhpExpression expression) {
        String text;
        PsiElement child;
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER) && PhpPsiUtil.isOfType(child = expression.getFirstChild(), PhpTokenTypes.OCTAL_INTEGER) && ((text = expression.getText()).indexOf(56) >= 0 || text.indexOf(57) >= 0)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, "Invalid octal literal - won't be reported by PHP but will work incorrectly");
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof MultiassignmentExpression) || ((MultiassignmentExpression)parent).getFirstPsiChild() != expression) {
            boolean expectedDelimiter = false;
            for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opCOMMA)) {
                    if (!expectedDelimiter) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, "Cannot use empty array elements in arrays");
                    }
                    expectedDelimiter = false;
                    continue;
                }
                if (!(child instanceof ArrayHashElement) && !PhpPsiUtil.isOfType(child, PhpElementTypes.ARRAY_VALUE)) continue;
                expectedDelimiter = true;
            }
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        ArrayIndex index = expression.getIndex();
        if (index != expression.getValue() && (index == null || index.getTextLength() == 0)) {
            PsiElement parent = expression.getParent();
            if (parent instanceof ArrayAccessExpression || parent instanceof MultiassignmentExpression || parent instanceof ParameterList || parent instanceof FieldReference) {
                return;
            }
            if (parent instanceof AssignmentExpression) {
                PsiElement parentOfParent;
                AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
                if (assignmentExpression.getVariable() == expression) {
                    return;
                }
                if (assignmentExpression.getValue() == expression && (parentOfParent = parent.getParent()) instanceof AssignmentExpression && ((AssignmentExpression)parentOfParent).getVariable() == parent) {
                    return;
                }
                if (PhpWorkaroundUtil.isAssignByReference(assignmentExpression)) {
                    return;
                }
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, "Cannot use [] for reading");
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        PhpType phpType;
        PhpPsiElement value;
        ASTNode node = expr.getNode();
        if (node != null && node.getElementType() == PhpElementTypes.CLONE_EXPRESSION && (value = expr.getValue()) instanceof PhpTypedElement && !(phpType = ((PhpTypedElement)value).getType().global(expr.getProject())).isUndefined() && !phpType.hasUnknown() && !PhpAnnotatorVisitor.methodCloneCanBeCalled(expr, phpType)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, "Call to method __clone from invalid context");
        }
    }

    private static boolean methodCloneCanBeCalled(UnaryExpression expr, PhpType phpType) {
        for (String type : phpType.getTypes()) {
            if (PhpType.isNull((String)type) || PhpType.isMixedType((String)type) || PhpType.isCallableType((String)type)) {
                return true;
            }
            if (PhpType.isPrimitiveType((String)type) && !PhpType.isObject((String)StringUtil.toLowerCase((String)type))) continue;
            Collection classes = PhpIndex.getInstance((Project)expr.getProject()).getClassesByFQN(type);
            if (classes.isEmpty()) {
                return true;
            }
            for (PhpClass clazz : classes) {
                PhpModifier.Access access;
                Method clone = clazz.findMethodByName((CharSequence)"__clone");
                PhpModifier.Access access2 = access = clone == null ? null : clone.getAccess();
                if (clone == null || access == PhpModifier.Access.PUBLIC) {
                    return true;
                }
                Object callerClass = PhpPsiUtil.getParentByCondition((PsiElement)expr, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                String caller = callerClass == null ? null : ((PhpClass)callerClass).getFQN();
                if (caller == null || !PhpLangUtil.equalsClassNames(caller, type) && (access != PhpModifier.Access.PROTECTED || !PhpType.findSuper((String)type, (String)caller, (PhpIndex)PhpIndex.getInstance((Project)expr.getProject())))) continue;
                return true;
            }
        }
        return false;
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        PsiElement rightOperand;
        if (expression instanceof ConcatenationExpression && !(expression.getParent() instanceof ConcatenationExpression)) {
            Annotation concatenation = this.holder.createInfoAnnotation((PsiElement)expression, null);
            concatenation.setTextAttributes(PhpHighlightingData.PHP_CONCATENATION);
        }
        if (expression.getOperationType() == PhpTokenTypes.kwINSTANCEOF && (rightOperand = expression.getRightOperand()) != null) {
            if (PhpAnnotatorVisitor.isFunction(rightOperand)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, rightOperand, "Function call is not allowed here");
            } else if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.CLASS_REFERENCE)) {
                this.highlightInfo(rightOperand.getNode(), PhpHighlightingData.CLASS);
            }
        }
    }

    private static boolean isFunction(@NotNull PsiElement operand) {
        PsiElement[] children;
        if (operand == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        for (PsiElement child : children = operand.getChildren()) {
            if (!PhpPsiUtil.isOfType(child, PhpElementTypes.PARAMETER_LIST)) continue;
            return true;
        }
        return false;
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)expression);
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        List variables = multiassignmentExpression.getVariables();
        for (PhpPsiElement expression : variables) {
            Variable variable;
            if (!(expression instanceof Variable) || !PhpLangUtil.equalsVariableNames("this", (variable = (Variable)expression).getName())) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("this.reassignment.is.not.allowed", new Object[0]));
        }
    }

    public void visitPhpVariable(Variable variable) {
        if (VariableImpl.isVariableVariable(variable)) {
            this.holder.createInfoAnnotation((PsiElement)variable, PhpBundle.message("annotation.variable.variable", new Object[0])).setTextAttributes(PhpHighlightingData.VAR_VAR);
        } else {
            Function fun = (Function)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (fun != null) {
                for (Parameter parameter : fun.getParameters()) {
                    if (!PhpLangUtil.equalsVariableNames(parameter.getNameCS(), variable.getNameCS())) continue;
                    this.highlightInfo(variable.getNameNode(), PhpHighlightingData.PARAMETER);
                    break;
                }
            }
        }
        if (PhpLangUtil.equalsVariableNames("this", variable.getName())) {
            Function f = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class);
            boolean level710plus = PhpProjectConfigurationFacade.getInstance(variable.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710);
            if (f instanceof Method && ((Method)f).isStatic() || !(f instanceof Method) && f != null && !f.isClosure() && level710plus) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, variable.getNameNode(), "Using $this when not in object context");
            }
        }
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        super.visitPhpFunctionCall(reference);
        if (StringUtil.isEmpty((String)reference.getName())) {
            PhpType type;
            Set types;
            PhpPsiElement name = reference.getFirstPsiChild();
            if (!(!(name instanceof Variable) || (types = (type = ((Variable)name).getType().global(name.getProject())).filterUnknown().getTypes()).isEmpty() || types.contains("\\mixed") || types.contains("\\string") || types.contains("\\callable") || types.contains("\\array") || types.stream().anyMatch(PhpType::isPluralType) || reference.multiResolve(false).length != 0)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)name, "Function name must be callable -  a string, Closure or class implementing __invoke, currently " + type.toStringResolved());
            }
        } else {
            ASTNode nameNode = reference.getNameNode();
            if (nameNode != null) {
                if (PhpCompletionContributor.PHP_PREDEFINED_FUNCTIONS.contains(nameNode.getText())) {
                    this.highlightInfo(nameNode, PhpHighlightingData.PREDEFINED_SYMBOL);
                } else {
                    this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION_CALL);
                }
            }
        }
        this.checkCallParamList(reference);
    }

    private void checkCallParamList(FunctionReference reference) {
        PsiElement[] callParams = reference.getParameters();
        int lastUnpacked = Integer.MAX_VALUE;
        for (int i = 0; i < callParams.length; ++i) {
            if (PhpPsiUtil.isOfType(callParams[i].getPrevSibling(), PhpTokenTypes.opVARIADIC)) {
                lastUnpacked = i;
            }
            if (lastUnpacked >= i) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, callParams[i], "Cannot use positional argument after argument unpacking");
        }
    }

    public void visitPhpClassConstantReference(ClassConstantReference reference) {
        ASTNode constantNameNode = reference.getNameNode();
        if (reference.isStatic() && !"class".equalsIgnoreCase(reference.getName())) {
            this.highlightInfo(constantNameNode, PhpHighlightingData.CONSTANT);
        }
        this.checkAccessModifiers((MemberReference)reference);
    }

    public void visitPhpFieldReference(FieldReference reference) {
        PsiElement parent;
        this.checkAccessModifiers((MemberReference)reference);
        PsiElement target = reference.resolve();
        ASTNode nameNode = reference.getNameNode();
        if (nameNode != null) {
            if (target instanceof PhpDocPsiElement) {
                this.highlightInfo(nameNode, PhpHighlightingData.MAGIC_MEMBER_ACCESS);
            } else {
                parent = nameNode.getPsi().getParent();
                if (!(parent instanceof Variable) || !VariableImpl.isVariableVariable((Variable)parent)) {
                    this.highlightInfo(nameNode, reference.getReferenceType().isStatic() ? PhpHighlightingData.STATIC_FIELD : PhpHighlightingData.INSTANCE_FIELD);
                }
            }
        }
        if (target instanceof PhpDocProperty) {
            parent = reference.getParent();
            CharSequence nameCS = ((PhpDocTag)target.getParent()).getNameCS();
            if (nameCS.equals("@property-read")) {
                if (parent instanceof ArrayAccessExpression && parent.getParent() instanceof AssignmentExpression && ((AssignmentExpression)parent.getParent()).getVariable() == reference.getParent() || parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == reference || parent instanceof UnaryExpression && PhpTokenTypes.tsUNARY_POSTFIX_OPS.contains(PsiUtilCore.getElementType((PsiElement)((UnaryExpression)parent).getOperation()))) {
                    if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                        return;
                    }
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, "@property-read");
                }
            } else if (nameCS.equals("@property-write") && (!(parent instanceof AssignmentExpression) || ((AssignmentExpression)parent).getVariable() != reference || parent instanceof SelfAssignmentExpression)) {
                if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                    return;
                }
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, "@property-write");
            }
        }
    }

    private static boolean isFieldAccessLocal(FieldReference reference) {
        PhpExpression classReference = reference.getClassReference();
        return classReference instanceof Variable && "this".contentEquals(((Variable)classReference).getNameCS());
    }

    public void visitPhpMethodReference(MethodReference reference) {
        PhpExpression classReference;
        this.highlightInfo(reference.getNameNode(), reference.isStatic() ? PhpHighlightingData.STATIC_METHOD_CALL : PhpHighlightingData.INSTANCE_METHOD_CALL);
        if (PhpLangUtil.equalsFunctionNames("__clone", reference.getNameCS()) && (classReference = reference.getClassReference()) != null && !PhpLangUtil.equalsClassNames("parent", classReference.getName())) {
            ASTNode nameNode = reference.getNameNode();
            if (nameNode == null) {
                return;
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "An object's __clone() method cannot be called directly");
            return;
        }
        this.checkAccessModifiers((MemberReference)reference);
        this.checkCallParamList((FunctionReference)reference);
    }

    private void checkAccessModifiers(MemberReference reference) {
        PhpClass current;
        PhpModifier.Access access;
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null) {
            return;
        }
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element instanceof PhpDocPsiElement) {
            this.highlightInfo(reference.getNameNode(), PhpHighlightingData.MAGIC_MEMBER_ACCESS);
        }
        if (!(element instanceof PhpClassMember)) {
            return;
        }
        PhpClass declaringClass = ((PhpClassMember)element).getContainingClass();
        if (PhpAnnotatorVisitor.isReferenceNotAccessibleFrom(reference, declaringClass, access = ((PhpElementWithModifier)element).getModifier().getAccess(), current = PhpAnnotatorVisitor.resolveClassReference(reference, access))) {
            String classReferenceName;
            boolean hasMagic;
            String magicName = reference instanceof MethodReference ? (reference.isStatic() ? "__callStatic" : "__call") : (reference instanceof FieldReference ? (((FieldReference)reference).isWriteAccess() ? "__set" : "__get") : null);
            boolean bl = hasMagic = declaringClass != null && PhpCodeInsightUtil.hasMagicMethod(declaringClass.getType(), PhpIndex.getInstance((Project)element.getProject()), magicName);
            if (!hasMagic && current != null && (PhpLangUtil.isThisReference(classReferenceName = classReference.getName()) || PhpLangUtil.equalsClassNames(classReferenceName, current.getNameCS()))) {
                Method currentMethod = (Method)PsiTreeUtil.getParentOfType((PsiElement)reference, Method.class);
                boolean bl2 = hasMagic = (currentMethod == null || !PhpLangUtil.equalsMethodNames(magicName, currentMethod.getNameCS())) && PhpCodeInsightUtil.hasMagicMethod(current.getType(), PhpIndex.getInstance((Project)element.getProject()), magicName);
            }
            if (hasMagic) {
                this.holder.createWarningAnnotation(nameNode, "Member has " + access + " access, but class has magic method " + magicName);
            } else {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Member has " + access + " access");
            }
        }
    }

    @Nullable
    public static PhpClass resolveClassReference(MemberReference reference, PhpModifier.Access access) {
        PhpClass current = PhpClassImpl.getContainingClass((PhpPsiElement)reference);
        return current == null && access != PhpModifier.Access.PUBLIC ? PhpAnnotatorVisitor.resolveThis((PsiElement)reference) : current;
    }

    public static boolean isReferenceNotAccessibleFrom(@NotNull MemberReference reference, @Nullable PhpClass declaringClass, @NotNull PhpModifier.Access access, @Nullable PhpClass current) {
        boolean highlight;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (access == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        boolean bl = highlight = current == null && access != PhpModifier.Access.PUBLIC;
        if (current != null && declaringClass != null && current != declaringClass) {
            if (access == PhpModifier.Access.PRIVATE && (!current.isTrait() && !PhpClassHierarchyUtils.isMyTrait((PhpClass)current, (PhpClass)declaringClass, null) || !declaringClass.isTrait() && !PhpClassHierarchyUtils.isMyTrait((PhpClass)declaringClass, (PhpClass)current, null))) {
                highlight = true;
            } else if (!(access != PhpModifier.Access.PROTECTED || current.isTrait() || declaringClass.isTrait() || PhpClassHierarchyUtils.isMyTrait((PhpClass)declaringClass, (PhpClass)current, null))) {
                boolean bl2 = highlight = !PhpClassHierarchyUtils.isSuperClass((PhpClass)declaringClass, (PhpClass)current, (boolean)true);
                if (highlight) {
                    boolean[] commonSuper = new boolean[]{false};
                    PhpClassHierarchyUtils.processSuperClasses((PhpClass)current, (boolean)true, (boolean)true, aClass -> {
                        if (reference == null) {
                            PhpAnnotatorVisitor.$$$reportNull$$$0(18);
                        }
                        if (PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\object", aClass.getFQN())) {
                            return true;
                        }
                        if (PhpClassHierarchyUtils.isSuperClass((PhpClass)aClass, (PhpClass)declaringClass, (boolean)true) && aClass.findOwnMethodByName((CharSequence)reference.getName()) != null) {
                            commonSuper[0] = true;
                        }
                        return !commonSuper[0];
                    });
                    boolean bl3 = highlight = !commonSuper[0];
                }
                if (highlight && current.isTrait() && !declaringClass.isTrait()) {
                    Collection usages = PhpIndex.getInstance((Project)reference.getProject()).getTraitUsages(current);
                    highlight = usages.stream().noneMatch(usage -> PhpClassHierarchyUtils.isSuperClass((PhpClass)declaringClass, (PhpClass)usage, (boolean)true));
                }
            }
        }
        return highlight;
    }

    @Nullable
    public static PhpClass resolveThis(@NotNull PsiElement position) {
        PhpDocType typeRef;
        PhpNamedElement aThis;
        if (position == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if ((aThis = (PhpNamedElement)ContainerUtil.getFirstItem(VariableImpl.collectDeclarations(position, false, "this"))) instanceof PhpDocVariable && (typeRef = (PhpDocType)PhpPsiUtil.getChildByCondition(aThis.getParent(), (Condition<? super PsiElement>)PhpDocType.INSTANCEOF)) != null) {
            return (PhpClass)typeRef.resolve();
        }
        return null;
    }

    public void visitPhpFile(PhpFile file) {
        PsiElement parent;
        PsiElement html;
        PhpNamespace namespace;
        this.checkControlFlow((PhpScopeHolder)file);
        file.accept((PsiElementVisitor)new PhpDeclarationDuplicateCheckerVisitor());
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)file, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        this.checkNamespaceSyntax(groupStatement);
        if (groupStatement != null && (namespace = (PhpNamespace)PhpPsiUtil.getChildByCondition((PsiElement)groupStatement, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) != null && (html = PhpPsiUtil.getChildOfType(parent = namespace.getParent(), PhpElementTypes.HTML)) != null && !PhpAnnotatorVisitor.isShebang(html)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, html, "No content allowed before namespace declaration");
        }
    }

    private void checkNamespaceSyntax(GroupStatement groupStatement) {
        if (groupStatement != null) {
            PsiElement[] children = groupStatement.getChildren();
            Boolean isBraced = null;
            for (PsiElement it : children) {
                if (!(it instanceof PhpNamespace)) continue;
                PhpNamespace namespace = (PhpNamespace)it;
                String text = "Multiple namespaces in a file should use same (preferably braced) syntax";
                if (isBraced == null) {
                    isBraced = namespace.isBraced();
                }
                if (isBraced.booleanValue() == namespace.isBraced()) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, namespace.getFirstChild(), text);
            }
        }
    }

    public void visitPhpClassReference(ClassReference classReference) {
        Object element;
        String referenceText = classReference.getText();
        if ("self".equalsIgnoreCase(referenceText) || "parent".equalsIgnoreCase(referenceText) || "static".equalsIgnoreCase(referenceText)) {
            this.highlightInfo(classReference.getNode(), PhpHighlightingData.KEYWORD);
        } else if (PhpTargetElementEvaluator.getElementByReference((PsiReference)classReference) != null) {
            this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.ALIAS_REFERENCE);
        } else {
            PsiElement parent = classReference.getParent();
            IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
            if (parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.FIELD_REFERENCE || parentType == PhpElementTypes.CLASS_CONSTANT_REFERENCE) {
                this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.CLASS);
            }
        }
        if ("static".equalsIgnoreCase(referenceText) && (element = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element1 -> PhpPsiUtil.isOfType(element1, PhpElementTypes.PARAMETER_DEFAULT_VALUE) || PhpPsiUtil.isOfType(element1, PhpElementTypes.CLASS_CONSTANTS) || PhpPsiUtil.isOfType(element1, PhpElementTypes.CLASS_FIELDS)))) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, classReference.getNode(), "static:: is not allowed in compile-time constants");
        }
    }

    public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
        PsiReference firstReference = (PsiReference)ArrayUtil.getFirstElement((Object[])reference.getReferences());
        if (firstReference != null && PhpTargetElementEvaluator.getElementByReference(firstReference) != null) {
            this.highlightInfo(reference.getFirstChild().getNode(), PhpHighlightingData.ALIAS_REFERENCE);
        }
    }

    public void visitPhpUseList(PhpUseList useList) {
        PsiElement trailingComma;
        PsiElement grandParent;
        PsiElement parent = useList.getParent();
        PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof Function) && !(parent instanceof PhpClass) && !(parent instanceof GroupStatement) || parent instanceof GroupStatement && !(grandParent instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)useList, "The 'use' keyword must be declared in the outermost scope of a file (the global scope) or inside namespace declarations");
        } else if (!(parent instanceof Function || parent instanceof PhpClass || PhpProjectConfigurationFacade.getInstance(useList.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP720) || (trailingComma = PhpUseListImpl.getTrailingComma(useList)) == null)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, trailingComma, "Trailing comma is not allowed");
        }
        if (parent instanceof Function && ((Function)parent).isClosure()) {
            for (Variable variable : PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF)) {
                if (!"this".equals(variable.getName())) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, "Cannot use $this as lexical variable");
            }
        }
    }

    public void visitPhpUse(PhpUse expression) {
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)expression, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
        PhpReference reference = expression.getTargetReference();
        if (reference != null) {
            String alias;
            PsiElement resolvedElement;
            if (reference.getImmediateNamespaceName().startsWith("\\") && PhpPsiUtil.getParentByCondition((PsiElement)expression, true, PhpUseImpl.USE_BRACES_CONDITION, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, "Absolute reference is not allowed");
            }
            if ((resolvedElement = reference.resolve()) instanceof PhpClass) {
                PhpClass resolvedClass = (PhpClass)resolvedElement;
                boolean isTrait = resolvedClass.isTrait();
                if (expression.isTraitImport() && containingClass != null) {
                    if (!isTrait) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), "Trait expected, class found");
                    }
                    if (containingClass.isInterface()) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), "Cannot use traits inside of interfaces");
                    }
                }
            }
            if (PhpLangUtil.isPhpReservedClassName(alias = expression.getAliasName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNameNode(), PhpBundle.message("annotator.special.class.name", reference.getText(), alias));
            }
        }
    }

    public void visitPhpConstantReference(ConstantReference constant) {
        if (PhpLangUtil.isBuiltInConstant(constant)) {
            this.holder.createInfoAnnotation((PsiElement)constant, null).setTextAttributes(PhpHighlightingData.KEYWORD);
        } else {
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
        }
    }

    public void visitPhpClass(final PhpClass clazz) {
        PhpClass superClass;
        ASTNode nameNode = clazz.getNameNode();
        final boolean anInterface = clazz.isInterface();
        String className = clazz.getName();
        if (PhpLangUtil.isPhpReservedClassName(className)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("annotator.reserved.class.name", className));
        }
        this.highlightInfo(nameNode, anInterface ? PhpHighlightingData.INTERFACE : PhpHighlightingData.CLASS);
        if (PhpPsiUtil.getParentByCondition((PsiElement)clazz, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Class declarations may not be nested");
        }
        if ((superClass = clazz.getSuperClass()) != null && superClass.isFinal()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Class may not inherit from final class");
        }
        ExtendsList extendsList = clazz.getExtendsList();
        List referenceElements = extendsList.getReferenceElements();
        HashSet extendedClasses = ContainerUtil.newHashSet();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.isPhpReservedClassName(it.getName()) && it.getImmediateNamespaceName().isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("annotator.reserved.class.name", it.getName()));
            } else if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, (anInterface ? "Interface" : "Class") + " should not extend itself");
            }
            PsiElement element = it.resolve();
            if (element instanceof PhpClass && ((PhpClass)element).isTrait() && !clazz.isTrait()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, "Class cannot extend from trait");
            }
            if (!anInterface) continue;
            if (extendedClasses.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, "Interface cannot extend previously extended interface");
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, extendedClasses);
        }
        this.checkClassRefsOfAppropriateType(clazz, anInterface, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, "A trait cannot extend a class");
        }
        if (extendsList.getFirstChild() != null && referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, "Empty extends list");
        }
        ImplementsList implementsList = clazz.getImplementsList();
        referenceElements = implementsList.getReferenceElements();
        HashSet implementedInterfaces = ContainerUtil.newHashSet();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, "Class should not implement itself");
            }
            if (implementedInterfaces.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, "Class cannot implement previously implemented interface");
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, implementedInterfaces);
        }
        this.checkClassRefsOfAppropriateType(clazz, true, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, "A trait cannot implement an interface");
        }
        if (implementsList.getFirstChild() != null && referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, "Empty implements list");
        }
        PhpClassHierarchyUtils.processMethods((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyMethodProcessor)new PhpClassHierarchyUtils.HierarchyMethodProcessor(){
            final Set<String> methodNames = new THashSet();

            public boolean process(Method method, PhpClass subClass, PhpClass baseClass) {
                String name = method.getName().toLowerCase();
                if (!StringUtil.isEmpty((String)name)) {
                    if (this.methodNames.contains(name)) {
                        ASTNode nameNode = method.getNameNode();
                        PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Method with same name already defined in this class");
                    }
                    this.methodNames.add(name);
                }
                return true;
            }
        }, (boolean)true);
        PhpClassHierarchyUtils.processFields((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyFieldProcessor)new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Set<String> propNames = new THashSet();
            final Set<String> fieldNames = new THashSet();
            final Set<String> constantNames = new THashSet();

            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                Set<String> names = field.isConstant() ? this.constantNames : (PhpPsiUtil.getParentByCondition((PsiElement)field, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null ? this.propNames : this.fieldNames);
                String name = field.getName();
                if (!StringUtil.isEmpty((String)name)) {
                    if (names.contains(name)) {
                        ASTNode nameNode = field.getNameNode();
                        PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, (field.isConstant() ? "Constant" : "Field") + " with same name already defined in this class");
                    }
                    names.add(name);
                }
                if (subClass.isInterface() && !(field instanceof PhpDocProperty) && !field.isConstant()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, (PsiElement)field, "Interfaces may not include member variables");
                }
                return true;
            }
        }, (boolean)true);
        PhpClassHierarchyUtils.processFields((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyFieldProcessor)new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Map<String, Pair<Field, PhpModifier.Access>> classConstants = new THashMap();
            final Set<String> myStaticSet = new THashSet();
            final Set<String> myNonStaticSet = new THashSet();
            final Map<String, Pair<Field, PhpModifier.Access>> myFieldMap = new THashMap();

            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                if (field instanceof PhpDocProperty) {
                    return false;
                }
                if (field instanceof PhpClassImpl.MyRenamableFakePsiElement) {
                    return true;
                }
                if (clazz.getContainingFile() != field.getContainingFile()) {
                    return true;
                }
                String fieldName = field.getName();
                PhpModifier modifier = field.getModifier();
                PhpModifier.Access superAccess = modifier.getAccess();
                if (field.isConstant()) {
                    ASTNode nameNode = null;
                    if (this.classConstants.containsKey(fieldName)) {
                        PhpModifier.Access childAccess;
                        Field f = (Field)this.classConstants.get((Object)fieldName).first;
                        if (f != null) {
                            nameNode = f.getNameNode();
                        }
                        if (anInterface || subClass.isInterface()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Cannot inherit previously-inherited or override constant " + fieldName + " from interface " + subClass.getName());
                        }
                        if (superAccess.isWeakerThan(childAccess = (PhpModifier.Access)this.classConstants.get((Object)fieldName).second)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Access level to " + clazz.getName() + "::" + fieldName + " must be " + superAccess + " (as in class " + subClass.getName() + ") or weaker");
                            return false;
                        }
                    } else {
                        this.classConstants.put(fieldName, (Pair<Field, PhpModifier.Access>)Pair.create((Object)field, (Object)superAccess));
                    }
                } else {
                    ASTNode nameNode = null;
                    if (this.myFieldMap.containsKey(fieldName)) {
                        PhpModifier.Access childAccess;
                        Field f = (Field)this.myFieldMap.get((Object)fieldName).first;
                        if (f != null) {
                            nameNode = f.getNameNode();
                        }
                        if (superAccess.isWeakerThan(childAccess = (PhpModifier.Access)this.myFieldMap.get((Object)fieldName).second)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Access level to " + clazz.getName() + "::$" + fieldName + " must be " + superAccess + " (as in class " + subClass.getName() + ") or weaker");
                            return false;
                        }
                        if (subClass.isTrait() && !baseClass.isTrait()) {
                            String field2;
                            PsiElement v;
                            PsiElement value = field.getDefaultValue();
                            String field1 = field.getModifier().getAccess() + (value != null ? value.getText() : "");
                            PsiElement psiElement = v = f != null ? f.getDefaultValue() : null;
                            String string = f != null ? f.getModifier().getAccess() + (v != null ? v.getText() : null) : (field2 = null);
                            if (!field1.equals(field2)) {
                                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, baseClass.getName() + " and " + subClass.getName() + " define the same property " + fieldName);
                            }
                        }
                    } else {
                        this.myFieldMap.put(fieldName, (Pair<Field, PhpModifier.Access>)Pair.create((Object)field, (Object)superAccess));
                    }
                    if (this.myStaticSet.contains(fieldName)) {
                        if (!modifier.isStatic() && !modifier.isPrivate()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Cannot redeclare non static " + subClass.getName() + "::$" + fieldName + " as static " + clazz.getName() + "::$" + fieldName);
                            return false;
                        }
                    } else if (this.myNonStaticSet.contains(fieldName)) {
                        if (modifier.isStatic() && !modifier.isPrivate()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Cannot redeclare static " + subClass.getName() + "::$" + fieldName + " as non static " + clazz.getName() + "::$" + fieldName);
                            return false;
                        }
                    } else if (modifier.isStatic()) {
                        this.myStaticSet.add(fieldName);
                    } else {
                        this.myNonStaticSet.add(fieldName);
                    }
                }
                return true;
            }
        }, (boolean)false);
    }

    private static void addAllSuperInterfaces(@NotNull ClassReference reference, @NotNull Set<String> interfaces) {
        PsiElement phpClass;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (interfaces == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if ((phpClass = reference.resolve()) instanceof PhpClass && !interfaces.contains(((PhpClass)phpClass).getFQN())) {
            PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)((PhpClass)phpClass), (boolean)true, (boolean)true, superInterface -> {
                if (interfaces == null) {
                    PhpAnnotatorVisitor.$$$reportNull$$$0(17);
                }
                interfaces.add(superInterface.getFQN());
                return true;
            });
        }
    }

    private static void createErrorAnnotation(AnnotationHolder holder, @Nullable ASTNode node, @NotNull String message) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        if (node != null && node.getTextLength() != 0) {
            holder.createErrorAnnotation(node, message);
        }
    }

    private static Annotation createErrorAnnotation(AnnotationHolder holder, @Nullable PsiElement e, @NotNull String message) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        if (e != null && e.getTextLength() != 0) {
            return holder.createErrorAnnotation(e, message);
        }
        return null;
    }

    public void checkControlFlow(PhpScopeHolder scope) {
        PhpInstruction[] instructions = scope.getControlFlow().getInstructions();
        if (instructions == PhpControlFlowImpl.EMPTY) {
            PsiElement mark = scope.getFirstChild();
            if (mark instanceof GroupStatement) {
                mark = mark.getFirstChild();
            }
            this.holder.createWarningAnnotation(mark, "Control flow is too big to analyse");
        } else {
            THashSet labels = new THashSet();
            for (PhpInstruction instruction : instructions) {
                if (!(instruction instanceof PhpGotoLabelDefinitionInstruction)) continue;
                PhpGotoLabel label = ((PhpGotoLabelDefinitionInstruction)instruction).getLabel();
                String labelName = label.getName();
                if (labels.contains(labelName)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)label, "Label with same name already defined in current scope");
                    continue;
                }
                labels.add(labelName);
            }
        }
    }

    public void visitPhpFunction(Function function) {
        this.checkControlFlow((PhpScopeHolder)function);
        ASTNode nameNode = function.getNameNode();
        if (!function.isClosure()) {
            PsiElement firstChild = function.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwSTATIC)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, "Anonymous function expected");
            }
            this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
            PsiElement parent = function.getParent();
            if (parent instanceof PhpExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && nameNode != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Anonymous function expected");
            }
        }
        this.checkParametersRedefinition(function);
        PhpReturnType returnTypeElement = function.getReturnType();
        if (returnTypeElement != null) {
            this.checkInvalidClassName((PsiElement)returnTypeElement.getClassReference());
        }
    }

    public void visitPhpMethod(Method method) {
        CharSequence name;
        this.checkControlFlow((PhpScopeHolder)method);
        boolean hasBody = PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class) != null;
        boolean isAbstract = method.isAbstract();
        ASTNode nameNode = method.getNameNode();
        this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
        if ((!isAbstract && !hasBody || isAbstract && hasBody) && nameNode != null) {
            PhpClass clazz = method.getContainingClass();
            if (clazz != null && clazz.isInterface() && hasBody) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Interface method can't have body");
            } else {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "Method should either have body or be abstract");
            }
        }
        PsiElement last = method.getLastChild();
        if (!method.isAbstract() && last instanceof LeafPsiElement && last.getText() == ";") {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, last, "Method should not be finished with ';'");
        }
        PhpAnnotatorVisitor.checkMemberModifiers((PhpClassMember)method, this.holder);
        PhpReturnType returnType = method.getReturnType();
        if (nameNode != null && returnType != null && (PhpLangUtil.equalsMethodNames("__construct", name = method.getNameCS()) || PhpLangUtil.equalsMethodNames("__destruct", name) || PhpLangUtil.equalsMethodNames("__clone", name))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, "Return type declaration is not allowed");
        }
        if (returnType != null && PhpPsiUtil.isOfType(returnType.getClassReference().getFirstChild(), PhpTokenTypes.kwSTATIC)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, "'static' is not allowed in return type declaration");
        }
        if (returnType != null) {
            this.checkInvalidClassName((PsiElement)returnType.getClassReference());
        }
        if (nameNode != null && PhpLangUtil.equalsMethodNames("__clone", method.getNameCS()) && method.getParameters().length != 0) {
            ParameterList parameters = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            assert (parameters != null);
            PhpClass containingClass = method.getContainingClass();
            String className = containingClass != null ? containingClass.getName() : "";
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameters, "Method " + className + "::__clone() cannot accept any arguments");
        }
        this.checkParametersRedefinition((Function)method);
    }

    private void checkParametersRedefinition(@NotNull Function function) {
        Parameter[] parameters;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        if (PhpProjectConfigurationFacade.getInstance(function.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP700) && (parameters = function.getParameters()).length > 1) {
            if (parameters.length == 2 && parameters[0].getName().equals(parameters[1].getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameters[1], "Redefinition of parameters is not allowed");
            } else {
                HashSet duplicates = ContainerUtil.newHashSet();
                Arrays.stream(parameters).filter(parameter -> !duplicates.add(parameter.getName())).forEach(parameter -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, "Redefinition of parameters is not allowed"));
            }
        }
    }

    public void visitPhpField(Field field) {
        PsiElement defaultValue;
        PhpClass aClass = field.getContainingClass();
        assert (aClass != null);
        ASTNode nameNode = field.getNameNode();
        if (field.isConstant()) {
            if (aClass.isTrait()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)field, "Traits cannot have constants");
            }
            if (PhpTokenTypes.kwCLASS.equals(PsiUtilCore.getElementType((ASTNode)nameNode))) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, "A class constant must not be called 'class'; it is reserved for class name fetching");
            }
        } else {
            this.highlightInfo(nameNode, field.getModifier().isStatic() ? PhpHighlightingData.STATIC_FIELD : PhpHighlightingData.INSTANCE_FIELD);
        }
        if ((defaultValue = field.getDefaultValue()) != null) {
            if (field.isConstant()) {
                this.highlightInfo(nameNode, PhpHighlightingData.CONSTANT);
                if (!PhpCodeValidationUtil.isAllowedAsClassConstantValue(defaultValue)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "expression is not allowed as class constant value");
                }
            } else if (!PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "expression is not allowed as field default value");
            }
        }
        if (!aClass.isInterface()) {
            PhpAnnotatorVisitor.checkMemberModifiers((PhpClassMember)field, this.holder);
        }
    }

    public void visitPhpConstant(Constant constant) {
        if (!(constant instanceof PhpDefine)) {
            PhpNamedElement namedElement;
            String constantName = constant.getName();
            if (PhpLangUtil.isBuiltInConstant(constantName)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, "Cannot redeclare constant " + constantName);
            }
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
            PsiElement value = constant.getValue();
            if (value != null && !PhpCodeValidationUtil.isAllowedAsConstantValue(value)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value, "expression is not allowed as constant value");
            }
            if ((namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)constant, true, (Condition<? super PsiElement>)PhpNamedElement.INSTANCEOF)) != null && !(namedElement instanceof PhpNamespace) || PhpPsiUtil.getParentByCondition((PsiElement)constant, true, (Condition<? super PsiElement>)ControlStatement.INSTANCEOF) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, "Constants defined using the const keyword must be declared at the top-level scope");
            }
        }
    }

    public void visitPhpBreak(@NotNull PhpBreak breakStatement) {
        if (breakStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        PhpAnnotatorVisitor.checkBreakOrContinue((StatementWithArgument)breakStatement, this.holder);
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        PhpAnnotatorVisitor.checkBreakOrContinue((StatementWithArgument)continueStatement, this.holder);
    }

    public void visitPhpModifierList(PhpModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        ASTNode parentNode = parent.getNode();
        IElementType parentType = parentNode.getElementType();
        if (PhpElementTypes.CLASS_FIELDS == parentType) {
            PhpAnnotatorVisitor.checkFieldsModifiers(modifierList, this.holder);
        } else {
            super.visitPhpModifierList(modifierList);
        }
    }

    public void visitPhpNewExpression(NewExpression expression) {
        ClassReference classReference = expression.getClassReference();
        PhpClass containingClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpClass.class);
        if (classReference != null && !PhpLangUtil.equalsClassNames("static", classReference.getName())) {
            PsiElement resolvedElement;
            Collection<? extends PhpNamedElement> elements = ClassReferenceImpl.resolveGlobal((PhpReference)classReference, classReference.getName(), classReference.getNamespaceName(), true);
            PsiElement psiElement = resolvedElement = elements.size() == 1 ? (PsiElement)elements.iterator().next() : null;
            if (resolvedElement instanceof PhpClass) {
                PhpClass clazz = (PhpClass)resolvedElement;
                if (clazz.isInterface()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.interface", clazz.getName()));
                } else if (clazz.isTrait() && !PhpLangUtil.equalsClassNames("self", classReference.getName())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.trait", clazz.getName()));
                } else if (clazz.isAbstract()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.abstract", clazz.getName()));
                }
                Method constructor = clazz.getConstructor();
                if (constructor != null && (clazz = constructor.getContainingClass()) != null) {
                    boolean insideClass = containingClass != null && (containingClass.equals(clazz) || clazz.isTrait() && ArrayUtil.contains((Object)clazz, (Object[])containingClass.getTraits()));
                    boolean insideClassHierarchy = containingClass != null && (PhpClassHierarchyUtils.isSuperClass((PhpClass)clazz, (PhpClass)containingClass, (boolean)false) || PhpClassHierarchyUtils.isSuperClass((PhpClass)containingClass, (PhpClass)clazz, (boolean)false));
                    PhpModifier.Access access = constructor.getAccess();
                    if (!insideClass && access.isPrivate() || !insideClassHierarchy && !insideClass && access.isProtected()) {
                        String name = constructor.getContainingClass().getName();
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, "Call to " + access + " " + name + "::__construct() from invalid context");
                    }
                }
            }
        }
    }

    public void visitPhpThrow(PhpThrow throwStatement) {
        PsiElement argument = throwStatement.getArgument();
        if (argument instanceof PhpTypedElement && !PhpAnnotatorVisitor.isCouldBeDerivedFromException(throwStatement.getProject(), (PhpTypedElement)argument)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, argument, PhpBundle.message("inspection.wrong.exception.type.problem.throw", new Object[0]));
        }
    }

    public void visitPhpCatch(Catch phpCatch) {
        Collection exceptionTypes = phpCatch.getExceptionTypes();
        for (ClassReference exceptionType : exceptionTypes) {
            if (exceptionType == null || PhpAnnotatorVisitor.isCouldBeDerivedFromException(phpCatch.getProject(), (PhpTypedElement)exceptionType)) continue;
            this.holder.createWarningAnnotation((PsiElement)exceptionType, PhpBundle.message("inspection.wrong.exception.type.problem.catch", new Object[0]));
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        for (PhpPsiElement psiChild = expression.getFirstPsiChild(); psiChild != null; psiChild = psiChild.getNextPsiSibling()) {
            IElementType type = psiChild.getFirstChild().getNode().getElementType();
            if (psiChild instanceof Variable && psiChild.getFirstPsiChild() == null || psiChild.getFirstPsiChild() instanceof Variable || psiChild.getFirstPsiChild() instanceof ArrayAccessExpression || psiChild.getFirstPsiChild() instanceof StringLiteralExpression || !PhpTokenTypes.DOLLAR_LBRACE.equals(type) && !((Object)PhpStubElementTypes.VARIABLE).equals(type) && (psiChild.getFirstPsiChild() instanceof FieldReference || psiChild.getFirstPsiChild() instanceof MethodReference || psiChild.getFirstPsiChild() instanceof FunctionReference)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)psiChild, "Only simple expressions are allowed");
        }
        super.visitPhpStringLiteralExpression(expression);
    }

    public void visitPhpGotoLabel(PhpGotoLabel label) {
        ASTNode nameNode = label.getNameNode();
        if (nameNode != null) {
            Annotation annotation = this.holder.createInfoAnnotation(nameNode, null);
            annotation.setTextAttributes(PhpHighlightingData.GOTO_LABEL);
        }
    }

    public static boolean isCouldBeDerivedFromException(@NotNull Project project, @NotNull PhpTypedElement typedElement) {
        PhpIndex phpIndex;
        PhpType completedType;
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        if (typedElement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        if (!PhpType.THROWABLE.isConvertibleFrom(completedType = typedElement.getType().global(project), phpIndex = PhpIndex.getInstance((Project)project))) {
            for (String type : completedType.getTypes()) {
                if (PhpType.isPrimitiveType((String)type)) continue;
                if (phpIndex.getClassesByFQN(type).isEmpty()) {
                    return true;
                }
                if (phpIndex.getInterfacesByFQN(type).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void visitPhpParameter(Parameter parameter) {
        Object method = PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Method.INSTANCEOF);
        if (method instanceof PhpDocMethod) {
            return;
        }
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            PhpType defaultValueType;
            if (parameter.isVariadic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "Variadic parameter cannot have a default value");
            } else if (defaultValue instanceof PhpTypedElement && !PhpType.intersects((PhpType)PhpType.NULL, (PhpType)(defaultValueType = ((PhpTypedElement)defaultValue).getType().globalLocationAware((PsiElement)parameter)))) {
                PhpType parameterType = parameter.getDeclaredType().globalLocationAware((PsiElement)parameter);
                boolean primitiveType = parameterType.getTypes().stream().allMatch(PhpType::isPrimitiveType);
                if (!(parameterType.isEmpty() || primitiveType && PhpAnnotatorVisitor.isCompatible(parameterType, defaultValueType, defaultValue))) {
                    if (primitiveType) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "Argument passed must be of the type " + parameterType + ", " + defaultValueType + " given");
                    } else {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "Default value for parameters with a class type can only be NULL");
                    }
                }
            }
            if (!PhpCodeValidationUtil.isAllowedAsParameterDefaultValue(defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, "expression is not allowed as parameter default value");
            }
        }
        if (parameter.isVariadic() && parameter.getNextPsiSibling() != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, "Only the last parameter can be variadic");
        }
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.checkInvalidClassName(child);
        }
        if ("this".equals(parameter.getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, "Cannot use $this as parameter");
        }
        this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.PARAMETER);
    }

    private static boolean isCompatible(@NotNull PhpType parameterType, @NotNull PhpType defaultValueType, @NotNull PsiElement defaultValue) {
        if (parameterType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(13);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(14);
        }
        if ((defaultValue instanceof ConstantReference || defaultValue instanceof ClassConstantReference || defaultValue instanceof ArrayAccessExpression || defaultValue instanceof ArrayCreationExpression) && (!(defaultValue instanceof ConstantReference) || !PhpLangUtil.isTrue((ConstantReference)defaultValue) && !PhpLangUtil.isFalse((ConstantReference)defaultValue))) {
            if (PhpType.intersects((PhpType)PhpType.FLOAT_INT, (PhpType)parameterType) && PhpType.intersects((PhpType)PhpType.STRING, (PhpType)defaultValueType)) {
                return false;
            }
            return parameterType.isConvertibleFrom(defaultValueType, PhpIndex.getInstance((Project)defaultValue.getProject()));
        }
        boolean isFloat = PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)parameterType);
        return PhpType.intersects((PhpType)(isFloat ? PhpType.FLOAT_INT : parameterType), (PhpType)defaultValueType);
    }

    private void checkInvalidClassName(PsiElement element) {
        String type;
        if (element instanceof ClassReference && "\\".equals(((ClassReference)element).getImmediateNamespaceName()) && PhpLangUtil.isPhpReservedClassName(PhpLangUtil.toName(type = element.getText()))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("annotator.invalid.class.name", type));
        }
    }

    private static void checkBreakOrContinue(StatementWithArgument breakOrContinue, AnnotationHolder holder) {
        PsiElement argument = breakOrContinue.getArgument();
        Integer arg = argument == null ? Integer.valueOf(1) : PhpCodeInsightUtil.toInt(argument);
        Statement loopStatement = arg != null ? PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, arg) : PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, 1);
        if (loopStatement == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)breakOrContinue, PhpBundle.message("annotator.cannot.break.continue", arg != null ? arg : "any"));
        }
    }

    private static void checkMemberModifiers(PhpClassMember member, AnnotationHolder holder) {
        PhpPsiElement modifierList = member instanceof Method ? member.getFirstPsiChild() : member.getParent().getFirstChild();
        ASTNode[] nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS);
        int staticMod = 0;
        int visibilityMod = 0;
        int abstractnessMod = 0;
        int finalityMod = 0;
        for (ASTNode node : nodes) {
            PhpModifier modifier = member.getModifier();
            IElementType type = node.getElementType();
            if (type == PhpTokenTypes.kwSTATIC) {
                ++staticMod;
            } else if (type == PhpTokenTypes.kwABSTACT) {
                if (finalityMod > 0 || modifier.isPrivate()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), "Abstract modifier is not allowed here");
                }
                ++abstractnessMod;
            } else if (type == PhpTokenTypes.kwFINAL) {
                if (abstractnessMod > 0) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), "Final modifier is not allowed here");
                }
                ++finalityMod;
            } else if (PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(type)) {
                ++visibilityMod;
            }
            PhpClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && (abstractnessMod > 0 || finalityMod > 0 || visibilityMod > 0 && !modifier.isPublic())) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), "Access type for interface member must be omitted");
                continue;
            }
            if (staticMod <= 1 && abstractnessMod <= 1 && finalityMod <= 1 && visibilityMod <= 1) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), "Multiple modifiers are not allowed");
        }
    }

    private static void checkFieldsModifiers(PhpModifierList modifierList, AnnotationHolder holder) {
        ASTNode finalNode;
        ASTNode modifierListNode = modifierList.getNode();
        ASTNode abstractNode = modifierListNode.findChildByType(PhpTokenTypes.kwABSTACT);
        if (abstractNode != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, abstractNode, "Fields cannot be declared abstract");
        }
        if ((finalNode = modifierListNode.findChildByType(PhpTokenTypes.kwFINAL)) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, finalNode, "Fields cannot be declared final");
        }
    }

    private void checkClassRefsOfAppropriateType(PhpClass clazz, boolean expectingInterfaces, @NotNull List<ClassReference> referenceElements) {
        if (referenceElements == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(15);
        }
        for (ClassReference classRef : referenceElements) {
            PsiElement element = classRef.resolve();
            if (!(element instanceof PhpClass) || ((PhpClass)element).isInterface() == expectingInterfaces) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classRef, PhpBundle.message(expectingInterfaces ? "php.annotator.expecting.interface" : "php.annotator.expecting.class", new Object[0])).registerFix((IntentionAction)new PhpExchangeExtendsImplementsQuickFix(clazz, classRef));
        }
    }

    public void visitPhpYield(PhpYield element) {
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (function == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, "The 'yield' expression can only be used inside a function");
        } else {
            PhpType declaredType;
            PhpReturnType returnType = function.getReturnType();
            if (returnType != null && !PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)(declaredType = function.getDeclaredType().globalLocationAware((PsiElement)element))) && !PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.PROBABLY_GENERATOR_TYPE, (PhpType)declaredType)) {
                String type = declaredType.toStringRelativized(function.getNamespaceName());
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, "Generators may only declare a return type of Generator, Iterator or Traversable, or iterable, " + type + " is not permitted");
            }
        }
    }

    public void visitPhpStatement(Statement statement) {
        if (statement instanceof Declare && DeclareImpl.getStrictTypesDirective((Declare)statement) != null) {
            PsiElement phpOpeningTag = statement.getParent().getFirstChild();
            if (PhpAnnotatorVisitor.isShebang(phpOpeningTag)) {
                phpOpeningTag = phpOpeningTag.getNextSibling();
            }
            PsiElement declare = PhpPsiUtil.getNextSibling(phpOpeningTag, Conditions.not((Condition)Statement.INSTANCEOF));
            if (!PhpPsiUtil.isOfType(phpOpeningTag, PhpTokenTypes.PHP_OPENING_TAG) || statement != declare) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.first.statement", new Object[0]));
            } else if (statement.getLastChild() instanceof GroupStatement) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.block.mode", new Object[0]));
            }
        }
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        PhpPsiElement[] arguments;
        for (PhpPsiElement it : arguments = unsetStatement.getArguments()) {
            if (!(it instanceof FieldReference) || !((FieldReference)it).isStatic()) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, "Static property cannot be unset");
        }
    }

    public static boolean isShebang(@NotNull PsiElement element) {
        PsiFile htmlFile;
        PsiFile phpFile;
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(16);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.HTML) && (phpFile = element.getContainingFile()) != null && (htmlFile = phpFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE)) != null) {
            element = htmlFile.findElementAt(element.getTextOffset());
        }
        if (PhpPsiUtil.isOfType(element, XmlTokenType.XML_DATA_CHARACTERS) && element.getText().startsWith("#!")) {
            PsiElement next = element.getNextSibling();
            while (next instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(next, XmlTokenType.XML_DATA_CHARACTERS)) {
                String text;
                int lineBreak;
                if (next instanceof PsiWhiteSpace && (lineBreak = (text = next.getText()).indexOf(10)) != -1) {
                    if (lineBreak != text.length() - 1) break;
                    next = next.getNextSibling();
                    break;
                }
                next = next.getNextSibling();
            }
            if (next == null) {
                next = element.getParent().getNextSibling();
            }
            if (PhpPsiUtil.isOfType(next, PhpElementTypes.PHP_OUTER_TYPE)) {
                return true;
            }
        }
        return false;
    }

    private void highlightInfo(@Nullable ASTNode node, TextAttributesKey textAttributeKey) {
        if (node == null) {
            return;
        }
        String description = isUnitTestMode ? textAttributeKey.getExternalName() : null;
        Annotation annotation = this.holder.createInfoAnnotation(node, description);
        annotation.setTextAttributes(textAttributeKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 1: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceNotAccessibleFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveThis";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAllSuperInterfaces";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParametersRedefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPhpBreak";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isCouldBeDerivedFromException";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassRefsOfAppropriateType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isShebang";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addAllSuperInterfaces$3";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isReferenceNotAccessibleFrom$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PhpDeclarationDuplicateCheckerVisitor
    extends PsiRecursiveElementWalkingVisitor {
        final Set<String> classes = ContainerUtil.newTreeSet(String::compareToIgnoreCase);
        final Set<String> functions = ContainerUtil.newTreeSet(String::compareToIgnoreCase);
        final MultiMap<String, String> constants = new MultiMap<String, String>(){

            @NotNull
            protected Map<String, Collection<String>> createMap() {
                TreeMap<String, Collection<String>> treeMap = new TreeMap<String, Collection<String>>(String::compareToIgnoreCase);
                if (treeMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return treeMap;
            }

            @NotNull
            protected Collection<String> createCollection() {
                SmartHashSet smartHashSet = new SmartHashSet();
                if (smartHashSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                return smartHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeclarationDuplicateCheckerVisitor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };

        private PhpDeclarationDuplicateCheckerVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (element instanceof PhpClass) {
                this.visitPhpClass((PhpClass)element);
            }
            if (element instanceof Function) {
                this.visitPhpFunction((Function)element);
            }
            if (element instanceof Constant) {
                this.visitPhpConstant((Constant)element);
            }
            if (element instanceof PhpUse) {
                this.visitPhpUse((PhpUse)element);
            }
            if (!(element instanceof PhpClass || element instanceof Function || element instanceof Constant || element instanceof Statement && !(element instanceof GroupStatement) && !PhpPsiUtil.isOfType(element, PhpElementTypes.CONSTANTS))) {
                super.visitElement(element);
            }
        }

        public void visitPhpUse(PhpUse use) {
            if (!use.isTraitImport()) {
                String name = use.getName();
                String namespace = use.getNamespaceName();
                if (PhpUseImpl.isOfFunction(use)) {
                    this.checkUseDupe(use, namespace + name, this.functions);
                } else if (PhpUseImpl.isOfConst(use)) {
                    this.checkUseDupe(use, name, this.constants.getModifiable((Object)namespace));
                } else {
                    this.checkUseDupe(use, namespace + name, this.classes);
                }
            }
        }

        private void checkUseDupe(@NotNull PhpUse use, @NotNull String name, Collection<String> collection) {
            if (use == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(1);
            }
            if (collection.contains(name)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, (PsiElement)use, PhpBundle.message("annotator.duplicate.use.statement", use.getName()));
            } else {
                collection.add(name);
            }
        }

        public void visitPhpClass(PhpClass clazz) {
            this.checkDupe((PhpNamedElement)clazz, this.classes);
        }

        public void visitPhpFunction(Function function) {
            this.checkDupe((PhpNamedElement)function, this.functions);
        }

        public void visitPhpConstant(@NotNull Constant constant) {
            ASTNode nameNode;
            if (constant == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(2);
            }
            if ((nameNode = constant.getNameNode()) != null && this.constants.getModifiable((Object)constant.getNamespaceName()).contains(constant.getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Another definition with same name exists in this file");
            }
        }

        void checkDupe(PhpNamedElement e, Set<String> set) {
            if (PsiTreeUtil.getParentOfType((PsiElement)e, Else.class) != null) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)e, ElseIf.class) != null) {
                return;
            }
            String fqn = e.getFQN();
            ASTNode nameNode = e.getNameNode();
            if (nameNode != null && !set.add(fqn)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, "Another definition with same name exists in this file");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "use";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeclarationDuplicateCheckerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkUseDupe";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPhpConstant";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

