/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import com.jetbrains.php.debug.xdebug.dbgp.messages.EvalRequest;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.debug.xdebug.debugger.XdebugValue;
import com.jetbrains.php.debug.xdebug.handlers.DbgpEvalResponseHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugStackFrame
extends PhpStackFrame<XdebugConnection> {
    private static final String USER_DEFINED_CONSTANTS_GROUP = PhpBundle.message("PhpUserDefinedConstantsGroup.name", new Object[0]);
    @Nullable
    private final DbgpExceptionBreak myLastException;

    public XdebugStackFrame(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull Runnable reloader, @NotNull String remoteFilePath, int lineNumber, @NotNull String functionName, int stackSize, int depth, @Nullable DbgpExceptionBreak exception) {
        if (debugProcess == null) {
            XdebugStackFrame.$$$reportNull$$$0(0);
        }
        if (reloader == null) {
            XdebugStackFrame.$$$reportNull$$$0(1);
        }
        if (remoteFilePath == null) {
            XdebugStackFrame.$$$reportNull$$$0(2);
        }
        if (functionName == null) {
            XdebugStackFrame.$$$reportNull$$$0(3);
        }
        super(debugProcess, reloader, remoteFilePath, lineNumber, functionName, stackSize, depth);
        this.myLastException = exception;
    }

    @Override
    protected void computeVariables(@NotNull XCompositeNode node) {
        if (node == null) {
            XdebugStackFrame.$$$reportNull$$$0(4);
        }
        this.computeStackVariables(node);
    }

    private void computeStackVariables(XCompositeNode node) {
        XdebugConnection connection = (XdebugConnection)this.getDebugProcess().getConnection();
        if (connection == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        if (this.myLastException != null) {
            DbgpProperty property = new DbgpProperty(this.myLastException);
            XValueChildrenList children = new XValueChildrenList();
            PhpDebugProcess<XdebugConnection> process = this.getDebugProcess();
            String encoding = PhpDebugUtil.getDebugOutputEncoding(process.getSession().getProject());
            children.add(property.getShortName(encoding), (XValue)new XdebugValue(process, this.getDepth(), -1, property));
            node.addChildren(children, false);
        }
        connection.loadContextNames((Consumer<Map<Integer, String>>)((Consumer)names -> this.loadContext(node, names.entrySet().iterator())));
    }

    private void loadContext(final XCompositeNode node, final Iterator<Map.Entry<Integer, String>> iterator) {
        if (iterator.hasNext()) {
            XdebugConnection connection = (XdebugConnection)this.getDebugProcess().getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            final Map.Entry<Integer, String> context = iterator.next();
            connection.send(new ContextGetRequest(this.getDepth(), context.getKey()), new DbgpResponseHandler<ContextGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull ContextGetResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<DbgpProperty> properties = message.getProperties();
                    if (XdebugStackFrame.isUserDefinedConstantsContext((Integer)context.getKey())) {
                        if (!properties.isEmpty()) {
                            node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new PhpUserConstantsGroup(properties, (Integer)context.getKey())), false);
                        }
                    } else {
                        node.addChildren(XdebugStackFrame.this.getChildrenValue(properties, (Integer)context.getKey()), false);
                    }
                    XdebugStackFrame.this.loadContext(node, iterator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$1", "onSuccessResponse"));
                }
            });
        } else {
            node.addChildren(XValueChildrenList.EMPTY, true);
        }
    }

    @NotNull
    private XValueChildrenList getChildrenValue(@NotNull List<DbgpProperty> properties, int contextKey) {
        if (properties == null) {
            XdebugStackFrame.$$$reportNull$$$0(5);
        }
        XValueChildrenList children = new XValueChildrenList();
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getDebugProcess().getSession().getProject());
        for (DbgpProperty property : properties) {
            if (!property.isInitialized() || !this.isVisible(property)) continue;
            XdebugValue value = new XdebugValue(this.getDebugProcess(), this.getDepth(), contextKey, property);
            if (!property.isConstant() && !PhpLangUtil.isSuperGlobal(value.getPresentableName())) {
                this.myRuntimeEnvironment.registerVariable(value);
            }
            children.add(property.getShortName(encoding), (XValue)value);
        }
        XValueChildrenList xValueChildrenList = children;
        if (xValueChildrenList == null) {
            XdebugStackFrame.$$$reportNull$$$0(6);
        }
        return xValueChildrenList;
    }

    private boolean isVisible(@NotNull DbgpProperty property) {
        String encoding;
        String variableName;
        if (property == null) {
            XdebugStackFrame.$$$reportNull$$$0(7);
        }
        if (PhpLangUtil.isSuperGlobal(variableName = StringUtil.trimStart((String)property.getShortName(encoding = PhpDebugUtil.getDebugOutputEncoding(this.getDebugProcess().getSession().getProject())), (String)"$")) && property.getChildCount() == 0) {
            return !this.isHideEmptySuperGlobals();
        }
        return !XdebugStackFrame.isEvalCache(variableName);
    }

    private static boolean isUserDefinedConstantsContext(int index) {
        return index == 2;
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createEvaluator() {
        XDebugSession session = this.getDebugProcess().getSession();
        PhpEvaluator phpEvaluator = new PhpEvaluator(session.getProject(), session.getCurrentPosition()){

            @Override
            public void evaluateExpression(@NotNull String expressionToEvaluate, final @NotNull String presentation, final @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
                if (expressionToEvaluate == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (callback == null) {
                    2.$$$reportNull$$$0(3);
                }
                Project project = XdebugStackFrame.this.getDebugProcess().getSession().getProject();
                String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
                XdebugConnection connection = (XdebugConnection)XdebugStackFrame.this.getDebugProcess().getConnection();
                if (connection == null) {
                    callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
                    return;
                }
                connection.send(new EvalRequest(expressionToEvaluate, encoding), new DbgpEvalResponseHandler(encoding){

                    @Override
                    public void onEvalSuccess(@NotNull DbgpProperty property) {
                        if (property == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        callback.evaluated((XValue)new XdebugValue(XdebugStackFrame.this.getDebugProcess(), XdebugStackFrame.this.getDepth(), 1, property, presentation, null, null, false, expression));
                    }

                    @Override
                    public void onEvalError(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        callback.errorOccurred(errorMessage);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "property";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onEvalSuccess";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onEvalError";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expressionToEvaluate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$2";
                objectArray[2] = "evaluateExpression";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpEvaluator == null) {
            XdebugStackFrame.$$$reportNull$$$0(8);
        }
        return phpEvaluator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeVariables";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenValue";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PhpUserConstantsGroup
    extends XValueGroup {
        private final List<DbgpProperty> myProperties;
        private final int myContextKey;

        protected PhpUserConstantsGroup(List<DbgpProperty> properties, int contextKey) {
            if (properties == null) {
                PhpUserConstantsGroup.$$$reportNull$$$0(0);
            }
            super(USER_DEFINED_CONSTANTS_GROUP);
            this.myProperties = properties;
            this.myContextKey = contextKey;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            XdebugConnection connection;
            if (node == null) {
                PhpUserConstantsGroup.$$$reportNull$$$0(1);
            }
            if ((connection = (XdebugConnection)XdebugStackFrame.this.getDebugProcess().getConnection()) == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            node.addChildren(XdebugStackFrame.this.getChildrenValue(this.myProperties, this.myContextKey), true);
        }

        @Nullable
        public Icon getIcon() {
            return PhpIcons.CONSTANT;
        }

        public boolean isRestoreExpansion() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugStackFrame$PhpUserConstantsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

