/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Producer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.validation.PhpWebServerValidationDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpValidateWebServerAction
extends AnAction {
    private static final Producer<PhpServer> NULL_SERVER_PRODUCER = () -> null;
    @NotNull
    private Producer<? extends PhpServer> myServerProducer = NULL_SERVER_PRODUCER;

    public PhpValidateWebServerAction() {
        this(NULL_SERVER_PRODUCER);
    }

    public PhpValidateWebServerAction(@Nullable Producer<? extends PhpServer> serverProducer) {
        super(PhpBundle.message("php.web.server.validation.action.text", new Object[0]));
        if (serverProducer != null) {
            this.myServerProducer = serverProducer;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null && !project.isDisposed()) {
            PhpServer server = (PhpServer)this.myServerProducer.produce();
            String url = server != null ? PhpValidateWebServerAction.getStartUrl(server) : null;
            PhpWebServerValidationDialog dialog = new PhpWebServerValidationDialog(project, url);
            dialog.show();
        }
    }

    @Nullable
    public static String getStartUrl(@NotNull PhpServer server) {
        String host;
        if (server == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(host = server.getHost()))) {
            return null;
        }
        String url = host + ":" + server.getPort();
        return StringUtil.startsWith((CharSequence)host, (CharSequence)"http") ? url : "http://" + url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/PhpValidateWebServerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

