/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.LeafState;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNode<T>
extends PresentableNodeDescriptor<AbstractTreeNode<T>>
implements NavigationItem,
Queryable.Contributor,
LeafState.Supplier {
    private static final TextAttributesKey FILESTATUS_ERRORS = TextAttributesKey.createTextAttributesKey("FILESTATUS_ERRORS");
    private static final Logger LOG = Logger.getInstance(AbstractTreeNode.class);
    private AbstractTreeNode myParent;
    private Object myValue;
    private boolean myNullValueSet;
    private final boolean myNodeWrapper;
    static final Object TREE_WRAPPER_VALUE = new Object();

    protected AbstractTreeNode(Project project, @NotNull T value) {
        if (value == null) {
            AbstractTreeNode.$$$reportNull$$$0(0);
        }
        super(project, null);
        this.myNodeWrapper = this.setInternalValue(value);
    }

    @NotNull
    public abstract Collection<? extends AbstractTreeNode> getChildren();

    protected boolean hasProblemFileBeneath() {
        return false;
    }

    protected boolean valueIsCut() {
        return CopyPasteManager.getInstance().isCutElement(this.getValue());
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index2) {
        Collection<AbstractTreeNode> kids = this.getChildren();
        int i = 0;
        for (AbstractTreeNode kid : kids) {
            if (i == index2) {
                return kid;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void postprocess(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(1);
        }
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(FILESTATUS_ERRORS);
        }
        this.setForcedForeground(presentation);
    }

    private void setForcedForeground(@NotNull PresentationData presentation) {
        FileStatus status;
        Color fgColor;
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(2);
        }
        Color color = fgColor = (fgColor = this.getFileStatusColor(status = this.getFileStatus())) == null ? status.getColor() : fgColor;
        if (this.valueIsCut()) {
            fgColor = CopyPasteManager.CUT_COLOR;
        }
        if (presentation.getForcedTextForeground() == null) {
            presentation.setForcedTextForeground(fgColor);
        }
    }

    @Override
    protected boolean shouldUpdateData() {
        return !this.myProject.isDisposed() && this.getEqualityObject() != null;
    }

    @Override
    @NotNull
    public LeafState getLeafState() {
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                AbstractTreeNode.$$$reportNull$$$0(3);
            }
            return leafState;
        }
        if (this.isAlwaysLeaf()) {
            LeafState leafState = LeafState.ALWAYS;
            if (leafState == null) {
                AbstractTreeNode.$$$reportNull$$$0(4);
            }
            return leafState;
        }
        LeafState leafState = LeafState.DEFAULT;
        if (leafState == null) {
            AbstractTreeNode.$$$reportNull$$$0(5);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return false;
    }

    @Override
    @Nullable
    public final AbstractTreeNode<T> getElement() {
        return this.getEqualityObject() != null ? this : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return object instanceof AbstractTreeNode && Comparing.equal((Object)this.myValue, (Object)((AbstractTreeNode)object).myValue);
    }

    public int hashCode() {
        Object value = this.myValue;
        return value == null ? 0 : value.hashCode();
    }

    public final AbstractTreeNode getParent() {
        return this.myParent;
    }

    public final void setParent(AbstractTreeNode parent) {
        this.myParent = parent;
    }

    @Override
    public final NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    public final T getValue() {
        Object value = this.getEqualityObject();
        return (T)(value == null ? null : TreeAnchorizer.getService().retrieveElement(value));
    }

    public final void setValue(T value) {
        boolean debug = !this.myNodeWrapper && LOG.isDebugEnabled();
        int hash = !debug ? 0 : this.hashCode();
        boolean bl = this.myNullValueSet = value == null || this.setInternalValue(value);
        if (debug && hash != this.hashCode()) {
            LOG.warn("hash code changed: " + this.myValue);
        }
    }

    private boolean setInternalValue(@NotNull T value) {
        if (value == null) {
            AbstractTreeNode.$$$reportNull$$$0(6);
        }
        if (value == TREE_WRAPPER_VALUE) {
            return true;
        }
        this.myValue = TreeAnchorizer.getService().createAnchor(value);
        return false;
    }

    public final Object getEqualityObject() {
        return this.myNullValueSet ? null : this.myValue;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        String text;
        if (this.getValue() instanceof Queryable && (text = Queryable.Util.print((Queryable)this.getValue(), printInfo, this)) != null) {
            return text;
        }
        return this.getTestPresentation();
    }

    @Override
    public void apply(@NotNull Map<String, String> info) {
        if (info == null) {
            AbstractTreeNode.$$$reportNull$$$0(7);
        }
    }

    @Deprecated
    @Nullable
    @NonNls
    public String getTestPresentation() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    public Color getFileStatusColor(FileStatus status) {
        VirtualFile vf;
        if (FileStatus.NOT_CHANGED.equals(status) && (vf = this.getVirtualFile()) != null && vf.isDirectory()) {
            return FileStatusManager.getInstance(this.myProject).getRecursiveStatus(vf).getColor();
        }
        return status.getColor();
    }

    protected VirtualFile getVirtualFile() {
        return null;
    }

    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void navigate(boolean requestFocus) {
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    protected final Object getParentValue() {
        AbstractTreeNode parent = this.getParent();
        return parent == null ? null : parent.getValue();
    }

    public boolean canRepresent(Object element) {
        return Comparing.equal(this.getValue(), (Object)element);
    }

    @Deprecated
    protected String getToolTip() {
        return ((PresentationData)this.getPresentation()).getTooltip();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setForcedForeground";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setInternalValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

