/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;

public class YAMLUtil {
    public static final FileBasedIndex.InputFilter YAML_INPUT_FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{YAMLLanguage.INSTANCE.getAssociatedFileType()});
    private static final TokenSet BLANK_LINE_ELEMENTS = TokenSet.andNot((TokenSet)YAMLElementTypes.BLANK_ELEMENTS, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);

    @Deprecated
    @NotNull
    public static String getFullKey(YAMLKeyValue yamlKeyValue) {
        String fullPath = YAMLUtil.getConfigFullName(yamlKeyValue);
        String string = StringUtil.notNullize((String)StringUtil.substringAfter((String)fullPath, (String)"."));
        if (string == null) {
            YAMLUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @ApiStatus.Experimental
    @NotNull
    public static String getConfigFullName(@NotNull YAMLPsiElement target) {
        if (target == null) {
            YAMLUtil.$$$reportNull$$$0(1);
        }
        StringBuilder builder = new StringBuilder();
        YAMLPsiElement element = target;
        while (element != null) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class});
            if (element instanceof YAMLKeyValue) {
                builder.insert(0, ((YAMLKeyValue)element).getKeyText());
                if (parent != null) {
                    builder.insert(0, '.');
                }
            } else if (element instanceof YAMLSequenceItem) {
                builder.insert(0, "[" + ((YAMLSequenceItem)element).getItemIndex() + "]");
            }
            element = parent;
        }
        String string = builder.toString();
        if (string == null) {
            YAMLUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Collection<YAMLKeyValue> getTopLevelKeys(YAMLFile file) {
        YAMLValue topLevelValue = file.getDocuments().get(0).getTopLevelValue();
        if (topLevelValue instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)topLevelValue).getKeyValues();
            if (collection == null) {
                YAMLUtil.$$$reportNull$$$0(3);
            }
            return collection;
        }
        List<YAMLKeyValue> list = Collections.emptyList();
        if (list == null) {
            YAMLUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, List<String> key) {
        return YAMLUtil.getQualifiedKeyInDocument(file.getDocuments().get(0), key);
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInDocument(@NotNull YAMLDocument document, @NotNull List<String> key) {
        if (document == null) {
            YAMLUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            YAMLUtil.$$$reportNull$$$0(6);
        }
        assert (key.size() != 0);
        YAMLMapping mapping = (YAMLMapping)ObjectUtils.tryCast((Object)document.getTopLevelValue(), YAMLMapping.class);
        for (int i = 0; i < key.size(); ++i) {
            if (mapping == null) {
                return null;
            }
            YAMLKeyValue keyValue = mapping.getKeyValueByKey(key.get(i));
            if (keyValue == null || i + 1 == key.size()) {
                return keyValue;
            }
            mapping = (YAMLMapping)ObjectUtils.tryCast((Object)keyValue.getValue(), YAMLMapping.class);
        }
        throw new IllegalStateException("Should have returned from the loop");
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, String ... key) {
        return YAMLUtil.getQualifiedKeyInFile(file, Arrays.asList(key));
    }

    @Nullable
    public static YAMLKeyValue findKeyInProbablyMapping(@Nullable YAMLValue node, @NotNull String keyText) {
        if (keyText == null) {
            YAMLUtil.$$$reportNull$$$0(7);
        }
        if (!(node instanceof YAMLMapping)) {
            return null;
        }
        return ((YAMLMapping)node).getKeyValueByKey(keyText);
    }

    @Nullable
    public static Pair<PsiElement, String> getValue(YAMLFile file, String ... key) {
        YAMLKeyValue record = YAMLUtil.getQualifiedKeyInFile(file, key);
        if (record != null) {
            YAMLValue psiValue = record.getValue();
            return Pair.create((Object)psiValue, (Object)record.getValueText());
        }
        return null;
    }

    public YAMLKeyValue createI18nRecord(YAMLFile file, String key, String text) {
        return YAMLUtil.createI18nRecord(file, key.split("\\."), text);
    }

    @Nullable
    public static YAMLKeyValue createI18nRecord(YAMLFile file, String[] key, String text) {
        int i;
        YAMLDocument root = file.getDocuments().get(0);
        assert (root != null);
        assert (key.length > 0);
        YAMLMapping rootMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)root, YAMLMapping.class);
        if (rootMapping == null) {
            YAMLFile yamlFile = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(key[0] + ":");
            YAMLMapping mapping = (YAMLMapping)yamlFile.getDocuments().get(0).getTopLevelValue();
            assert (mapping != null);
            rootMapping = (YAMLMapping)root.add((PsiElement)mapping);
        }
        YAMLMapping current = rootMapping;
        int keyLength = key.length;
        for (i = 0; i < keyLength; ++i) {
            YAMLMapping nextMapping;
            YAMLKeyValue existingRec = current.getKeyValueByKey(key[i]);
            if (existingRec != null && (nextMapping = (YAMLMapping)ObjectUtils.tryCast((Object)existingRec.getValue(), YAMLMapping.class)) != null) {
                current = nextMapping;
                continue;
            }
            String indent = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)current));
            StringBuilder builder = new StringBuilder();
            builder.append("---");
            for (int j = i; j < keyLength; ++j) {
                builder.append("\n").append(indent);
                builder.append(key[j]).append(":");
                indent = indent + "  ";
            }
            builder.append(" ").append(text);
            YAMLFile fileWithKey = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(builder.toString());
            YAMLMapping dummyMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)fileWithKey.getDocuments().get(0)), YAMLMapping.class);
            assert (dummyMapping != null && dummyMapping.getKeyValues().size() == 1);
            YAMLKeyValue dummyKeyValue = dummyMapping.getKeyValues().iterator().next();
            current.putKeyValue(dummyKeyValue);
            if (!(dummyKeyValue.getValue() instanceof YAMLMapping)) {
                return dummyKeyValue;
            }
            current = (YAMLMapping)dummyKeyValue.getValue();
        }
        StringBuilder builder = new StringBuilder();
        int top = Math.min(i + 1, keyLength);
        for (int j = 0; j < top; ++j) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(key[j]);
        }
        throw new IncorrectOperationException(YAMLBundle.message("new.name.conflicts.with", builder.toString()));
    }

    public static PsiElement rename(YAMLKeyValue element, String newName) {
        if (newName.contains(".")) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.wrong.name"));
        }
        if (newName.equals(element.getName())) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.same.name"));
        }
        YAMLKeyValue topKeyValue = YAMLElementGenerator.getInstance(element.getProject()).createYamlKeyValue(newName, "Foo");
        PsiElement key = element.getKey();
        if (key == null || topKeyValue.getKey() == null) {
            throw new IllegalStateException();
        }
        key.replace(topKeyValue.getKey());
        return element;
    }

    public static int getIndentInThisLine(@NotNull PsiElement elementInLine) {
        if (elementInLine == null) {
            YAMLUtil.$$$reportNull$$$0(8);
        }
        PsiElement currentElement = elementInLine;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (type == YAMLTokenTypes.EOL) {
                return 0;
            }
            if (type == YAMLTokenTypes.INDENT) {
                return currentElement.getTextLength();
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return 0;
    }

    public static int getIndentToThisElement(@NotNull PsiElement element) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(9);
        }
        if (element instanceof YAMLBlockMappingImpl) {
            element = ((YAMLBlockMappingImpl)element).getFirstKeyValue();
        }
        int offset = element.getTextOffset();
        Object currentElement = element;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (YAMLElementTypes.EOL_ELEMENTS.contains(type)) {
                return offset - currentElement.getTextOffset() - 1;
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return offset;
    }

    public static void deleteSurroundingWhitespace(@NotNull PsiElement element) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(10);
        }
        if (element.getNextSibling() != null) {
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getNextSibling(), BLANK_LINE_ELEMENTS);
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getNextSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        } else {
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getPrevSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        }
    }

    private static void deleteElementsOfType(@NotNull Supplier<PsiElement> element, @NotNull TokenSet types) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(11);
        }
        if (types == null) {
            YAMLUtil.$$$reportNull$$$0(12);
        }
        while (element.get() != null && types.contains(PsiUtilCore.getElementType((PsiElement)element.get()))) {
            element.get().delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKey";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFullName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFullName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedKeyInDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findKeyInProbablyMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInThisLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndentToThisElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteSurroundingWhitespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementsOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

