/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.merge.MergeChangeCollector;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NonNls;

public class GitMergeUtil {
    public static final String DEFAULT_STRATEGY = GitBundle.getString("merge.default.strategy");

    private GitMergeUtil() {
    }

    @NonNls
    public static String[] getMergeStrategies(int branchCount) {
        if (branchCount < 0) {
            throw new IllegalArgumentException("Branch count must be non-negative: " + branchCount);
        }
        switch (branchCount) {
            case 0: {
                return new String[]{DEFAULT_STRATEGY};
            }
            case 1: {
                return new String[]{DEFAULT_STRATEGY, "resolve", "recursive", "octopus", "ours", "subtree"};
            }
        }
        return new String[]{DEFAULT_STRATEGY, "octopus", "ours"};
    }

    public static void setupStrategies(final ElementsChooser<String> branchChooser, final JComboBox strategy) {
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            private void updateStrategies(List<String> elements) {
                strategy.removeAllItems();
                for (String s : GitMergeUtil.getMergeStrategies(elements.size())) {
                    strategy.addItem(s);
                }
                strategy.setSelectedItem(DEFAULT_STRATEGY);
            }

            public void elementMarkChanged(String element, boolean isMarked) {
                List elements = branchChooser.getMarkedElements();
                if (elements.size() == 0) {
                    strategy.setEnabled(false);
                    this.updateStrategies(elements);
                } else {
                    strategy.setEnabled(true);
                    this.updateStrategies(elements);
                }
            }
        };
        listener.elementMarkChanged(null, true);
        branchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
    }

    public static void showUpdates(Project project, List<VcsException> exceptions, VirtualFile root, GitRevisionNumber currentRev, Label beforeLabel, String actionName, ActionInfo actionInfo) {
        UpdatedFiles files = UpdatedFiles.create();
        MergeChangeCollector collector = new MergeChangeCollector(project, root, currentRev);
        collector.collect(files, exceptions);
        if (!exceptions.isEmpty()) {
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            ProjectLevelVcsManagerEx manager = (ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)project);
            UpdateInfoTree tree = manager.showUpdateProjectInfo(files, actionName, actionInfo, false);
            if (tree != null) {
                tree.setBefore(beforeLabel);
                tree.setAfter(LocalHistory.getInstance().putSystemLabel(project, "After update"));
                ViewUpdateInfoNotification.focusUpdateInfoTree((Project)project, (UpdateInfoTree)tree);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
        Collection unmergedNames = files.getGroupById("MERGED_WITH_CONFLICTS").getFiles();
        if (!unmergedNames.isEmpty()) {
            List unmerged = ContainerUtil.mapNotNull((Collection)unmergedNames, name -> LocalFileSystem.getInstance().findFileByPath(name));
            GuiUtils.invokeLaterIfNeeded(() -> AbstractVcsHelper.getInstance((Project)project).showMergeDialog(unmerged, GitVcs.getInstance(project).getMergeProvider()), (ModalityState)ModalityState.defaultModalityState());
        }
    }
}

