/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import java.util.Collections;
import javax.swing.Icon;

public class GitCreateNewTag {
    private final Project myProject;
    private final GitRepository myRepository;
    private final String myReference;
    private final Runnable myCallInAwtAfterExecution;

    public GitCreateNewTag(Project project, GitRepository repository, String reference, Runnable callInAwtAfterExecution) {
        this.myProject = project;
        this.myRepository = repository;
        this.myReference = reference;
        this.myCallInAwtAfterExecution = callInAwtAfterExecution;
    }

    public void execute() {
        String name = Messages.showInputDialog((Project)this.myProject, (String)"Enter the name of new tag", (String)("Create New Tag On " + this.myReference), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return !StringUtil.isEmpty((String)inputString) && !StringUtil.containsWhitespaces((CharSequence)inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmpty((String)inputString) && !StringUtil.containsWhitespaces((CharSequence)inputString);
            }
        });
        if (name != null) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.createNewTag(name, this.myReference, Collections.singletonList(this.myRepository), this.myCallInAwtAfterExecution);
        }
    }
}

