/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitCreateBranchOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitDeleteRemoteTagOperation;
import git4idea.branch.GitDeleteTagOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.branch.GitRebaseParams;
import git4idea.branch.GitRenameBranchOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.history.GitHistoryUtils;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesHelper;
import git4idea.util.GitLocalCommitCompareInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitBranchUiHandler myUiHandler;

    public GitBranchWorker(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler) {
        if (project == null) {
            GitBranchWorker.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchWorker.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitBranchWorker.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
    }

    public void checkoutNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(3);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(4);
        }
        GitBranchWorker.updateInfo(repositories);
        repositories = ContainerUtil.filter(repositories, repository -> {
            GitLocalBranch currentBranch;
            if (name == null) {
                GitBranchWorker.$$$reportNull$$$0(48);
            }
            return (currentBranch = repository.getCurrentBranch()) == null || !currentBranch.getName().equals(name);
        });
        if (!repositories.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(5);
        }
        if (startPoints == null) {
            GitBranchWorker.$$$reportNull$$$0(6);
        }
        GitBranchWorker.updateInfo(startPoints.keySet());
        new GitCreateBranchOperation(this.myProject, this.myGit, this.myUiHandler, name, startPoints).execute();
    }

    public void createNewTag(@NotNull String name, @NotNull String reference, @NotNull List<GitRepository> repositories) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            GitBranchWorker.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(9);
        }
        for (GitRepository repository : repositories) {
            this.myGit.createNewTag(repository, name, null, reference);
            repository.getRepositoryFiles().refreshTagsFiles();
        }
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<GitRepository> repositories) {
        if (newBranchName == null) {
            GitBranchWorker.$$$reportNull$$$0(10);
        }
        if (startPoint == null) {
            GitBranchWorker.$$$reportNull$$$0(11);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(12);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, startPoint, false, true, newBranchName).execute();
    }

    public void checkout(@NotNull String reference, boolean detach, @NotNull List<GitRepository> repositories) {
        if (reference == null) {
            GitBranchWorker.$$$reportNull$$$0(13);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(14);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, reference, detach, false, null).execute();
    }

    public void deleteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(15);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(16);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void deleteTag(@NotNull String tagName, @NotNull List<GitRepository> repositories) {
        if (tagName == null) {
            GitBranchWorker.$$$reportNull$$$0(17);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(18);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteTag(@NotNull String tagName, @NotNull Map<GitRepository, String> repositories) {
        if (tagName == null) {
            GitBranchWorker.$$$reportNull$$$0(19);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(20);
        }
        GitBranchWorker.updateInfo(repositories.keySet());
        new GitDeleteRemoteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(21);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(22);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void merge(@NotNull String branchName, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(23);
        }
        if (deleteOnMerge == null) {
            GitBranchWorker.$$$reportNull$$$0(24);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(25);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitMergeOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName, deleteOnMerge).execute();
    }

    public void rebase(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(26);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(27);
        }
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(branchName), this.myUiHandler.getProgressIndicator());
    }

    public void rebaseOnCurrent(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(28);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(29);
        }
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(branchName, null, "HEAD", false, false), this.myUiHandler.getProgressIndicator());
    }

    public void renameBranch(@NotNull String currentName, @NotNull String newName, @NotNull List<GitRepository> repositories) {
        if (currentName == null) {
            GitBranchWorker.$$$reportNull$$$0(30);
        }
        if (newName == null) {
            GitBranchWorker.$$$reportNull$$$0(31);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(32);
        }
        GitBranchWorker.updateInfo(repositories);
        new GitRenameBranchOperation(this.myProject, this.myGit, this.myUiHandler, currentName, newName, repositories).execute();
    }

    public void compare(@NotNull String branchName, @NotNull List<GitRepository> repositories, @NotNull GitRepository selectedRepository) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(33);
        }
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(34);
        }
        if (selectedRepository == null) {
            GitBranchWorker.$$$reportNull$$$0(35);
        }
        try {
            CommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (branchName == null) {
                    GitBranchWorker.$$$reportNull$$$0(45);
                }
                if (repositories == null) {
                    GitBranchWorker.$$$reportNull$$$0(46);
                }
                if (selectedRepository == null) {
                    GitBranchWorker.$$$reportNull$$$0(47);
                }
                this.displayCompareDialog(branchName, GitBranchUtil.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository);
            });
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Can't Compare with Branch", e.getMessage());
        }
    }

    @NotNull
    private CommitCompareInfo loadCommitsToCompare(List<GitRepository> repositories, String branchName) throws VcsException {
        GitLocalCommitCompareInfo compareInfo = new GitLocalCommitCompareInfo(this.myProject, branchName);
        for (GitRepository repository : repositories) {
            List<GitCommit> headToBranch = GitHistoryUtils.history(this.myProject, repository.getRoot(), ".." + branchName);
            List<GitCommit> branchToHead = GitHistoryUtils.history(this.myProject, repository.getRoot(), branchName + "..");
            compareInfo.put(repository, headToBranch, branchToHead);
            compareInfo.putTotalDiff(repository, GitBranchWorker.loadTotalDiff(repository, branchName));
        }
        GitLocalCommitCompareInfo gitLocalCommitCompareInfo = compareInfo;
        if (gitLocalCommitCompareInfo == null) {
            GitBranchWorker.$$$reportNull$$$0(36);
        }
        return gitLocalCommitCompareInfo;
    }

    @NotNull
    public static Collection<Change> loadTotalDiff(@NotNull Repository repository, @NotNull String branchName) throws VcsException {
        if (repository == null) {
            GitBranchWorker.$$$reportNull$$$0(37);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(38);
        }
        Collection<Change> collection = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), branchName, null, true);
        if (collection == null) {
            GitBranchWorker.$$$reportNull$$$0(39);
        }
        return collection;
    }

    private void displayCompareDialog(@NotNull String branchName, @NotNull String currentBranch, @NotNull CommitCompareInfo compareInfo, @NotNull GitRepository selectedRepository) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(40);
        }
        if (currentBranch == null) {
            GitBranchWorker.$$$reportNull$$$0(41);
        }
        if (compareInfo == null) {
            GitBranchWorker.$$$reportNull$$$0(42);
        }
        if (selectedRepository == null) {
            GitBranchWorker.$$$reportNull$$$0(43);
        }
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)String.format("<html>There are no changes between <code>%s</code> and <code>%s</code></html>", currentBranch, branchName), (String)"No Changes Detected");
        } else {
            new CompareBranchesDialog((CompareBranchesHelper)new GitCompareBranchesHelper(this.myProject), branchName, currentBranch, compareInfo, (Repository)selectedRepository, false).show();
        }
    }

    private static void updateInfo(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitBranchWorker.$$$reportNull$$$0(44);
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 36: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 36: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 15: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 33: 
            case 38: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 35: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchWorker";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchWorker";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCommitsToCompare";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTotalDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBranch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteBranch";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteTag";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteBranch";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "rebaseOnCurrent";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 36: 
            case 39: {
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadTotalDiff";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "displayCompareDialog";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateInfo";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compare$1";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkoutNewBranch$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 36: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

