/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.behat.steps.BehatPatternExtractor;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class BehatStepDefinition
extends AbstractStepDefinition {
    private static final String ourEscapePattern = "(\\$\\w+|#\\{.+?\\})";
    private static final String GHERKIN_START_PREFIX = "^";
    private static final String GHERKIN_END_SUFFIX = "$";

    public BehatStepDefinition(@NotNull PsiElement element) {
        if (element == null) {
            BehatStepDefinition.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public List<String> getVariableNames() {
        PsiElement element = this.getElement();
        if (element instanceof Function) {
            Parameter[] parameters = ((Function)element).getParameters();
            if (parameters.length == 0) {
                return null;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (Parameter parameter : parameters) {
                names.add(parameter.getName());
            }
            return names;
        }
        return null;
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        if (element instanceof Method) {
            List<String> patterns = BehatPatternExtractor.getAllPatternsFromStepDefinition((Method)element);
            return patterns == null || patterns.isEmpty() ? null : patterns.get(0);
        }
        return null;
    }

    public boolean matches(@NotNull String stepName) {
        PsiElement element;
        if (stepName == null) {
            BehatStepDefinition.$$$reportNull$$$0(1);
        }
        if (!((element = this.getElement()) instanceof Method)) {
            return false;
        }
        List<String> regexps = BehatPatternExtractor.getAllPatternsFromStepDefinition((Method)element);
        if (regexps != null) {
            for (String regexp : regexps) {
                Pattern pattern = this.getPatternByRegExp(regexp);
                if (pattern == null || !new Perl5Matcher().contains(stepName, pattern)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Pattern getPatternByRegExp(@Nullable String regex) {
        try {
            if (regex == null) {
                return null;
            }
            StringBuilder patternText = new StringBuilder(regex.replaceAll(ourEscapePattern, "(.*)"));
            if (!patternText.toString().startsWith(GHERKIN_START_PREFIX)) {
                patternText.insert(0, GHERKIN_START_PREFIX);
            }
            if (!patternText.toString().endsWith(GHERKIN_END_SUFFIX)) {
                patternText.append(GHERKIN_END_SUFFIX);
            }
            return new Perl5Compiler().compile(patternText.toString());
        }
        catch (MalformedPatternException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/behat/steps/BehatStepDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

