/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Matcher;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFileKt;
import org.jetbrains.idea.svn.MyIni;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.config.DefaultProxyGroup;
import org.jetbrains.idea.svn.config.ProxyGroup;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bJ&\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tJ\u0018\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020\tJ\u001c\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010 \u001a\u00020\tJD\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001bJ \u0010,\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tJ\u0012\u0010.\u001a\u00020\u001b2\b\b\u0002\u0010/\u001a\u00020*H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/svn/IdeaSVNConfigFile;", "", "myPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "_configFile", "Lorg/jetbrains/idea/svn/MyIni;", "allGroups", "", "", "Lorg/jetbrains/idea/svn/config/ProxyGroup;", "getAllGroups", "()Ljava/util/Map;", "configFile", "Lorg/ini4j/Ini;", "getConfigFile", "()Lorg/ini4j/Ini;", "defaultGroup", "Lorg/jetbrains/idea/svn/config/DefaultProxyGroup;", "getDefaultGroup", "()Lorg/jetbrains/idea/svn/config/DefaultProxyGroup;", "myDefaultProperties", "", "myLatestUpdate", "", "myPatternsMap", "addGroup", "", "name", "patterns", "properties", "addProperties", "groupName", "deleteGroup", "getValue", "propertyName", "getValues", "modifyGroup", "delete", "", "addOrModify", "isDefault", "", "save", "setValue", "value", "updateGroups", "force", "Companion", "intellij.vcs.svn"})
public final class IdeaSVNConfigFile {
    private final Map<String, String> myPatternsMap;
    private long myLatestUpdate;
    private final Map<String, String> myDefaultProperties;
    private final MyIni _configFile;
    private final Path myPath;
    @JvmField
    @NotNull
    public static final String SERVERS_FILE_NAME = "servers";
    @JvmField
    @NotNull
    public static final String CONFIG_FILE_NAME = "config";
    @JvmField
    @NotNull
    public static final String DEFAULT_GROUP_NAME = "global";
    @JvmField
    @NotNull
    public static final String GROUPS_GROUP_NAME = "groups";
    public static final Companion Companion = new Companion(null);

    private final Ini getConfigFile() {
        IdeaSVNConfigFile.updateGroups$default(this, false, 1, null);
        return this._configFile;
    }

    @NotNull
    public final Map<String, ProxyGroup> getAllGroups() {
        HashMap<String, ProxyGroup> result = new HashMap<String, ProxyGroup>(this.myPatternsMap.size());
        Map<String, String> map = this.myPatternsMap;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            String groupName = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            result.put(groupName, new ProxyGroup(groupName, value, this.getValues(groupName)));
        }
        return result;
    }

    @NotNull
    public final DefaultProxyGroup getDefaultGroup() {
        return new DefaultProxyGroup(this.myDefaultProperties);
    }

    @JvmOverloads
    public final void updateGroups(boolean force) {
        long lastModified = FileSystemUtil.lastModified((File)this.myPath.toFile());
        if (force || this.myLatestUpdate != lastModified) {
            this._configFile.clear();
            try {
                this._configFile.load(this.myPath.toFile());
            }
            catch (IOException e) {
                IdeaSVNConfigFileKt.access$getLOG$p().info("Could not load " + this.myPath, (Throwable)e);
            }
            this.myLatestUpdate = lastModified;
            this.myPatternsMap.clear();
            this.myPatternsMap.putAll(this.getValues(GROUPS_GROUP_NAME));
            this.myDefaultProperties.clear();
            this.myDefaultProperties.putAll(this.getValues(DEFAULT_GROUP_NAME));
        }
    }

    @JvmOverloads
    public static /* synthetic */ void updateGroups$default(IdeaSVNConfigFile ideaSVNConfigFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ideaSVNConfigFile.updateGroups(bl);
    }

    @JvmOverloads
    public final void updateGroups() {
        IdeaSVNConfigFile.updateGroups$default(this, false, 1, null);
    }

    @Nullable
    public final String getValue(@NotNull String groupName, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return this.getConfigFile().get((Object)groupName, (Object)propertyName);
    }

    @NotNull
    public final Map<String, String> getValues(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Profile.Section section = (Profile.Section)this.getConfigFile().get((Object)groupName);
        return section != null ? (Map)section : MapsKt.emptyMap();
    }

    public final void setValue(@NotNull String groupName, @NotNull String propertyName, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        this.getConfigFile().put(groupName, propertyName, (Object)value);
    }

    public final void deleteGroup(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)DEFAULT_GROUP_NAME, (Object)name)) {
            this.myDefaultProperties.clear();
        }
        this.setValue(GROUPS_GROUP_NAME, name, null);
        this.getConfigFile().remove((Object)name);
    }

    public final void addGroup(@NotNull String name, @Nullable String patterns, @NotNull Map<String, String> properties) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this.setValue(GROUPS_GROUP_NAME, name, patterns);
        this.addProperties(name, properties);
    }

    private final void addProperties(String groupName, Map<String, String> properties) {
        Map<String, String> map = properties;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            this.setValue(groupName, key, value);
        }
    }

    public final void modifyGroup(@NotNull String name, @Nullable String patterns, @NotNull Collection<String> delete, @NotNull Map<String, String> addOrModify, boolean isDefault) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(delete, (String)"delete");
        Intrinsics.checkParameterIsNotNull(addOrModify, (String)"addOrModify");
        if (!isDefault) {
            this.setValue(GROUPS_GROUP_NAME, name, patterns);
        }
        HashMap<String, Object> deletedPrepared = new HashMap<String, Object>(delete.size());
        for (String property : delete) {
            deletedPrepared.put(property, null);
        }
        this.addProperties(name, (Map<String, String>)deletedPrepared);
        this.addProperties(name, addOrModify);
    }

    public final void save() {
        try {
            this._configFile.store(this.myPath.toFile());
            this.updateGroups(true);
        }
        catch (IOException e) {
            IdeaSVNConfigFileKt.access$getLOG$p().info("Could not save " + this.myPath, (Throwable)e);
        }
    }

    public IdeaSVNConfigFile(@NotNull Path myPath) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)myPath, (String)"myPath");
        this.myPath = myPath;
        IdeaSVNConfigFile ideaSVNConfigFile = this;
        ideaSVNConfigFile.myPatternsMap = object = (Map)new LinkedHashMap();
        this.myLatestUpdate = -1L;
        ideaSVNConfigFile = this;
        ideaSVNConfigFile.myDefaultProperties = object = (Map)new LinkedHashMap();
        MyIni myIni = new MyIni();
        ideaSVNConfigFile = this;
        MyIni $receiver = myIni;
        Config config = $receiver.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)CONFIG_FILE_NAME);
        config.setTree(false);
        Config config2 = $receiver.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)CONFIG_FILE_NAME);
        config2.setEmptySection(true);
        object = myIni;
        ideaSVNConfigFile._configFile = object;
    }

    static {
        SERVERS_FILE_NAME = SERVERS_FILE_NAME;
        CONFIG_FILE_NAME = CONFIG_FILE_NAME;
        DEFAULT_GROUP_NAME = DEFAULT_GROUP_NAME;
        GROUPS_GROUP_NAME = GROUPS_GROUP_NAME;
    }

    @JvmStatic
    @NotNull
    public static final String getNewGroupName(@NotNull String host, @NotNull IdeaSVNConfigFile configFile) {
        return Companion.getNewGroupName(host, configFile);
    }

    @JvmStatic
    @Nullable
    public static final String getPropertyIdea(@NotNull String host, @NotNull Couple<IdeaSVNConfigFile> serversFile, @NotNull String name) {
        return Companion.getPropertyIdea(host, serversFile, name);
    }

    @JvmStatic
    public static final boolean checkHostGroup(@NotNull String url, @Nullable String patterns, @Nullable String exceptions) {
        return Companion.checkHostGroup(url, patterns, exceptions);
    }

    @JvmStatic
    @Nullable
    public static final String getGroupForHost(@NotNull String host, @NotNull IdeaSVNConfigFile serversFile) {
        return Companion.getGroupForHost(host, serversFile);
    }

    @JvmStatic
    public static final boolean isTurned(@Nullable String value) {
        return Companion.isTurned(value);
    }

    @JvmStatic
    @Nullable
    public static final String getValue(@NotNull Couple<IdeaSVNConfigFile> files, @NotNull String groupName, @NotNull String propertyName) {
        return Companion.getValue(files, groupName, propertyName);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getValues(@NotNull Couple<IdeaSVNConfigFile> files, @NotNull String groupName) {
        return Companion.getValues(files, groupName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J(\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00132\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0010H\u0007J(\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J(\u0010\u0019\u001a\u0004\u0018\u00010\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J,\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0012\u0010\u001e\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010 \u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/svn/IdeaSVNConfigFile$Companion;", "", "()V", "CONFIG_FILE_NAME", "", "DEFAULT_GROUP_NAME", "GROUPS_GROUP_NAME", "SERVERS_FILE_NAME", "checkHostGroup", "", "url", "patterns", "exceptions", "getGroupForHost", "host", "serversFile", "Lorg/jetbrains/idea/svn/IdeaSVNConfigFile;", "getGroupName", "groups", "", "getNewGroupName", "configFile", "getPropertyIdea", "Lcom/intellij/openapi/util/Couple;", "name", "getValue", "files", "groupName", "propertyName", "getValues", "isTurned", "value", "matches", "matchesPattern", "pattern", "intellij.vcs.svn"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getNewGroupName(@NotNull String host, @NotNull IdeaSVNConfigFile configFile) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
            String groupName = host;
            Map<String, ProxyGroup> groups = configFile.getAllGroups();
            while (StringUtil.isEmptyOrSpaces((String)groupName) || groups.containsKey(groupName)) {
                groupName = groupName + "1";
            }
            return groupName;
        }

        @JvmStatic
        @Nullable
        public final String getPropertyIdea(@NotNull String host, @NotNull Couple<IdeaSVNConfigFile> serversFile, @NotNull String name) {
            Map<String, String> hostProps;
            String value;
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull(serversFile, (String)"serversFile");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            String groupName = this.getGroupName(this.getValues(serversFile, GROUPS_GROUP_NAME), host);
            if (groupName != null && (value = (hostProps = this.getValues(serversFile, groupName)).get(name)) != null) {
                return value;
            }
            return this.getValues(serversFile, DEFAULT_GROUP_NAME).get(name);
        }

        @JvmStatic
        public final boolean checkHostGroup(@NotNull String url, @Nullable String patterns, @Nullable String exceptions) {
            Url svnurl;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            try {
                Url url2 = SvnUtil.createUrl(url);
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"createUrl(url)");
                svnurl = url2;
            }
            catch (SvnBindException e) {
                return false;
            }
            String host = svnurl.getHost();
            return this.matches(patterns, host) && !this.matches(exceptions, host);
        }

        private final boolean matches(String patterns, String host) {
            boolean bl;
            block5: {
                String string = patterns;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                Iterable $receiver$iv = StringsKt.split$default((CharSequence)string2, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it;
                        String string3 = it = (String)element$iv;
                        Companion companion = Companion;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                        if (!companion.matchesPattern(string5, host)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchesPattern(String pattern, String host) {
            boolean bl;
            try {
                bl = new Perl5Matcher().matches(host, new GlobCompiler().compile(pattern));
            }
            catch (MalformedPatternException e) {
                IdeaSVNConfigFileKt.access$getLOG$p().debug("Could not compile pattern " + pattern, (Throwable)e);
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getGroupForHost(@NotNull String host, @NotNull IdeaSVNConfigFile serversFile) {
            Map<String, ProxyGroup> groups;
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)serversFile, (String)"serversFile");
            Map<String, ProxyGroup> map = groups = serversFile.getAllGroups();
            Iterator<Map.Entry<String, ProxyGroup>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ProxyGroup> entry;
                Map.Entry<String, ProxyGroup> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                entry2 = entry;
                ProxyGroup value = entry2.getValue();
                if (!this.matches(value.getPatterns(), host)) continue;
                return key;
            }
            return null;
        }

        private final String getGroupName(Map<String, String> groups, String host) {
            Map<String, String> map = groups;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                entry2 = entry;
                String value = entry2.getValue();
                if (!this.matches(value, host)) continue;
                return key;
            }
            return null;
        }

        @JvmStatic
        public final boolean isTurned(@Nullable String value) {
            return value == null || StringsKt.equals((String)"yes", (String)value, (boolean)true) || StringsKt.equals((String)"on", (String)value, (boolean)true) || StringsKt.equals((String)"true", (String)value, (boolean)true);
        }

        @JvmStatic
        @Nullable
        public final String getValue(@NotNull Couple<IdeaSVNConfigFile> files, @NotNull String groupName, @NotNull String propertyName) {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
            Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
            String string = ((IdeaSVNConfigFile)files.second).getValue(groupName, propertyName);
            if (string == null) {
                string = ((IdeaSVNConfigFile)files.first).getValue(groupName, propertyName);
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> getValues(@NotNull Couple<IdeaSVNConfigFile> files, @NotNull String groupName) {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
            Map map = ContainerUtil.union(((IdeaSVNConfigFile)files.first).getValues(groupName), ((IdeaSVNConfigFile)files.second).getValues(groupName));
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"union(files.first.getVal\u2026ond.getValues(groupName))");
            return map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

