/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanel;

public class CompassSettingsPanelImpl
implements CompassSettingsPanel {
    private static final Logger LOGGER = Logger.getInstance(CompassSettingsPanelImpl.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Alarm myValidationAlarm;
    @NotNull
    private final List<String> myExecutableFilesVariants;
    @NotNull
    private final List<String> myConfigFilesVariants;
    private JBCheckBox myCompassEnabledCheckBox;
    private TextFieldWithHistoryWithBrowseButton myCompassExecutableFileTextField;
    private TextFieldWithHistoryWithBrowseButton myCompassConfigPathTextField;
    private JPanel myPanel;
    private JBLabel myErrorLabel;
    private JPanel mySettingsPanel;
    private String myLastValidatedExecutablePath;

    public CompassSettingsPanelImpl(@NotNull Module module, @NotNull List<String> executableFilesVariants, @NotNull List<String> configFilesVariants, boolean fullMode) {
        if (module == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(0);
        }
        if (executableFilesVariants == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(1);
        }
        if (configFilesVariants == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(2);
        }
        this.$$$setupUI$$$();
        this.myValidationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myCompassExecutableFileTextField.setPreferredSize(new Dimension(fullMode ? 100 : 400, -1));
        this.myCompassConfigPathTextField.setPreferredSize(new Dimension(fullMode ? 100 : 400, -1));
        this.myModule = module;
        this.myExecutableFilesVariants = executableFilesVariants;
        this.myConfigFilesVariants = configFilesVariants;
        this.myErrorLabel.setVisible(false);
        this.myCompassEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompassSettingsPanelImpl.this.updateUiComponents();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/sass/extensions/compass/CompassSettingsPanelImpl$1", "actionPerformed"));
            }
        });
        Project project = module.getProject();
        this.initCompassExecutableFileTextField(project, executableFilesVariants);
        CompassSettingsPanelImpl.initCompassConfigPathTextField(project, configFilesVariants, this.myCompassConfigPathTextField);
    }

    public static void initCompassConfigPathTextField(@NotNull Project project, @NotNull List<String> configFilesVariants, TextFieldWithHistoryWithBrowseButton textField) {
        if (project == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(3);
        }
        if (configFilesVariants == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(4);
        }
        FileChooserDescriptor configFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        configFileChooserDescriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        configFileChooserDescriptor.setShowFileSystemRoots(true);
        configFileChooserDescriptor.withTreeRootVisible(true);
        textField.addBrowseFolderListener(SASSBundle.message("compass.select.config.path.label"), null, project, configFileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        TextFieldWithHistory childComponent = (TextFieldWithHistory)textField.getChildComponent();
        FileChooserFactory.getInstance().installFileCompletion(childComponent.getTextEditor(), configFileChooserDescriptor, true, (Disposable)project);
        childComponent.setHistory(configFilesVariants);
        childComponent.setMinimumAndPreferredWidth(childComponent.getWidth());
    }

    @Override
    public boolean isModified(@Nullable CompassSettings compassSettings) {
        return this.isEnableOptionChanged(compassSettings) || this.isConfigFilePathChanged(compassSettings) || this.isExecutablePathChanged(compassSettings);
    }

    @Override
    public boolean isConfigFilePathChanged(@Nullable CompassSettings compassSettings) {
        return compassSettings != null && !compassSettings.getCompassConfigPath().equals(this.getCompassConfigPath());
    }

    @Override
    public boolean isExecutablePathChanged(@Nullable CompassSettings compassSettings) {
        return compassSettings != null && !compassSettings.getCompassExecutableFilePath().equals(this.getCompassExecutableFilePath());
    }

    @Override
    public boolean isEnableOptionChanged(@Nullable CompassSettings compassSettings) {
        return compassSettings != null && compassSettings.isCompassSupportEnabled() != this.isCompassSupportEnabled();
    }

    @Override
    public void apply(@Nullable CompassSettings compassSettings) {
        if (compassSettings != null) {
            compassSettings.setCompassSupportEnabled(this.isCompassSupportEnabled());
            compassSettings.setCompassExecutableFilePath(this.getCompassExecutableFilePath());
            compassSettings.setCompassConfigPath(this.getCompassConfigPath());
        }
    }

    @Override
    public void reset(@Nullable CompassSettings compassSettings) {
        if (compassSettings != null) {
            boolean compassSupportEnabled = compassSettings.isCompassSupportEnabled();
            this.myCompassEnabledCheckBox.setSelected(compassSupportEnabled);
            ((TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent()).setText(compassSettings.getCompassExecutableFilePath());
            ((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).setText(compassSettings.getCompassConfigPath());
        }
        if (compassSettings == null) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)false, (boolean)true);
        }
        this.updateUiComponents();
    }

    private boolean isCompassSupportEnabled() {
        return this.myCompassEnabledCheckBox.isSelected();
    }

    @NotNull
    private String getCompassExecutableFilePath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent()).getText());
        if (string == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String getCompassConfigPath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).getText());
        if (string == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private void updateUiComponents() {
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)this.myCompassEnabledCheckBox.isSelected(), (boolean)true);
        if (this.myCompassEnabledCheckBox.isSelected()) {
            if (((TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent()).getText().isEmpty()) {
                ((TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent()).setText((String)ContainerUtil.getFirstItem(this.myExecutableFilesVariants, (Object)""));
            }
            if (((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).getText().isEmpty()) {
                ((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).setText((String)ContainerUtil.getFirstItem(this.myConfigFilesVariants, (Object)""));
            }
        }
        this.myLastValidatedExecutablePath = null;
        this.scheduleExecutablePathValidation();
    }

    @Nullable
    private ValidationInfo validateExecutablePath() {
        if (!this.myCompassEnabledCheckBox.isSelected()) {
            return null;
        }
        String currentExecutablePath = ((TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent()).getText();
        if (this.myLastValidatedExecutablePath == null || !this.myLastValidatedExecutablePath.equals(currentExecutablePath)) {
            this.myLastValidatedExecutablePath = currentExecutablePath;
            if (StringUtil.isEmpty((String)currentExecutablePath)) {
                return new ValidationInfo(SASSBundle.message("compass.executable.not.exists"));
            }
            VirtualFile compassFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)currentExecutablePath));
            if (compassFile == null || compassFile.isDirectory() || compassFile.is(VFileProperty.SPECIAL)) {
                return new ValidationInfo(SASSBundle.message("compass.executable.not.exists"));
            }
            try {
                ProcessOutput output = SassRubyIntegrationHelper.getInstance().execScript(this.myModule, null, currentExecutablePath, new String[0]);
                if (output.getExitCode() != 0) {
                    LOGGER.info(SASSBundle.message("compass.executable.launch.error") + "\ncode: " + output.getExitCode() + "\nstderr: " + output.getStderr() + "\nstdout: " + output.getStdout());
                    return new ValidationInfo(SASSBundle.message("compass.executable.launch.error"));
                }
            }
            catch (ExecutionException e) {
                LOGGER.info((Throwable)e);
                return new ValidationInfo(SASSBundle.message("compass.executable.launch.error"));
            }
        }
        return null;
    }

    private void initCompassExecutableFileTextField(@NotNull Project project, @NotNull List<String> executableFilesVariants) {
        if (project == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(8);
        }
        if (executableFilesVariants == null) {
            CompassSettingsPanelImpl.$$$reportNull$$$0(9);
        }
        FileChooserDescriptor compassFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myCompassExecutableFileTextField.addBrowseFolderListener(SASSBundle.message("compass.select.executable.path.label"), null, project, compassFileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        TextFieldWithHistory childComponent = (TextFieldWithHistory)this.myCompassExecutableFileTextField.getChildComponent();
        FileChooserFactory.getInstance().installFileCompletion(childComponent.getTextEditor(), compassFileChooserDescriptor, true, (Disposable)project);
        childComponent.setHistory(executableFilesVariants);
        childComponent.setMinimumAndPreferredWidth(childComponent.getWidth());
        childComponent.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompassSettingsPanelImpl.this.scheduleExecutablePathValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/sass/extensions/compass/CompassSettingsPanelImpl$2", "textChanged"));
            }
        });
    }

    private void scheduleExecutablePathValidation() {
        this.myErrorLabel.setVisible(false);
        this.myValidationAlarm.cancelAllRequests();
        if (!this.myValidationAlarm.isDisposed()) {
            this.myValidationAlarm.addRequest(() -> {
                ValidationInfo info = this.validateExecutablePath();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (info != null) {
                        this.myErrorLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'><left>" + info.message + "</left></font>")));
                        this.myErrorLabel.setIcon(AllIcons.Actions.Lightning);
                        this.myErrorLabel.setVisible(true);
                    } else {
                        this.myErrorLabel.setVisible(false);
                    }
                    this.myErrorLabel.revalidate();
                });
            }, 700);
        }
    }

    @Override
    public void dispose() {
        this.myValidationAlarm.cancelAllRequests();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableFilesVariants";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesVariants";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassSettingsPanelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassSettingsPanelImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompassExecutableFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompassConfigPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initCompassConfigPathTextField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initCompassExecutableFileTextField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCompassEnabledCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.enabled.checkbox"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.executable.path"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.config.path"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myCompassExecutableFileTextField = textFieldWithHistoryWithBrowseButton2 = new TextFieldWithHistoryWithBrowseButton();
        jPanel.add((Component)textFieldWithHistoryWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(254, -1), null));
        this.myCompassConfigPathTextField = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        jPanel.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(254, -1), null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setVerticalAlignment(1);
        jBLabel.setVerticalTextPosition(1);
        jBLabel.setVisible(true);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

