require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_CDEFS_H_)) {
    eval 'sub _SYS_CDEFS_H_ () {1;}' unless defined(&_SYS_CDEFS_H_);
    if(defined(&__GNUC__)) {
	eval 'sub __GNUC_PREREQ__ {
	    my($x, $y) = @_;
    	    eval q((( &__GNUC__ == ($x)  &&  &__GNUC_MINOR__ >= ($y)) || ( &__GNUC__ > ($x))));
	}' unless defined(&__GNUC_PREREQ__);
    } else {
	eval 'sub __GNUC_PREREQ__ {
	    my($x, $y) = @_;
    	    eval q(0);
	}' unless defined(&__GNUC_PREREQ__);
    }
    unless(defined(&__has_feature)) {
	eval 'sub __has_feature {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&__has_feature);
    }
    unless(defined(&__has_extension)) {
	eval 'sub __has_extension () { &__has_feature;}' unless defined(&__has_extension);
    }
    require 'machine/cdefs.ph';
    if(defined(&__ELF__)) {
	require 'sys/cdefs_elf.ph';
    } else {
	require 'sys/cdefs_aout.ph';
    }
    if(defined(&__GNUC__)) {
	eval 'sub __strict_weak_alias {
	    my($alias,$sym) = @_;
    	    eval q( &__unused  &static  &__typeof__($alias) * &__weak_alias_$alias = $sym;  &__weak_alias($alias,$sym));
	}' unless defined(&__strict_weak_alias);
    } else {
	eval 'sub __strict_weak_alias {
	    my($alias,$sym) = @_;
    	    eval q( &__weak_alias($alias,$sym));
	}' unless defined(&__strict_weak_alias);
    }
    unless(defined(&__compactcall)) {
	eval 'sub __compactcall () {1;}' unless defined(&__compactcall);
    }
    eval 'sub ___STRING {
        my($x) = @_;
	    eval q( &__STRING($x));
    }' unless defined(&___STRING);
    eval 'sub ___CONCAT {
        my($x,$y) = @_;
	    eval q( &__CONCAT($x,$y));
    }' unless defined(&___CONCAT);
    if((defined(&__STDC__) ? &__STDC__ : undef) || defined(&__cplusplus)) {
	eval 'sub __P {
	    my($protos) = @_;
    	    eval q($protos);
	}' unless defined(&__P);
	eval 'sub __CONCAT {
	    my($x,$y) = @_;
    	    eval q($x  $y);
	}' unless defined(&__CONCAT);
	eval 'sub __STRING {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&__STRING);
	eval 'sub __const () { &const;}' unless defined(&__const);
	eval 'sub __signed () {\'signed\';}' unless defined(&__signed);
	eval 'sub __volatile () { &volatile;}' unless defined(&__volatile);
	eval 'sub __CONCAT3 {
	    my($a,$b,$c) = @_;
    	    eval q($a  $b  $c);
	}' unless defined(&__CONCAT3);
	eval 'sub __CONCAT4 {
	    my($a,$b,$c,$d) = @_;
    	    eval q($a  $b  $c  $d);
	}' unless defined(&__CONCAT4);
	eval 'sub __CONCAT5 {
	    my($a,$b,$c,$d,$e) = @_;
    	    eval q($a  $b  $c  $d  $e);
	}' unless defined(&__CONCAT5);
	eval 'sub __CONCAT6 {
	    my($a,$b,$c,$d,$e,$f) = @_;
    	    eval q($a  $b  $c  $d  $e  $f);
	}' unless defined(&__CONCAT6);
	eval 'sub __CONCAT7 {
	    my($a,$b,$c,$d,$e,$f,$g) = @_;
    	    eval q($a  $b  $c  $d  $e  $f  $g);
	}' unless defined(&__CONCAT7);
	eval 'sub __CONCAT8 {
	    my($a,$b,$c,$d,$e,$f,$g,$h) = @_;
    	    eval q($a  $b  $c  $d  $e  $f  $g  $h);
	}' unless defined(&__CONCAT8);
	if(defined(&__cplusplus) || defined(&__PCC__)) {
	    eval 'sub __inline () { &inline;}' unless defined(&__inline);
	} else {
	    if(!defined(&__GNUC__)  && !defined(&__lint__)) {
		eval 'sub __inline () {1;}' unless defined(&__inline);
	    }
	}
    } else {
	eval 'sub __P {
	    my($protos) = @_;
    	    eval q(());
	}' unless defined(&__P);
	eval 'sub __CONCAT {
	    my($x,$y) = @_;
    	    eval q($x $y);
	}' unless defined(&__CONCAT);
	eval 'sub __STRING {
	    my($x) = @_;
    	    eval q(\\"x\\");
	}' unless defined(&__STRING);
	unless(defined(&__GNUC__)) {
	    eval 'sub __const () {1;}' unless defined(&__const);
	    eval 'sub __inline () {1;}' unless defined(&__inline);
	    eval 'sub __signed () {1;}' unless defined(&__signed);
	    eval 'sub __volatile () {1;}' unless defined(&__volatile);
	}
	unless(defined(&NO_ANSI_KEYWORDS)) {
	    eval 'sub const () { &__const;}' unless defined(&const);
	    eval 'sub inline () { &__inline;}' unless defined(&inline);
	    eval 'sub signed () { &__signed;}' unless defined(&signed);
	    eval 'sub volatile () { &__volatile;}' unless defined(&volatile);
	}
    }
    if(defined(&__AUDIT__)) {
	eval 'sub __aconst () { &__const;}' unless defined(&__aconst);
    } else {
	eval 'sub __aconst () {1;}' unless defined(&__aconst);
    }
    if(defined(&__COUNTER__)) {
	eval 'sub __CTASSERT {
	    my($x) = @_;
    	    eval q( &__CTASSERT0($x,  &__ctassert,  &__COUNTER__));
	}' unless defined(&__CTASSERT);
    } else {
	eval 'sub __CTASSERT {
	    my($x) = @_;
    	    eval q( &__CTASSERT99($x,  &__INCLUDE_LEVEL__,  &__LINE__));
	}' unless defined(&__CTASSERT);
	eval 'sub __CTASSERT99 {
	    my($x, $a, $b) = @_;
    	    eval q( &__CTASSERT0($x,  &__CONCAT( &__ctassert,$a),  &__CONCAT( &_,$b)));
	}' unless defined(&__CTASSERT99);
    }
    eval 'sub __CTASSERT0 {
        my($x, $y, $z) = @_;
	    eval q( &__CTASSERT1($x, $y, $z));
    }' unless defined(&__CTASSERT0);
    eval 'sub __CTASSERT1 {
        my($x, $y, $z) = @_;
	    eval q(\'struct y\'  $z   &_struct { \'unsigned int y\'  $z : ($x) ? 1: -1; });
    }' unless defined(&__CTASSERT1);
    eval 'sub __UNCONST {
        my($a) = @_;
	    eval q((( &void *)( &const  &void *)($a)));
    }' unless defined(&__UNCONST);
    eval 'sub __UNVOLATILE {
        my($a) = @_;
	    eval q((( &void *)( &volatile  &void *)($a)));
    }' unless defined(&__UNVOLATILE);
    eval 'sub __FPTRCAST {
        my($t, $f) = @_;
	    eval q((($t)( &void *)($f)));
    }' unless defined(&__FPTRCAST);
    if(! &__GNUC_PREREQ__(2, 0)) {
	eval 'sub __extension__ () {1;}' unless defined(&__extension__);
    }
    if(! &__GNUC_PREREQ__(2, 0)  && !defined(&__lint__)) {
	eval 'sub __attribute__ {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&__attribute__);
    }
    if( &__GNUC_PREREQ__(2, 5) || defined(&__lint__)) {
	eval 'sub __dead () { &__attribute__(( &__noreturn__));}' unless defined(&__dead);
    }
 elsif(defined(&__GNUC__)) {
	eval 'sub __dead () { &__volatile;}' unless defined(&__dead);
    } else {
	eval 'sub __dead () {1;}' unless defined(&__dead);
    }
    if( &__GNUC_PREREQ__(2, 96) || defined(&__lint__)) {
	eval 'sub __pure () { &__attribute__(( &__pure__));}' unless defined(&__pure);
    }
 elsif(defined(&__GNUC__)) {
	eval 'sub __pure () { &__const;}' unless defined(&__pure);
    } else {
	eval 'sub __pure () {1;}' unless defined(&__pure);
    }
    if( &__GNUC_PREREQ__(2, 5) || defined(&__lint__)) {
	eval 'sub __constfunc () { &__attribute__(( &__const__));}' unless defined(&__constfunc);
    } else {
	eval 'sub __constfunc () {1;}' unless defined(&__constfunc);
    }
    if( &__GNUC_PREREQ__(3, 0) || defined(&__lint__)) {
	eval 'sub __noinline () { &__attribute__(( &__noinline__));}' unless defined(&__noinline);
    } else {
	eval 'sub __noinline () {1;}' unless defined(&__noinline);
    }
    if( &__GNUC_PREREQ__(3, 0) || defined(&__lint__)) {
	eval 'sub __always_inline () { &__attribute__(( &__always_inline__));}' unless defined(&__always_inline);
    } else {
	eval 'sub __always_inline () {1;}' unless defined(&__always_inline);
    }
    if( &__GNUC_PREREQ__(4, 0) || defined(&__lint__)) {
	eval 'sub __null_sentinel () { &__attribute__(( &__sentinel__));}' unless defined(&__null_sentinel);
    } else {
	eval 'sub __null_sentinel () {1;}' unless defined(&__null_sentinel);
    }
    if( &__GNUC_PREREQ__(4, 1) || defined(&__lint__)) {
	eval 'sub __returns_twice () { &__attribute__(( &__returns_twice__));}' unless defined(&__returns_twice);
    } else {
	eval 'sub __returns_twice () {1;}' unless defined(&__returns_twice);
    }
    if( &__GNUC_PREREQ__(4, 5) || defined(&__lint__)) {
	eval 'sub __noclone () { &__attribute__(( &__noclone__));}' unless defined(&__noclone);
    } else {
	eval 'sub __noclone () {1;}' unless defined(&__noclone);
    }
    if( &__GNUC_PREREQ__(2, 7) || defined(&__lint__)) {
	eval 'sub __unused () { &__attribute__(( &__unused__));}' unless defined(&__unused);
    } else {
	eval 'sub __unused () {1;}' unless defined(&__unused);
    }
    if( &__GNUC_PREREQ__(3, 1) || defined(&__lint__)) {
	eval 'sub __used () { &__attribute__(( &__used__));}' unless defined(&__used);
    } else {
	eval 'sub __used () { &__unused;}' unless defined(&__used);
    }
    if((defined(&_KERNEL)  && defined(&DIAGNOSTIC)) || (!defined(&_KERNEL)  && !defined(&NDEBUG))) {
	eval 'sub __diagused () {1;}' unless defined(&__diagused);
    } else {
	eval 'sub __diagused () { &__unused;}' unless defined(&__diagused);
    }
    if(defined(&DEBUG)) {
	eval 'sub __debugused () {1;}' unless defined(&__debugused);
    } else {
	eval 'sub __debugused () { &__unused;}' unless defined(&__debugused);
    }
    if( &__GNUC_PREREQ__(3, 1) || defined(&__lint__)) {
	eval 'sub __noprofile () { &__attribute__(( &__no_instrument_function__));}' unless defined(&__noprofile);
    } else {
	eval 'sub __noprofile () {1;}' unless defined(&__noprofile);
    }
    if( &__GNUC_PREREQ__(4, 6) || defined(&__clang__) || defined(&__lint__)) {
	eval 'sub __unreachable () {
	    eval q( &__builtin_unreachable());
	}' unless defined(&__unreachable);
    } else {
	eval 'sub __unreachable () {
	    eval q( &do {}  &while ( 0));
	}' unless defined(&__unreachable);
    }
    if(defined(&_KERNEL) || defined(&_RUMPKERNEL)) {
	if(defined(&__clang__)  &&  &__has_feature((defined(&address_sanitizer) ? &address_sanitizer : undef))) {
	    eval 'sub __noasan () { &__attribute__(( &no_sanitize("kernel-address", "address")));}' unless defined(&__noasan);
	}
 elsif( &__GNUC_PREREQ__(4, 9)  && defined(&__SANITIZE_ADDRESS__)) {
	    eval 'sub __noasan () { &__attribute__(( &no_sanitize_address));}' unless defined(&__noasan);
	} else {
	    eval 'sub __noasan () {1;}' unless defined(&__noasan);
	}
	if(defined(&__clang__)  &&  &__has_feature((defined(&thread_sanitizer) ? &thread_sanitizer : undef))) {
	    eval 'sub __nocsan () { &__attribute__(( &no_sanitize("thread")));}' unless defined(&__nocsan);
	}
 elsif( &__GNUC_PREREQ__(4, 9)  && defined(&__SANITIZE_THREAD__)) {
	    eval 'sub __nocsan () { &__attribute__(( &no_sanitize_thread));}' unless defined(&__nocsan);
	} else {
	    eval 'sub __nocsan () {1;}' unless defined(&__nocsan);
	}
	if(defined(&__clang__)  &&  &__has_feature((defined(&memory_sanitizer) ? &memory_sanitizer : undef))) {
	    eval 'sub __nomsan () { &__attribute__(( &no_sanitize("kernel-memory", "memory")));}' unless defined(&__nomsan);
	} else {
	    eval 'sub __nomsan () {1;}' unless defined(&__nomsan);
	}
	if(defined(&__clang__)  &&  &__has_feature((defined(&undefined_behavior_sanitizer) ? &undefined_behavior_sanitizer : undef))) {
	    eval 'sub __noubsan () { &__attribute__(( &no_sanitize("undefined")));}' unless defined(&__noubsan);
	}
 elsif( &__GNUC_PREREQ__(4, 9)  && defined(&__SANITIZE_UNDEFINED__)) {
	    eval 'sub __noubsan () { &__attribute__(( &no_sanitize_undefined));}' unless defined(&__noubsan);
	} else {
	    eval 'sub __noubsan () {1;}' unless defined(&__noubsan);
	}
    }
    if(defined(&__COVERITY__) ||  &__has_feature((defined(&address_sanitizer) ? &address_sanitizer : undef)) || defined(&__SANITIZE_ADDRESS__) ||  &__has_feature((defined(&leak_sanitizer) ? &leak_sanitizer : undef)) || defined(&__SANITIZE_LEAK__)) {
	eval 'sub __NO_LEAKS () {1;}' unless defined(&__NO_LEAKS);
    }
    eval 'sub __nothing () {( ( &void)0);}' unless defined(&__nothing);
    if(defined(&__cplusplus)) {
	eval 'sub __BEGIN_EXTERN_C () { &extern "C" {;}' unless defined(&__BEGIN_EXTERN_C);
	eval 'sub __END_EXTERN_C () {};}' unless defined(&__END_EXTERN_C);
	eval 'sub __static_cast {
	    my($x,$y) = @_;
    	    eval q( &static_cast<$x>($y));
	}' unless defined(&__static_cast);
    } else {
	eval 'sub __BEGIN_EXTERN_C () {1;}' unless defined(&__BEGIN_EXTERN_C);
	eval 'sub __END_EXTERN_C () {1;}' unless defined(&__END_EXTERN_C);
	eval 'sub __static_cast {
	    my($x,$y) = @_;
    	    eval q(($x)$y);
	}' unless defined(&__static_cast);
    }
    if( &__GNUC_PREREQ__(4, 0) || defined(&__lint__)) {
	eval 'sub __dso_public () { &__attribute__(( &__visibility__("default")));}' unless defined(&__dso_public);
	eval 'sub __dso_hidden () { &__attribute__(( &__visibility__("hidden")));}' unless defined(&__dso_hidden);
	eval 'sub __BEGIN_PUBLIC_DECLS () { &_Pragma("GCC visibility push(default)")  &__BEGIN_EXTERN_C;}' unless defined(&__BEGIN_PUBLIC_DECLS);
	eval 'sub __END_PUBLIC_DECLS () { &__END_EXTERN_C  &_Pragma("GCC visibility pop");}' unless defined(&__END_PUBLIC_DECLS);
	eval 'sub __BEGIN_HIDDEN_DECLS () { &_Pragma("GCC visibility push(hidden)")  &__BEGIN_EXTERN_C;}' unless defined(&__BEGIN_HIDDEN_DECLS);
	eval 'sub __END_HIDDEN_DECLS () { &__END_EXTERN_C  &_Pragma("GCC visibility pop");}' unless defined(&__END_HIDDEN_DECLS);
    } else {
	eval 'sub __dso_public () {1;}' unless defined(&__dso_public);
	eval 'sub __dso_hidden () {1;}' unless defined(&__dso_hidden);
	eval 'sub __BEGIN_PUBLIC_DECLS () { &__BEGIN_EXTERN_C;}' unless defined(&__BEGIN_PUBLIC_DECLS);
	eval 'sub __END_PUBLIC_DECLS () { &__END_EXTERN_C;}' unless defined(&__END_PUBLIC_DECLS);
	eval 'sub __BEGIN_HIDDEN_DECLS () { &__BEGIN_EXTERN_C;}' unless defined(&__BEGIN_HIDDEN_DECLS);
	eval 'sub __END_HIDDEN_DECLS () { &__END_EXTERN_C;}' unless defined(&__END_HIDDEN_DECLS);
    }
    if( &__GNUC_PREREQ__(4, 2) || defined(&__lint__)) {
	eval 'sub __dso_protected () { &__attribute__(( &__visibility__("protected")));}' unless defined(&__dso_protected);
    } else {
	eval 'sub __dso_protected () {1;}' unless defined(&__dso_protected);
    }
    eval 'sub __BEGIN_DECLS () { &__BEGIN_PUBLIC_DECLS;}' unless defined(&__BEGIN_DECLS);
    eval 'sub __END_DECLS () { &__END_PUBLIC_DECLS;}' unless defined(&__END_DECLS);
    if(defined(&__GNUC__)  && defined(&__GNUC_STDC_INLINE__)) {
	eval 'sub __c99inline () { &extern  &__attribute__(( &__gnu_inline__))  &__inline;}' unless defined(&__c99inline);
    }
 elsif(defined(&__GNUC__)) {
	eval 'sub __c99inline () { &extern  &__inline;}' unless defined(&__c99inline);
    }
 elsif(defined(&__STDC_VERSION__) || defined(&__lint__)) {
	eval 'sub __c99inline () { &__inline;}' unless defined(&__c99inline);
    }
    if(defined(&__lint__)) {
	eval 'sub __thread () {1;}' unless defined(&__thread);
	eval 'sub __aligned {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&__aligned);
	eval 'sub __section {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&__section);
    }
 elsif( &__GNUC_PREREQ__(2, 7) || defined(&__PCC__) || defined(&__lint__)) {
	eval 'sub __packed () { &__attribute__(( &__packed__));}' unless defined(&__packed);
	eval 'sub __aligned {
	    my($x) = @_;
    	    eval q( &__attribute__(( &__aligned__($x))));
	}' unless defined(&__aligned);
	eval 'sub __section {
	    my($x) = @_;
    	    eval q( &__attribute__(( &__section__($x))));
	}' unless defined(&__section);
    }
 elsif(defined(&_MSC_VER)) {
	eval 'sub __packed () {1;}' unless defined(&__packed);
    } else {
	eval 'sub __packed () { &error:  &no  &__packed  &for  &this  &compiler;}' unless defined(&__packed);
	eval 'sub __aligned {
	    my($x) = @_;
    	    eval q( &error:  &no  &__aligned  &for  &this  &compiler);
	}' unless defined(&__aligned);
	eval 'sub __section {
	    my($x) = @_;
    	    eval q( &error:  &no  &__section  &for  &this  &compiler);
	}' unless defined(&__section);
    }
    if((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901) {
	eval 'sub __restrict () { &restrict;}' unless defined(&__restrict);
    }
 elsif( &__GNUC_PREREQ__(2, 92)) {
	eval 'sub __restrict () { &__restrict__;}' unless defined(&__restrict);
    } else {
	eval 'sub __restrict () {1;}' unless defined(&__restrict);
    }
    if(!((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901)  && !((defined(&__cplusplus) ? &__cplusplus : undef) - 0>= 201103)) {
	if( &__GNUC_PREREQ__(2, 4) || defined(&__lint__)) {
	    eval 'sub __func__ () { &__FUNCTION__;}' unless defined(&__func__);
	} else {
	    eval 'sub __func__ () {"";}' unless defined(&__func__);
	}
    }
    if(defined(&_KERNEL)  && defined(&NO_KERNEL_RCSIDS)) {
	undef(&__KERNEL_RCSID) if defined(&__KERNEL_RCSID);
	eval 'sub __KERNEL_RCSID {
	    my($_n, $_s) = @_;
    	    eval q();
	}' unless defined(&__KERNEL_RCSID);
	undef(&__RCSID) if defined(&__RCSID);
	eval 'sub __RCSID {
	    my($_s) = @_;
    	    eval q();
	}' unless defined(&__RCSID);
    }
    if(!defined(&_STANDALONE)  && !defined(&_KERNEL)) {
	if(defined(&__GNUC__) || defined(&__PCC__)) {
	    eval 'sub __RENAME {
	        my($x) = @_;
    		eval q( &___RENAME($x));
	    }' unless defined(&__RENAME);
	}
 elsif(defined(&__lint__)) {
	    eval 'sub __RENAME {
	        my($x) = @_;
    		eval q( &__symbolrename($x));
	    }' unless defined(&__RENAME);
	} else {
	    die("No function renaming possible");
	}
    } else {
	eval 'sub __RENAME {
	    my($x) = @_;
    	    eval q( &no  &renaming  &in  &kernel/ &standalone  &environment);
	}' unless defined(&__RENAME);
    }
    if( &__GNUC_PREREQ__(2, 95) || defined(&__lint__)) {
	eval 'sub __insn_barrier () {
	    eval q( &__asm  &__volatile(\\"\\":::\\"memory\\"));
	}' unless defined(&__insn_barrier);
    } else {
	eval 'sub __insn_barrier () {
	    eval q();
	}' unless defined(&__insn_barrier);
    }
    if( &__GNUC_PREREQ__(2, 96) || defined(&__lint__)) {
	eval 'sub __predict_true {
	    my($exp) = @_;
    	    eval q( &__builtin_expect(($exp) != 0, 1));
	}' unless defined(&__predict_true);
	eval 'sub __predict_false {
	    my($exp) = @_;
    	    eval q( &__builtin_expect(($exp) != 0, 0));
	}' unless defined(&__predict_false);
    } else {
	eval 'sub __predict_true {
	    my($exp) = @_;
    	    eval q(($exp));
	}' unless defined(&__predict_true);
	eval 'sub __predict_false {
	    my($exp) = @_;
    	    eval q(($exp));
	}' unless defined(&__predict_false);
    }
    if( &__GNUC_PREREQ__(2, 7) || defined(&__lint__)) {
	eval 'sub __printflike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q( &__attribute__(( &__format__ ( &__printf__, $fmtarg, $firstvararg))));
	}' unless defined(&__printflike);
	unless(defined(&__syslog_attribute__)) {
	    eval 'sub __syslog__ () { &__printf__;}' unless defined(&__syslog__);
	}
	eval 'sub __sysloglike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q( &__attribute__(( &__format__ ( &__syslog__, $fmtarg, $firstvararg))));
	}' unless defined(&__sysloglike);
	eval 'sub __scanflike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q( &__attribute__(( &__format__ ( &__scanf__, $fmtarg, $firstvararg))));
	}' unless defined(&__scanflike);
	eval 'sub __format_arg {
	    my($fmtarg) = @_;
    	    eval q( &__attribute__(( &__format_arg__ ($fmtarg))));
	}' unless defined(&__format_arg);
    } else {
	eval 'sub __printflike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q();
	}' unless defined(&__printflike);
	eval 'sub __scanflike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q();
	}' unless defined(&__scanflike);
	eval 'sub __sysloglike {
	    my($fmtarg, $firstvararg) = @_;
    	    eval q();
	}' unless defined(&__sysloglike);
	eval 'sub __format_arg {
	    my($fmtarg) = @_;
    	    eval q();
	}' unless defined(&__format_arg);
    }
    eval 'sub __link_set_foreach {
        my($pvar, $set) = @_;
	    eval q( &for ($pvar =  &__link_set_start($set); $pvar <  &__link_set_end($set); $pvar++));
    }' unless defined(&__link_set_foreach);
    eval 'sub __link_set_entry {
        my($set, $idx) = @_;
	    eval q(( &__link_set_start($set)[$idx]));
    }' unless defined(&__link_set_entry);
    if( &__GNUC_PREREQ__(4, 1) || defined(&__lint__)) {
	eval 'sub __alignof {
	    my($__t) = @_;
    	    eval q( &__alignof__($__t));
	}' unless defined(&__alignof);
    } else {
	eval 'sub __alignof {
	    my($__t) = @_;
    	    eval q(($sizeof{\'struct struct\' { \'char\'  &__x; $__t  &__y; }} - $sizeof{$__t}));
	}' unless defined(&__alignof);
    }
    eval 'sub __arraycount {
        my($__x) = @_;
	    eval q(($sizeof{$__x} / $sizeof{$__x->[0]}));
    }' unless defined(&__arraycount);
    unless(defined(&__ASSEMBLER__)) {
	eval 'sub __BIT {
	    my($__n) = @_;
    	    eval q(((( &__UINTMAX_TYPE__)($__n) >=  &__CHAR_BIT__ * $sizeof{ &__UINTMAX_TYPE__}) ? 0: (( &__UINTMAX_TYPE__)1<< ( &__UINTMAX_TYPE__)(($__n) & ( &__CHAR_BIT__ * $sizeof{ &__UINTMAX_TYPE__} - 1)))));
	}' unless defined(&__BIT);
	eval 'sub __MASK {
	    my($__n) = @_;
    	    eval q(( &__BIT($__n) - 1));
	}' unless defined(&__MASK);
	eval 'sub __MIN {
	    my($a,$b) = @_;
    	    eval q((( ($a)<=($b))?($a):($b)));
	}' unless defined(&__MIN);
	eval 'sub __MAX {
	    my($a,$b) = @_;
    	    eval q((( ($a)>($b))?($a):($b)));
	}' unless defined(&__MAX);
	eval 'sub __BITS {
	    my($__m, $__n) = @_;
    	    eval q((( &__BIT( &__MAX(($__m), ($__n)) + 1) - 1) ^ ( &__BIT( &__MIN(($__m), ($__n))) - 1)));
	}' unless defined(&__BITS);
    }
    eval 'sub __LOWEST_SET_BIT {
        my($__mask) = @_;
	    eval q((((($__mask) - 1) & ($__mask)) ^ ($__mask)));
    }' unless defined(&__LOWEST_SET_BIT);
    eval 'sub __PRIuBIT () { &PRIuMAX;}' unless defined(&__PRIuBIT);
    eval 'sub __PRIuBITS () { &__PRIuBIT;}' unless defined(&__PRIuBITS);
    eval 'sub __PRIxBIT () { &PRIxMAX;}' unless defined(&__PRIxBIT);
    eval 'sub __PRIxBITS () { &__PRIxBIT;}' unless defined(&__PRIxBITS);
    eval 'sub __SHIFTOUT {
        my($__x, $__mask) = @_;
	    eval q(((($__x) & ($__mask)) /  &__LOWEST_SET_BIT($__mask)));
    }' unless defined(&__SHIFTOUT);
    eval 'sub __SHIFTIN {
        my($__x, $__mask) = @_;
	    eval q((($__x) *  &__LOWEST_SET_BIT($__mask)));
    }' unless defined(&__SHIFTIN);
    eval 'sub __SHIFTOUT_MASK {
        my($__mask) = @_;
	    eval q( &__SHIFTOUT(($__mask), ($__mask)));
    }' unless defined(&__SHIFTOUT_MASK);
    if(defined(&__cplusplus)) {
	eval 'sub __CAST {
	    my($__dt, $__st) = @_;
    	    eval q( &static_cast<$__dt>($__st));
	}' unless defined(&__CAST);
    } else {
	eval 'sub __CAST {
	    my($__dt, $__st) = @_;
    	    eval q((($__dt)($__st)));
	}' unless defined(&__CAST);
    }
    eval 'sub __CASTV {
        my($__dt, $__st) = @_;
	    eval q( &__CAST($__dt,  &__CAST( &void *, $__st)));
    }' unless defined(&__CASTV);
    eval 'sub __CASTCV {
        my($__dt, $__st) = @_;
	    eval q( &__CAST($__dt,  &__CAST( &const  &void *, $__st)));
    }' unless defined(&__CASTCV);
    eval 'sub __USE {
        my($a) = @_;
	    eval q(( ( &void)($a)));
    }' unless defined(&__USE);
    eval 'sub __type_mask {
        my($t) = @_;
	    eval q(( $sizeof{$t} < $sizeof{ &__INTMAX_TYPE__} ? (~((1 << ($sizeof{$t} *  &__CHAR_BIT__)) - 1)) : 0));
    }' unless defined(&__type_mask);
    unless(defined(&__ASSEMBLER__)) {
    } else {
	eval 'sub __zeroll () {
	    eval q((0));
	}' unless defined(&__zeroll);
	eval 'sub __zeroull () {
	    eval q((0));
	}' unless defined(&__zeroull);
    }
    eval 'sub __negative_p {
        my($x) = @_;
	    eval q((!(($x) > 0)  && (($x) != 0)));
    }' unless defined(&__negative_p);
    eval 'sub __type_min_s {
        my($t) = @_;
	    eval q((($t)((1 << ($sizeof{$t} *  &__CHAR_BIT__ - 1)))));
    }' unless defined(&__type_min_s);
    eval 'sub __type_max_s {
        my($t) = @_;
	    eval q((($t)~((1 << ($sizeof{$t} *  &__CHAR_BIT__ - 1)))));
    }' unless defined(&__type_max_s);
    eval 'sub __type_min_u {
        my($t) = @_;
	    eval q((($t)0));
    }' unless defined(&__type_min_u);
    eval 'sub __type_max_u {
        my($t) = @_;
	    eval q((($t)~0));
    }' unless defined(&__type_max_u);
    eval 'sub __type_is_signed {
        my($t) = @_;
	    eval q((  &__type_min_s($t) + ($t)1< ($t)1));
    }' unless defined(&__type_is_signed);
    eval 'sub __type_min {
        my($t) = @_;
	    eval q(( &__type_is_signed($t) ?  &__type_min_s($t) :  &__type_min_u($t)));
    }' unless defined(&__type_min);
    eval 'sub __type_max {
        my($t) = @_;
	    eval q(( &__type_is_signed($t) ?  &__type_max_s($t) :  &__type_max_u($t)));
    }' unless defined(&__type_max);
    eval 'sub __type_fit_u {
        my($t, $a) = @_;
	    eval q(( ! &__negative_p($a)  && (( &__UINTMAX_TYPE__)(($a) +  &__zeroull()) <= ( &__UINTMAX_TYPE__) &__type_max_u($t))));
    }' unless defined(&__type_fit_u);
    eval 'sub __type_fit_s {
        my($t, $a) = @_;
	    eval q((  &__negative_p($a) ? (( &__INTMAX_TYPE__)(($a) +  &__zeroll()) >= ( &__INTMAX_TYPE__) &__type_min_s($t)) : (( &__INTMAX_TYPE__)(($a) +  &__zeroll()) >= ( &__INTMAX_TYPE__)0 && (( &__INTMAX_TYPE__)(($a) +  &__zeroll()) <= ( &__INTMAX_TYPE__) &__type_max_s($t)))));
    }' unless defined(&__type_fit_s);
    eval 'sub __type_fit {
        my($t, $a) = @_;
	    eval q(( &__type_is_signed($t) ?  &__type_fit_s($t, $a) :  &__type_fit_u($t, $a)));
    }' unless defined(&__type_fit);
}
1;
