/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.archive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;

public class BZip2Analyzer
extends FileAnalyzer {
    private FileAnalyzer.Genre g;
    private FileAnalyzer fa;

    @Override
    public FileAnalyzer.Genre getGenre() {
        if (this.g != null) {
            return this.g;
        }
        return super.getGenre();
    }

    protected BZip2Analyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        StreamSource bzSrc = BZip2Analyzer.wrap(src);
        String path = doc.get("path");
        if (path != null && (path.endsWith(".bz2") || path.endsWith(".BZ2") || path.endsWith(".bz"))) {
            String newname = path.substring(0, path.lastIndexOf(46));
            try (InputStream in = bzSrc.getStream();){
                this.fa = AnalyzerGuru.getAnalyzer(in, newname);
            }
            if (this.fa instanceof BZip2Analyzer) {
                this.fa = null;
            } else {
                this.g = this.fa.getGenre() == FileAnalyzer.Genre.PLAIN || this.fa.getGenre() == FileAnalyzer.Genre.XREFABLE ? FileAnalyzer.Genre.XREFABLE : FileAnalyzer.Genre.DATA;
                this.fa.analyze(doc, bzSrc, xrefOut);
                if (doc.get("t") != null) {
                    doc.removeField("t");
                    if (this.g == FileAnalyzer.Genre.XREFABLE) {
                        doc.add((IndexableField)new Field("t", this.g.typeName(), AnalyzerGuru.string_ft_stored_nanalyzed_norms));
                    }
                }
            }
        }
    }

    private static StreamSource wrap(final StreamSource src) {
        return new StreamSource(){

            @Override
            public InputStream getStream() throws IOException {
                InputStream raw = src.getStream();
                if (raw.read() == 66 && raw.read() == 90) {
                    return new BufferedInputStream(new CBZip2InputStream(raw));
                }
                throw new IOException("Not BZIP2 format");
            }
        };
    }

    @Override
    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.fa != null) {
            return this.fa.createComponents(fieldName, reader);
        }
        return super.createComponents(fieldName, reader);
    }
}

