(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)

(* This module contains the configuration of your Eliom application.
    You can take some configuration options from Ocsigen server's
    configuration file, as shown below.

    See https://ocsigen.org/ocsigenserver/ for more information about
    the configuration file and how to get the information of the
    config file in an Eliom project. *)

(* Variable definitions *)

(* The following variables are changed by the ocsigenserver
   configuration file. *)

(* Configuration of the application itself. *)

let app_name = ref ""
let css_name = ref ""

(* The name of the avatar directory. *)
let avatar_dir = ref []

(* Database configuration. *)

let os_db_host = ref None
let os_db_port = ref None
let os_db_user = ref None
let os_db_password = ref None
let os_db_database = ref None
let os_db_unix_domain_socket_dir = ref None

(* Get variables values from the ocsigenserver configuration file *)

(* Application configuration *)
let app =
  let open Ocsigen_extensions.Configuration in
  let attributes =
    [ attribute ~name:"name" ~obligatory:true (fun h -> app_name := h)
    ; attribute ~name:"css" ~obligatory:true (fun h -> css_name := h) ]
  in
  element ~name:"app" ~obligatory:true ~attributes ()

(* Avatars configuration *)
let avatars =
  let open Ocsigen_extensions.Configuration in
  let attributes =
    [ attribute ~name:"dir" ~obligatory:true (fun h ->
          avatar_dir := Eliom_lib.String.split '/' h) ]
  in
  element ~name:"avatars" ~obligatory:true ~attributes ()

(* Database configuration *)
let os_db =
  let open Ocsigen_extensions.Configuration in
  let attributes =
    [ attribute ~name:"host" (fun h -> os_db_host := Some h)
    ; attribute ~name:"port" (fun h ->
          os_db_port :=
            try Some (int_of_string h)
            with Failure _ ->
              raise
              @@ Ocsigen_extensions.Error_in_config_file
                   "port is not an integer")
    ; attribute ~name:"user" (fun h -> os_db_user := Some h)
    ; attribute ~name:"password" (fun h -> os_db_password := Some h)
    ; attribute ~name:"database" (fun h -> os_db_database := Some h)
    ; attribute ~name:"unix_domain_socket_dir" (fun h ->
          os_db_unix_domain_socket_dir := Some h) ]
  in
  element ~name:"os-db" ~attributes ()

let _ = Eliom_config.parse_config [app; avatars; os_db]
