/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;

public class AlterConfigsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final Schema ALTER_CONFIGS_RESPONSE_ENTITY_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING));
    private static final Schema ALTER_CONFIGS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("resources", new ArrayOf(ALTER_CONFIGS_RESPONSE_ENTITY_V0)));
    private final int throttleTimeMs;
    private final Map<Resource, ApiError> errors;

    public static Schema[] schemaVersions() {
        return new Schema[]{ALTER_CONFIGS_RESPONSE_V0};
    }

    public AlterConfigsResponse(int throttleTimeMs, Map<Resource, ApiError> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public AlterConfigsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.errors = new HashMap<Resource, ApiError>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ApiError error = new ApiError(resourceStruct);
            ResourceType resourceType = ResourceType.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            this.errors.put(new Resource(resourceType, resourceName), error);
        }
    }

    public Map<Resource, ApiError> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ALTER_CONFIGS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<Resource, ApiError> entry : this.errors.entrySet()) {
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            Resource resource = entry.getKey();
            entry.getValue().write(resourceStruct);
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        return struct;
    }

    public static AlterConfigsResponse parse(ByteBuffer buffer, short version) {
        return new AlterConfigsResponse(ApiKeys.ALTER_CONFIGS.parseResponse(version, buffer));
    }
}

