/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private final InputStream delegate;
    private long count = 0L;

    public CountingInputStream(InputStream inputStream) {
        this.delegate = inputStream;
    }

    @Override
    public int read() {
        ++this.count;
        try {
            return this.delegate.read();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b) {
        try {
            int read = this.delegate.read(b);
            this.count += (long)read;
            return read;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int length) {
        try {
            int read = this.delegate.read(b, off, length);
            this.count += (long)read;
            return read;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long skip(long n) {
        try {
            long skipped = this.delegate.skip(n);
            this.count += skipped;
            return skipped;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int available() {
        try {
            return this.delegate.available();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void mark(int readLimit) {
        this.delegate.mark(readLimit);
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.count = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public long getCount() {
        return this.count;
    }
}

