/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import java.io.FileNotFoundException;

public class ExifReader
implements MetadataReader {
    private byte[] _data;
    private boolean motorollaByteOrder;
    private Metadata _metadata;
    static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifInteropDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$GpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$OlympusMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType1MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType2MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CanonMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CasioMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$FujiFilmMakernoteDirectory;

    public ExifReader(File file) throws JpegProcessingException, FileNotFoundException {
        this(new JpegSegmentReader(file).readSegment((byte)-31));
    }

    public ExifReader(byte[] byArray) {
        this._data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        Directory directory = this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (this._data.length <= 14) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return this._metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            directory.addError("Exif data segment doesn't begin with 'Exif'");
            return this._metadata;
        }
        String string = new String(this._data, 6, 2);
        if (!this.setByteOrder(string)) {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering");
            return this._metadata;
        }
        if (this.get16Bits(8) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this._metadata;
        }
        int n = this.get32Bits(10) + 6;
        if (n >= this._data.length - 1) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            n = 14;
        }
        this.processDirectory(directory, n);
        this.extractThumbnail(directory);
        return this._metadata;
    }

    private void extractThumbnail(Directory directory) {
        if (!(directory instanceof ExifDirectory)) {
            return;
        }
        if (!directory.containsTag(514) || !directory.containsTag(513)) {
            return;
        }
        try {
            int n = directory.getInt(513);
            int n2 = directory.getInt(514);
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = this._data[6 + n + n3];
                ++n3;
            }
            directory.setByteArray(61441, byArray);
        }
        catch (Throwable throwable) {
            directory.addError("Unable to extract thumbnail: " + throwable.getMessage());
        }
    }

    private boolean setByteOrder(String string) {
        if ("MM".equals(string)) {
            this.motorollaByteOrder = true;
        } else if ("II".equals(string)) {
            this.motorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(Directory directory, int n) {
        int n2;
        int n3 = this.get16Bits(n);
        if (!this.isDirectoryLengthValid(n)) {
            directory.addError("Illegally sized directory");
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            n2 = this.calculateDirectoryEntryOffset(n, n4);
            int n5 = this.get16Bits(n2);
            int n6 = this.get16Bits(n2 + 2);
            if (n6 < 0 || n6 > 12) {
                directory.addError("Invalid format code: " + n6);
            } else {
                int n7 = this.get32Bits(n2 + 4);
                int n8 = n7 * BYTES_PER_FORMAT[n6];
                int n9 = this.calculateTagValueOffset(n8, n2);
                if (n9 < 0) {
                    directory.addError("Illegal pointer offset value in EXIF");
                } else {
                    int n10 = 6 + this.get32Bits(n9);
                    switch (n5) {
                        case 34665: {
                            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifDirectory") : class$com$drew$metadata$exif$ExifDirectory), n10);
                            break;
                        }
                        case 40965: {
                            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifInteropDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifInteropDirectory") : class$com$drew$metadata$exif$ExifInteropDirectory), n10);
                            break;
                        }
                        case 34853: {
                            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$GpsDirectory == null ? ExifReader.class$("com.drew.metadata.exif.GpsDirectory") : class$com$drew$metadata$exif$GpsDirectory), n10);
                            break;
                        }
                        case 37500: {
                            this.processMakerNote(n9);
                            break;
                        }
                        default: {
                            this.processTag(directory, n5, n9, n7, n6);
                        }
                    }
                }
            }
            ++n4;
        }
        n2 = this.get32Bits(n + 2 + 12 * n3);
        if (n2 != 0) {
            if ((n2 += 6) >= this._data.length) {
                return;
            }
            this.processDirectory(directory, n2);
        }
    }

    private void processMakerNote(int n) {
        Directory directory = this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (directory == null) {
            return;
        }
        String string = directory.getString(271);
        if ("OLYMP".equals(new String(this._data, n, 5))) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$OlympusMakernoteDirectory == null ? (class$com$drew$metadata$exif$OlympusMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.OlympusMakernoteDirectory")) : class$com$drew$metadata$exif$OlympusMakernoteDirectory), n + 8);
        } else if ("NIKON".equalsIgnoreCase(string)) {
            if ("Nikon".equals(new String(this._data, n, 5))) {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType1MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType1MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType1MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType1MakernoteDirectory), n + 8);
            } else {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType2MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType2MakernoteDirectory), n);
            }
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CanonMakernoteDirectory == null ? (class$com$drew$metadata$exif$CanonMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CanonMakernoteDirectory")) : class$com$drew$metadata$exif$CanonMakernoteDirectory), n);
        } else if ("Casio".equalsIgnoreCase(string)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CasioMakernoteDirectory == null ? (class$com$drew$metadata$exif$CasioMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CasioMakernoteDirectory")) : class$com$drew$metadata$exif$CasioMakernoteDirectory), n);
        } else if ("FUJIFILM".equals(new String(this._data, n, 8)) || "Fujifilm".equalsIgnoreCase(string)) {
            boolean bl = this.motorollaByteOrder;
            this.motorollaByteOrder = false;
            int n2 = n + this.get32Bits(n + 8);
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$FujiFilmMakernoteDirectory == null ? (class$com$drew$metadata$exif$FujiFilmMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.FujiFilmMakernoteDirectory")) : class$com$drew$metadata$exif$FujiFilmMakernoteDirectory), n2);
            this.motorollaByteOrder = bl;
        }
    }

    private boolean isDirectoryLengthValid(int n) {
        int n2 = this.get16Bits(n);
        int n3 = 2 + 12 * n2 + 4;
        return n3 + n + 6 < this._data.length;
    }

    private void processTag(Directory directory, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 2: 
            case 7: {
                String string = this.readString(n2, n3);
                directory.setString(n, string);
                break;
            }
            case 5: 
            case 10: {
                if (n3 == 1) {
                    Rational rational = new Rational(this.get32Bits(n2), this.get32Bits(n2 + 4));
                    directory.setRational(n, rational);
                    break;
                }
                Rational[] rationalArray = new Rational[n3];
                int n5 = 0;
                while (n5 < n3) {
                    rationalArray[n5] = new Rational(this.get32Bits(n2 + 8 * n5), this.get32Bits(n2 + 4 + 8 * n5));
                    ++n5;
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 1: 
            case 6: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n6] = this._data[n2];
                    ++n6;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 11: 
            case 12: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = this._data[n2];
                    ++n7;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: 
            case 8: {
                if (n3 == 1) {
                    int n8 = this.get16Bits(n2);
                    directory.setInt(n, n8);
                    break;
                }
                int[] nArray = new int[n3];
                int n9 = 0;
                while (n9 < n3) {
                    nArray[n9] = this.get16Bits(n2 + n9 * 2);
                    ++n9;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n10 = this.get32Bits(n2);
                    directory.setInt(n, n10);
                    break;
                }
                int[] nArray = new int[n3];
                int n11 = 0;
                while (n11 < n3) {
                    nArray[n11] = this.get32Bits(n2 + n11 * 4);
                    ++n11;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("unknown format code " + n4);
            }
        }
    }

    private int calculateTagValueOffset(int n, int n2) {
        if (n > 4) {
            int n3 = this.get32Bits(n2 + 8);
            if (n3 + n > this._data.length) {
                return -1;
            }
            return 6 + n3;
        }
        return n2 + 8;
    }

    private String readString(int n, int n2) {
        int n3 = 0;
        while (n + n3 < this._data.length && this._data[n + n3] != 0 && n3 < n2) {
            ++n3;
        }
        return new String(this._data, n, n3);
    }

    private int calculateDirectoryEntryOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private int get16Bits(int n) {
        if (n < 0 || n >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this.motorollaByteOrder) {
            return this._data[n] << 8 & 0xFF00 | this._data[n + 1] & 0xFF;
        }
        return this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    private int get32Bits(int n) {
        if (n < 0 || n >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this.motorollaByteOrder) {
            return this._data[n] << 24 & 0xFF000000 | this._data[n + 1] << 16 & 0xFF0000 | this._data[n + 2] << 8 & 0xFF00 | this._data[n + 3] & 0xFF;
        }
        return this._data[n + 3] << 24 & 0xFF000000 | this._data[n + 2] << 16 & 0xFF0000 | this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

