/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters;

import java.util.Iterator;
import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.opcode.JVMInstr;

public class Op02RedundantStoreRewriter {
    private static final Op02RedundantStoreRewriter INSTANCE = new Op02RedundantStoreRewriter();

    private Op02RedundantStoreRewriter() {
    }

    private void rewriteInstrs(List<Op02WithProcessedDataAndRefs> instrs, int maxLocals) {
        List<Op02WithProcessedDataAndRefs> sources;
        int[] laststore = new int[maxLocals];
        int[] lastload = new int[maxLocals];
        int[] loadsSinceStore = new int[maxLocals];
        int lastCutOff = 0;
        int nopCount = 0;
        int maxm1 = instrs.size() - 1;
        for (int x = 0; x < maxm1; ++x) {
            Op02WithProcessedDataAndRefs instr = instrs.get(x);
            List<Op02WithProcessedDataAndRefs> targets = instr.getTargets();
            sources = instr.getSources();
            if (sources.size() != 1 || targets.size() != 1 || targets.get(0) != instrs.get(x + 1) || !instr.getContainedInTheseBlocks().isEmpty()) {
                lastCutOff = x;
                continue;
            }
            JVMInstr jvmInstr = instr.getInstr();
            Pair<JavaTypeInstance, Integer> stored = instr.getStorageType();
            if (stored != null) {
                if (jvmInstr == JVMInstr.IINC || jvmInstr == JVMInstr.IINC_WIDE) {
                    lastCutOff = x;
                    continue;
                }
                int storeidx = stored.getSecond();
                if (laststore[storeidx] > lastCutOff && lastload[storeidx] > lastCutOff && loadsSinceStore[storeidx] == 1) {
                    int lastloadidx = lastload[storeidx];
                    int laststoreidx = laststore[storeidx];
                    if (lastloadidx == laststoreidx + 1) {
                        instrs.get(laststoreidx).nop();
                        instrs.get(lastloadidx).nop();
                        nopCount += 2;
                    } else if (lastloadidx == laststoreidx + 2) {
                        instrs.get(laststoreidx).nop();
                        instrs.get(lastloadidx).swap();
                        ++nopCount;
                    }
                }
                laststore[storeidx] = x;
                loadsSinceStore[storeidx] = 0;
                continue;
            }
            Pair<JavaTypeInstance, Integer> fetched = instr.getRetrieveType();
            if (fetched == null) continue;
            int fetchidx = fetched.getSecond();
            if (laststore[fetchidx] <= lastCutOff) {
                loadsSinceStore[fetchidx] = 0;
            }
            int n = fetchidx;
            loadsSinceStore[n] = loadsSinceStore[n] + 1;
            lastload[fetchidx] = x;
        }
        if (nopCount > 0) {
            Iterator<Op02WithProcessedDataAndRefs> iterator = instrs.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                List<Op02WithProcessedDataAndRefs> targets;
                Op02WithProcessedDataAndRefs instr = iterator.next();
                if (instr.getInstr() != JVMInstr.NOP || (targets = instr.getTargets()).size() != 1) continue;
                Op02WithProcessedDataAndRefs target = targets.get(0);
                targets.clear();
                target.removeSource(instr);
                sources = instr.getSources();
                for (Op02WithProcessedDataAndRefs source : sources) {
                    source.replaceTarget(instr, target);
                    target.addSource(source);
                }
                iterator.remove();
            }
        }
    }

    public static void rewrite(List<Op02WithProcessedDataAndRefs> instrs, int maxLocals) {
        INSTANCE.rewriteInstrs(instrs, maxLocals);
    }
}

