#!/usr/bin/python

# Bisect pkgsrc bug PR 54712

from bracket import *

# Extract and bootstrap pkgsrc

def pkgsrc_bootstrap_func(ts):
    get_build_dir(ts)
    mkdir_p(test_dir(ts)) # for log
    log = os.path.join(test_dir(ts), 'pkg_bootstrap.log')
    log_fd = os.open(log, os.O_WRONLY | os.O_CREAT)
    pkgsrcdir = os.path.join(build_dir(ts), 'pkgsrc')
    prefix = test_dir(ts)
    use_repository_for(ts)
    checkout(ts)
    mkdir_p(results_dir(ts))
    runv(['./bootstrap', '--unprivileged', '--prefix', prefix],
         cwd = os.path.join(pkgsrcdir, 'bootstrap'),
         stdout = log_fd, stderr = log_fd)
    os.close(log_fd)
    append_to_file(os.path.join(prefix, 'etc/mk.conf'),
        'MAKE_JOBS=%d\nDISTDIR=/usr/pkgsrc/distfiles\n' % n_make_jobs(), mode = 't')
    return True

pkgsrc_bootstrap_op = \
    TestOp(pkgsrc_bootstrap_func, [], name = 'pkgsrc_bootstrap')
    
# Build and install the graphics/py-matplotlib package

def matplotlib_install_func(ts):
    log = os.path.join(test_dir(ts), 'matplotlib_install.log')
    log_fd = os.open(log, os.O_WRONLY | os.O_CREAT)
    pkgsrcdir = os.path.join(build_dir(ts), 'pkgsrc')
    prefix = test_dir(ts)
    status = runv([os.path.join(prefix, 'bin/bmake'), 'install'],
         cwd = os.path.join(pkgsrcdir, 'graphics/py-matplotlib'),
         stdout = log_fd, stderr = log_fd)
    os.close(log_fd)
    return status == 0

matplotlib_install_op = \
    TestOp(matplotlib_install_func, [pkgsrc_bootstrap_op],
           name = 'matplotlib_build')

# Test importing matplotlib.dates

def matplotlib_dates_import_func(ts):
    prefix = test_dir(ts)
    status = runv([os.path.join(prefix, 'bin/python3.7'),
          '-c', 'import matplotlib.dates'])
    return status == 0

matplotlib_dates_import_op = \
    TestOp(matplotlib_dates_import_func, [matplotlib_install_op],
           name = 'matplotlib_dates_import')

# Bisect

find_failure(rcs2ts('2019.11.06.13.53.13'),
             ts_adjust(rcs2ts('2019.11.10.00.00.00')),
             matplotlib_dates_import_op,
             confirm = True)
