/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion;

import net.sourceforge.squirrel_sql.fw.completion.CamelCaseMatcher;

public abstract class CompletionInfo
implements Comparable<CompletionInfo> {
    private String _upperCaseCompletionString;
    private String _completionString;

    public abstract String getCompareString();

    public String getCompletionString() {
        return this.getCompareString();
    }

    @Override
    public int compareTo(CompletionInfo other) {
        this.initCache();
        other.initCache();
        return this._upperCaseCompletionString.compareTo(other._upperCaseCompletionString);
    }

    public boolean matchesCompletionStringStart(String testString, boolean matchCamelCase) {
        this.initCache();
        return this._upperCaseCompletionString.startsWith(testString.toUpperCase()) || matchCamelCase && this.matchesCamelCase(testString);
    }

    private boolean matchesCamelCase(String testString) {
        return CamelCaseMatcher.matchesCamelCase(testString, this._completionString);
    }

    public boolean matchesCompletionString(String testString) {
        this.initCache();
        return this._upperCaseCompletionString.equals(testString.toUpperCase());
    }

    private void initCache() {
        if (null == this._upperCaseCompletionString) {
            this._completionString = this.getCompareString();
            this._upperCaseCompletionString = this._completionString.toUpperCase();
        }
    }

    public boolean hasColumns() {
        return false;
    }

    public String toString() {
        return this.getCompletionString();
    }
}

