/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.SkinRootPaneUI;
import com.l2fprod.util.OS;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public interface Window {
    public static final String IS_SHADED_PROPERTY = "shaded";
    public static final String SHADE_BOUNDS_PROPERTY = "windowshadeBounds";

    public Container getContainer();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public boolean isSelected();

    public void setSelected(boolean var1) throws PropertyVetoException;

    public boolean isIcon();

    public void setIcon(boolean var1) throws PropertyVetoException;

    public boolean isMaximum();

    public void setMaximum(boolean var1) throws PropertyVetoException;

    public boolean isShaded();

    public void setShaded(boolean var1);

    public boolean isMaximizable();

    public boolean isIconifiable();

    public boolean isClosable();

    public void setClosed(boolean var1) throws PropertyVetoException;

    public boolean isResizable();

    public String getTitle();

    public Icon getFrameIcon();

    public void dispatchEvent(AWTEvent var1);

    static class 1 {
        static /* synthetic */ Class class$java$awt$Frame;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class FrameWindow
    implements Window {
        private JFrame frame = null;
        private JDialog dialog = null;
        private Rectangle oldBounds = null;
        private boolean shaded = false;
        private boolean selected = true;
        private Image cachedFrameImage = null;
        private Icon cachedFrameIcon = null;

        public void setFrame(java.awt.Window argWin) {
            if (argWin instanceof JDialog) {
                this.dialog = (JDialog)argWin;
            } else if (argWin instanceof JFrame) {
                this.frame = (JFrame)argWin;
            } else {
                this.frame = null;
                this.dialog = null;
            }
            this.oldBounds = null;
            this.shaded = false;
        }

        public void setSelected(boolean b) {
            if (b) {
                if (this.frame != null) {
                    this.frame.repaint();
                } else if (this.dialog != null) {
                    this.dialog.repaint();
                }
            }
            this.selected = b;
        }

        public java.awt.Window getMainFrame() {
            java.awt.Window toreturn = null;
            if (this.frame != null) {
                toreturn = this.frame;
            } else if (this.dialog != null) {
                toreturn = this.dialog;
            }
            return toreturn;
        }

        public void setIcon(boolean b) {
            if (this.frame != null) {
                this.frame.setState(1);
            } else if (this.dialog != null) {
                // empty if block
            }
        }

        public void setMaximum(boolean b) {
            if (this.frame != null) {
                if (b && SkinRootPaneUI.getExtendedState(this.frame) != SkinRootPaneUI.Frame_MAXIMIZED_BOTH) {
                    SkinRootPaneUI.setExtendedState(this.frame, SkinRootPaneUI.Frame_MAXIMIZED_BOTH);
                } else if (!b) {
                    SkinRootPaneUI.setExtendedState(this.frame, 0);
                }
                this.dispatchEvent(new ComponentEvent(this.frame, 101));
            } else if (this.dialog != null) {
                // empty if block
            }
        }

        public void setShaded(boolean b) {
            java.awt.Window window;
            java.awt.Window window2 = window = this.frame == null ? this.dialog : this.frame;
            if (window == null || b == this.shaded) {
                return;
            }
            if (b) {
                Rectangle bounds = window.getBounds();
                this.oldBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                window.setBounds(this.oldBounds.x, this.oldBounds.y, this.oldBounds.width, window.getMinimumSize().height - 2);
            } else {
                Point location = window.getLocation();
                window.setBounds(location.x, location.y, this.oldBounds.width, this.oldBounds.height);
                this.oldBounds = null;
            }
            this.shaded = b;
        }

        public void setClosed(boolean b) {
            if (this.frame != null) {
                this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
            } else if (this.dialog != null) {
                this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
            }
        }

        public Container getContainer() {
            if (this.frame != null) {
                return this.frame.getContentPane();
            }
            if (this.dialog != null) {
                return this.dialog.getContentPane();
            }
            return null;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isIcon() {
            boolean toreturn = false;
            if (this.frame != null) {
                toreturn = this.frame.getState() == 1;
            }
            return toreturn;
        }

        public boolean isMaximum() {
            boolean toreturn = false;
            if (this.frame != null) {
                toreturn = SkinRootPaneUI.getExtendedState(this.frame) == SkinRootPaneUI.Frame_MAXIMIZED_BOTH;
            }
            return toreturn;
        }

        public boolean isMaximizable() {
            boolean toreturn = false;
            if (this.frame != null) {
                toreturn = this.frame.isResizable() && !this.isShaded();
            }
            return toreturn;
        }

        public boolean isShaded() {
            return this.shaded;
        }

        public boolean isIconifiable() {
            boolean toreturn = false;
            if (this.frame != null) {
                toreturn = this.frame.isResizable();
            }
            return toreturn;
        }

        public boolean isClosable() {
            return true;
        }

        public boolean isResizable() {
            boolean toreturn = false;
            if (this.frame != null) {
                toreturn = this.frame.isResizable();
            } else if (this.dialog != null) {
                return this.dialog.isResizable() && !this.isShaded();
            }
            return toreturn;
        }

        public String getTitle() {
            String title = "";
            if (this.frame != null) {
                title = this.frame.getTitle();
            } else if (this.dialog != null) {
                title = this.dialog.getTitle();
            }
            return title;
        }

        public Icon getFrameIcon() {
            Frame parent;
            ImageIcon toreturn = null;
            Image frameImage = null;
            if (this.frame != null) {
                frameImage = this.frame.getIconImage();
            } else if (this.dialog != null && (parent = (Frame)SwingUtilities.getAncestorOfClass(1.class$java$awt$Frame == null ? (1.class$java$awt$Frame = 1.class$("java.awt.Frame")) : 1.class$java$awt$Frame, this.dialog)) != null) {
                frameImage = parent.getIconImage();
            }
            if (frameImage != null) {
                if (frameImage == this.cachedFrameImage) {
                    return this.cachedFrameIcon;
                }
                toreturn = new ImageIcon(frameImage);
                this.cachedFrameImage = frameImage;
                this.cachedFrameIcon = toreturn;
            }
            return toreturn;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.frame != null) {
                this.frame.addPropertyChangeListener(listener);
            } else if (this.dialog != null) {
                this.dialog.addPropertyChangeListener(listener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.frame != null) {
                this.frame.removePropertyChangeListener(listener);
            } else if (this.dialog != null) {
                this.dialog.removePropertyChangeListener(listener);
            }
        }

        public void dispatchEvent(AWTEvent event) {
            if (this.frame != null) {
                this.frame.dispatchEvent(event);
            } else if (this.dialog != null) {
                this.dialog.dispatchEvent(event);
            }
        }

        public String toString() {
            return super.toString() + "[title=" + this.getTitle() + "]";
        }
    }

    public static class InternalFrameWindow
    implements Window {
        JInternalFrame frame;
        boolean shaded = false;

        public InternalFrameWindow(JInternalFrame frame) {
            this.frame = frame;
        }

        public void setSelected(boolean b) throws PropertyVetoException {
            this.frame.setSelected(b);
        }

        public void setIcon(boolean b) throws PropertyVetoException {
            this.frame.setIcon(b);
        }

        public void setMaximum(boolean b) throws PropertyVetoException {
            this.frame.setMaximum(b);
        }

        public void setShaded(boolean b) {
            if (b == this.shaded) {
                return;
            }
            if (b) {
                Rectangle bounds = this.frame.getBounds();
                Rectangle p = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                this.frame.putClientProperty(Window.SHADE_BOUNDS_PROPERTY, p);
                this.frame.setBounds(p.x, p.y, p.width, this.frame.getMinimumSize().height - 2);
            } else {
                Point location = this.frame.getLocation();
                Rectangle p = (Rectangle)this.frame.getClientProperty(Window.SHADE_BOUNDS_PROPERTY);
                this.frame.getDesktopPane().getDesktopManager().setBoundsForFrame(this.frame, location.x, location.y, p.width, p.height);
                this.frame.putClientProperty(Window.SHADE_BOUNDS_PROPERTY, null);
            }
            this.shaded = b;
        }

        public void setClosed(boolean b) throws PropertyVetoException {
            if (OS.isOneDotThreeOrMore()) {
                try {
                    Class.forName("javax.swing.JInternalFrame").getMethod("doDefaultCloseAction", new Class[0]).invoke((Object)this.frame, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (!b) {
                    this.frame.setClosed(b);
                    return;
                }
                this.doDefaultCloseAction();
            }
        }

        public Container getContainer() {
            return this.frame;
        }

        public boolean isSelected() {
            return this.frame.isSelected();
        }

        public boolean isIcon() {
            return this.frame.isIcon();
        }

        public boolean isMaximum() {
            return this.frame.isMaximum();
        }

        public boolean isShaded() {
            return this.shaded;
        }

        public boolean isMaximizable() {
            return this.frame.isMaximizable();
        }

        public boolean isIconifiable() {
            return this.frame.isIconifiable();
        }

        public boolean isClosable() {
            return this.frame.isClosable();
        }

        public boolean isResizable() {
            return !this.isShaded() && this.frame.isResizable();
        }

        public String getTitle() {
            return this.frame.getTitle();
        }

        public Icon getFrameIcon() {
            return this.frame.getFrameIcon();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.frame.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.frame.removePropertyChangeListener(listener);
        }

        public void dispatchEvent(AWTEvent event) {
            this.frame.dispatchEvent(event);
        }

        private void doDefaultCloseAction() {
            int defaultCloseOperation = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            switch (defaultCloseOperation) {
                case 1: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.setVisible(false);
                        if (!this.frame.isSelected()) break;
                        this.frame.setSelected(false);
                    }
                    catch (PropertyVetoException pve) {}
                    break;
                }
                case 2: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.dispose();
                    }
                    catch (PropertyVetoException pve) {}
                    break;
                }
                case 3: {
                    System.exit(0);
                    break;
                }
                case 0: {
                    try {
                        this.frame.setClosed(true);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            this.frame.setDefaultCloseOperation(defaultCloseOperation);
        }

        public String toString() {
            return super.toString() + "[title=" + this.getTitle() + "]";
        }
    }
}

