/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as n,customElement as m,state as y,query as b}from"lit/decorators.js";import{LitElement as P,nothing as u,html as d}from"lit";import g from"@typo3/core/ajax/ajax-request.js";import{AjaxResponse as I}from"@typo3/core/ajax/ajax-response.js";import E from"@typo3/backend/viewport.js";import{topLevelModuleImport as T}from"@typo3/backend/utility/top-level-module-import.js";import M,{Sizes as $}from"@typo3/backend/modal.js";import{SeverityEnum as v}from"@typo3/backend/enum/severity.js";var s=function(r,e,t,o){var l=arguments.length,a=l<3?e:o===null?o=Object.getOwnPropertyDescriptor(e,t):o,c;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")a=Reflect.decorate(r,e,t,o);else for(var h=r.length-1;h>=0;h--)(c=r[h])&&(a=(l<3?c(a):l>3?c(e,t,a):c(e,t))||a);return l>3&&a&&Object.defineProperty(e,t,a),a};class i extends P{}s([n({type:String})],i.prototype,"verifyActionUri",void 0),s([n({type:String})],i.prototype,"cancelUri",void 0),s([n({type:Boolean})],i.prototype,"isAjax",void 0),s([n({type:Boolean,attribute:"has-fatal-error"})],i.prototype,"hasFatalError",void 0),s([n({type:Boolean,attribute:"allow-install-tool-password"})],i.prototype,"allowInstallToolPassword",void 0),s([n({type:Object})],i.prototype,"labels",void 0);const w=async r=>{window.location!==window.parent.location&&T("@typo3/backend/security/element/sudo-mode.js");const t=top.document.createElement("typo3-backend-security-sudo-mode");return Object.assign(t,r),top.document.body.append(t),new Promise((o,l)=>{t.addEventListener("typo3:sudo-mode:verified",()=>o()),t.addEventListener("typo3:sudo-mode:finished",()=>l())})};let f=class extends i{render(){return u}async firstUpdated(){if(window.location!==window.parent.location){try{await w(this.getPropertyValues())}catch{history.go(-1)}return}M.advanced({title:this.hasFatalError?this.labels.verificationFailed:this.labels.verifyWithUserPassword,severity:this.hasFatalError?v.error:v.notice,size:$.small,additionalCssClasses:["modal-sudo-mode-verification"],buttons:[this.hasFatalError?{text:this.labels.cancel,btnClass:"btn-default",trigger:()=>{top.location.href=this.cancelUri}}:{text:this.labels.verify,name:"verify",form:"verify-sudo-mode",btnClass:"btn-primary"}],content:d`<typo3-backend-security-sudo-mode-form .labels=${this.labels} .verifyActionUri=${this.verifyActionUri} .cancelUri=${this.cancelUri} .isAjax=${this.isAjax} .hasFatalError=${this.hasFatalError} .allowInstallToolPassword=${this.allowInstallToolPassword} @typo3:sudo-mode:verified=${()=>this.dispatchEvent(new Event("typo3:sudo-mode:verified"))}></typo3-backend-security-sudo-mode-form>`}).addEventListener("typo3-modal-hidden",()=>{this.dispatchEvent(new Event("typo3:sudo-mode:finished")),this.remove()})}getPropertyValues(){const e={},t=this.constructor;for(const o of t.elementProperties.keys())e[o]=this[o];return e}};f=s([m("typo3-backend-security-sudo-mode")],f);let p=class extends i{constructor(){super(...arguments),this.useInstallToolPassword=!1,this.errorMessage=null}createRenderRoot(){return this}render(){return this.hasFatalError?d`<div><div class="alert alert-danger">${this.labels.verificationExpired}</div></div>`:d`<div>${this.errorMessage?d`<div class="alert alert-danger" id=invalid-password>${this.labels[this.errorMessage]||this.errorMessage}</div>`:u}<form method=post class=form id=verify-sudo-mode spellcheck=false @submit=${e=>this.verifyPassword(e)}>${this.useInstallToolPassword?u:d`<input hidden aria-hidden=true type=text autocomplete=username value=${TYPO3.configuration.username}>`}<div class=form-group><label class=form-label for=password>${this.labels.password}</label> <input required class=form-control id=password type=password name=password autofocus autocomplete=${this.useInstallToolPassword?"section-install current-password":"current-password"}></div></form>${this.allowInstallToolPassword?d`<div class=text-end><a href=# @click=${e=>this.toggleUseInstallToolPassword(e)}> ${this.useInstallToolPassword?this.labels.userPasswordMode:this.labels.installToolPasswordMode} </a></div>`:u}</div>`}updated(e){e.has("useInstallToolPassword")&&(this.closest("typo3-backend-modal").modalTitle=this.getModalTitle())}getModalTitle(){return this.hasFatalError?this.labels.verificationFailed:this.useInstallToolPassword?this.labels.verifyWithInstallToolPassword:this.labels.verifyWithUserPassword}async verifyPassword(e){e.preventDefault(),this.errorMessage=null;try{const o=await(await new g(this.verifyActionUri).post({password:this.passwordElement.value,useInstallToolPassword:this.useInstallToolPassword?1:0})).resolve("application/json");this.dispatchEvent(new Event("typo3:sudo-mode:verified")),this.closest("typo3-backend-modal").hideModal(),!this.isAjax&&o.redirect&&E.ContentContainer.setUrl(o.redirect.uri).catch(()=>{self===top&&setTimeout(()=>window.location.href=o.redirect.uri,0)})}catch(t){if(t instanceof I){const o=await t.resolve("application/json");this.errorMessage=o.message}else throw t}}toggleUseInstallToolPassword(e){e.preventDefault(),this.useInstallToolPassword=!this.useInstallToolPassword}};s([y()],p.prototype,"useInstallToolPassword",void 0),s([y()],p.prototype,"errorMessage",void 0),s([b("#password")],p.prototype,"passwordElement",void 0),p=s([m("typo3-backend-security-sudo-mode-form")],p);export{f as SudoMode,p as SudoModeForm,w as initiateSudoModeModal};
