<?php

class DetailPage extends CMSWebPageBase {

	var $id;
	var $pageId;

	function doPost(){
		//更新処理
		
    	if(soy2_check_token()){

			try{
				$result = $this->run("Block.UpdateAction",array("id"=>$this->id));
				
				$block = $result->getAttribute("Block");
				
				if(!$result->success()){
					//TODO ブロックの更新失敗エラー処理
				}
				
				if(isset($_POST["after_submit"]) && $_POST["after_submit"] == "reload"){
					$this->jump("Block.Detail.".$this->id);
					exit;
				}

				header("Content-Type: text/html; charset=utf-8;");
				echo '<html><head>';
				echo '<meta http-equiv="content-type" content="text/html; charset=UTF-8" />';
				echo '<script type="text/javascript" src="'.SOY2PageController::createRelativeLink("js/prototype.js").'"></script>';
				echo "<script type=\"text/javascript\">";
				if($block){
					echo 'window.parent.document.getElementById("block_info_" + '.htmlspecialchars($this->id, ENT_QUOTES, "UTF-8").').innerHTML = "'.htmlspecialchars($block->getObjectInstance()->getInfoPage(), ENT_QUOTES, "UTF-8").'";';
					echo 'window.parent.document.main_form.soy2_token.value="'.soy2_get_token().'";';
					echo '$A(window.parent.document.getElementsByClassName("block_action_link")).each(function(ele){ ele.href=ele.href.replace(/soy2_token=[0-9A-z]*/,"soy2_token='.soy2_get_token().'");});';
				}
				echo "window.parent.common_close_layer(window.parent);";
				echo "</script>";
				echo "</head><body></body></html>";
				
				exit;

			}catch(Exception $e){
				
			}
    	}

		$this->jump("Block.Detail.".$this->id);

	}

    function DetailPage($args) {
    	$id = $args[0];
    	$this->id = $id;
    	$block = $this->getBlock($id);
    	$this->pageId = $block->getPageId();
  
    	WebPage::WebPage();
    	
    	$component = $block->getBlockComponent();
    	//Block ID will be required in some cases.
    	if(method_exists($component,"setBlockId")){
    		$component->setBlockId($id);
    	}else{
    		$component->blockId = $id;
    	}
    	$this->add("block_form",$component->getFormPage());
    	
    	$this->createAdd("block_id","HTMLLabel",array(
    		"text" => "ID: ".$block->getSoyId()
    	));
    	$this->createAdd("block_name","HTMLLabel",array(
    		"text" => $component->getComponentName()
    	));
    	$this->createAdd("block_description","HTMLLabel",array(
    		"html" => $component->getComponentDescription()
    	));
    }
    
    /**
     * Get Block information
     * @param $id Block ID
     * @return Block
     */
    function getBlock($id){
    	$result = $this->run("Block.DetailAction",array("id"=>$id));
    	return $result->getAttribute("Block");
    }
}
?>