/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.plain;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.ExpandTabsReader;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.IteratorReader;
import org.opensolaris.opengrok.analysis.JFlexXref;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.TextAnalyzer;
import org.opensolaris.opengrok.analysis.plain.PlainXref;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;

public class PlainAnalyzer
extends TextAnalyzer {
    private JFlexXref xref;
    private Definitions defs;

    protected PlainAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    protected JFlexXref newXref(Reader reader) {
        return new PlainXref(reader);
    }

    @Override
    protected Reader getReader(InputStream stream) throws IOException {
        return ExpandTabsReader.wrap(super.getReader(stream), this.project);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        doc.add((IndexableField)new TextField("full", this.getReader(src.getStream())));
        String fullpath = doc.get("fullpath");
        if (fullpath != null && this.ctags != null) {
            this.defs = this.ctags.doCtags(fullpath + "\n");
            if (this.defs != null && this.defs.numberOfSymbols() > 0) {
                doc.add((IndexableField)new TextField("defs", (Reader)new IteratorReader(this.defs.getSymbols())));
                doc.add((IndexableField)new TextField("refs", this.getReader(src.getStream())));
                byte[] tags = this.defs.serialize();
                doc.add((IndexableField)new StoredField("tags", tags));
            }
        }
        if (xrefOut != null) {
            try (Reader in = this.getReader(src.getStream());){
                this.writeXref(in, xrefOut);
            }
        }
    }

    private void writeXref(Reader in, Writer out) throws IOException {
        if (this.xref == null) {
            this.xref = this.newXref(in);
        } else {
            this.xref.reInit(in);
        }
        this.xref.setDefs(this.defs);
        this.xref.project = this.project;
        this.xref.write(out);
    }

    static void writeXref(Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        PlainXref xref = new PlainXref(in);
        xref.annotation = annotation;
        xref.project = project;
        xref.setDefs(defs);
        xref.write(out);
    }
}

