[%%shared
(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)
(* Popup button demo *)

open Eliom_content.Html]

[%%shared open Eliom_content.Html.F]
[%%client open Js_of_ocaml_lwt]

(* Service for this demo, defined in the server-side app *)
let%server service =
  Eliom_service.create
    ~path:(Eliom_service.Path ["demo-popup"])
    ~meth:(Eliom_service.Get Eliom_parameter.unit) ()

(* Make service available on the client *)
let%client service = ~%service
(* Name for demo menu. This value is defined both server and client-side. *)
let%shared name () = [%i18n Demo.S.popup]
(* Class for the page containing this demo (for internal use) *)
let%shared page_class = "os-page-demo-popup"

(* The function generating the page can be called either from the server or
   the client (shared section). *)
let%shared page () =
  let button =
    (* As we are using ~%button (in a client section below)
       to refer to this precise occurrence of the button in the page,
       button must be a D node
       (from module Eliom_content.Html.D,
       which will add an unique identifier in its attributes),
       and not a functional node (Eliom_content.Html.F). *)
    D.Form.input
      ~a:[a_class ["button"]]
      ~input_type:`Submit ~value:[%i18n Demo.S.popup_click] Form.string
  in
  (* Every time this page is generated,
     we want to execute the following piece of client-side code.
     Lwt_js_events.clicks means "For each click on ... do ...".
     It creates an Lwt thread that never returns.
     We run it asynchronously using Lwt.async.
     Lwt_js_events.clicks is expecting a DOM node
     (i.e. an actual part of the current page).
     To_dom.of_element will return the DOM node corresponding to the
     OCaml value ~%button.
     ~%button refers to the value button, defined outside [%client ] section
     (possibly on server or client).
  *)
  ignore
    [%client
      (* This client section will be executed after the page is
                displayed by the browser. *)
      (Lwt.async (fun () ->
           (* Lwt_js_events.clicks returns a Lwt thread, which never terminates.
            We run it asynchronously. *)
           Lwt_js_events.clicks (To_dom.of_element ~%button) (fun _ _ ->
               let%lwt _ =
                 Ot_popup.popup ~close_button:[Os_icons.F.close ()] (fun _ ->
                     Lwt.return @@ p [%i18n Demo.popup_message])
               in
               Lwt.return_unit))
        : unit)];
  (* Page elements, using module Eliom_content.Html.F
     (as we don't want to add a unique identifier).
     See internationalization demo for i18n syntax.
  *)
  Lwt.return [h1 [%i18n Demo.popup]; p [%i18n Demo.popup_content]; p [button]]
