/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11BssMembershipSelector;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;

public abstract class Dot11AbstractSupportedRatesElement
extends Dot11InformationElement {
    private static final long serialVersionUID = -1751480012950433980L;
    private final List<Rate> rates;
    private final List<BssMembershipSelector> bssMembershipSelectors;
    private final List<Datum> ratesAndBssMembershipSelectors;

    protected Dot11AbstractSupportedRatesElement(byte[] rawData, int offset, int length, Dot11InformationElementId id) throws IllegalRawDataException {
        super(rawData, offset, length, id);
        this.rates = new ArrayList<Rate>();
        this.bssMembershipSelectors = new ArrayList<BssMembershipSelector>();
        this.ratesAndBssMembershipSelectors = new ArrayList<Datum>();
        int infoLen = this.getLengthAsInt();
        for (int i = 0; i < infoLen; ++i) {
            byte next = rawData[offset + 2 + i];
            boolean basic = (next & 0x80) != 0;
            byte val = (byte)(next & 0x7F);
            if (Dot11BssMembershipSelector.isRegistered(val)) {
                BssMembershipSelector sel = new BssMembershipSelector(basic, Dot11BssMembershipSelector.getInstance(val));
                this.bssMembershipSelectors.add(sel);
                this.ratesAndBssMembershipSelectors.add(sel);
                continue;
            }
            Rate rate = new Rate(basic, val);
            this.rates.add(rate);
            this.ratesAndBssMembershipSelectors.add(rate);
        }
    }

    protected Dot11AbstractSupportedRatesElement(Builder builder2) {
        super(builder2);
        if (builder2.ratesAndBssMembershipSelectors.size() > 255) {
            throw new IllegalArgumentException("Too long ratesAndBssMembershipSelectors: " + builder2.ratesAndBssMembershipSelectors);
        }
        this.rates = new ArrayList<Rate>();
        this.bssMembershipSelectors = new ArrayList<BssMembershipSelector>();
        for (Datum obj : builder2.ratesAndBssMembershipSelectors) {
            if (obj instanceof Rate) {
                this.rates.add((Rate)obj);
                continue;
            }
            if (obj instanceof BssMembershipSelector) {
                this.bssMembershipSelectors.add((BssMembershipSelector)obj);
                continue;
            }
            throw new IllegalArgumentException("An illegal object in builder.ratesAndBssMembershipSelectors: " + obj);
        }
        this.ratesAndBssMembershipSelectors = new ArrayList<Datum>(builder2.ratesAndBssMembershipSelectors);
    }

    public List<Rate> getRates() {
        return new ArrayList<Rate>(this.rates);
    }

    public List<BssMembershipSelector> getBssMembershipSelectors() {
        return new ArrayList<BssMembershipSelector>(this.bssMembershipSelectors);
    }

    @Override
    public int length() {
        return 2 + this.ratesAndBssMembershipSelectors.size();
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        int i = 2;
        for (Datum datum : this.ratesAndBssMembershipSelectors) {
            rawData[i] = datum.getRawData();
            ++i;
        }
        return rawData;
    }

    public abstract Builder getBuilder();

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.ratesAndBssMembershipSelectors.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11AbstractSupportedRatesElement other = (Dot11AbstractSupportedRatesElement)obj;
        return this.ratesAndBssMembershipSelectors.equals(other.ratesAndBssMembershipSelectors);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append(this.getElementName()).append(":").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        for (Datum datum : this.ratesAndBssMembershipSelectors) {
            sb.append(indent).append("  ").append(datum).append(ls);
        }
        return sb.toString();
    }

    protected abstract String getElementName();

    public static abstract class Builder
    extends Dot11InformationElement.Builder {
        private List<Datum> ratesAndBssMembershipSelectors;

        public Builder() {
        }

        protected Builder(Dot11AbstractSupportedRatesElement elem) {
            super(elem);
            this.ratesAndBssMembershipSelectors = elem.ratesAndBssMembershipSelectors;
        }

        public Builder ratesAndBssMembershipSelectors(List<Datum> ratesAndBssMembershipSelectors) {
            this.ratesAndBssMembershipSelectors = ratesAndBssMembershipSelectors;
            return this;
        }

        protected void preBuild() {
            if (this.ratesAndBssMembershipSelectors == null) {
                throw new NullPointerException("ratesAndBssMembershipSelectors is null.");
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)this.ratesAndBssMembershipSelectors.size());
            }
        }
    }

    public static final class BssMembershipSelector
    implements Datum {
        private static final long serialVersionUID = 5749787247631286263L;
        private final boolean basic;
        private final Dot11BssMembershipSelector selector;

        public BssMembershipSelector(boolean basic, Dot11BssMembershipSelector selector) {
            if (selector == null) {
                throw new NullPointerException("selector is null.");
            }
            this.basic = basic;
            this.selector = selector;
        }

        public boolean isBasic() {
            return this.basic;
        }

        public Dot11BssMembershipSelector getSelector() {
            return this.selector;
        }

        @Override
        public byte getRawData() {
            int sel = ((Byte)this.selector.value()).byteValue();
            return (byte)(this.basic ? 0x80 | sel : sel);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50).append("BSS Membership Selector: ").append(this.selector).append(this.basic ? " (basic)" : " (non-basic)");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.basic ? 1231 : 1237);
            result2 = 31 * result2 + this.selector.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BssMembershipSelector other = (BssMembershipSelector)obj;
            if (this.basic != other.basic) {
                return false;
            }
            return this.selector.equals(other.selector);
        }
    }

    public static final class Rate
    implements Datum {
        private static final long serialVersionUID = -3227287901080960330L;
        private final boolean basic;
        private final byte rate;

        public Rate(boolean basic, byte rate) {
            if (rate < 0) {
                throw new IllegalArgumentException("The rate must be between 0 to 127 but is actually: " + rate);
            }
            this.basic = basic;
            this.rate = rate;
        }

        public boolean isBasic() {
            return this.basic;
        }

        public byte getRate() {
            return this.rate;
        }

        public double getRateInMbitPerSec() {
            return (double)this.rate * 0.5;
        }

        @Override
        public byte getRawData() {
            return (byte)(this.basic ? 0x80 | this.rate : this.rate);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50).append("Supported Rate: ").append(this.getRateInMbitPerSec()).append(" Mbit/sec").append(this.basic ? " (basic)" : " (non-basic)");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.basic ? 1231 : 1237);
            result2 = 31 * result2 + this.rate;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rate other = (Rate)obj;
            if (this.basic != other.basic) {
                return false;
            }
            return this.rate == other.rate;
        }
    }

    public static interface Datum
    extends Serializable {
        public byte getRawData();
    }
}

