/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import org.jivesoftware.smack.fsm.StateDescriptor;

public abstract class StateTransitionResult {
    private final String message;

    protected StateTransitionResult(String message) {
        this.message = message;
    }

    public String toString() {
        return this.message;
    }

    public static class TransitionImpossibleBecauseNotImplemented
    extends TransitionImpossibleReason {
        public TransitionImpossibleBecauseNotImplemented(StateDescriptor stateDescriptor) {
            super(stateDescriptor.getFullStateName(false) + " is not implemented (yet)");
        }
    }

    public static class TransitionImpossibleReason
    extends TransitionImpossible {
        public TransitionImpossibleReason(String reason2) {
            super(reason2);
        }
    }

    public static abstract class TransitionImpossible
    extends StateTransitionResult {
        protected TransitionImpossible(String message) {
            super(message);
        }
    }

    public static final class FailureCausedByTimeout
    extends Failure {
        public FailureCausedByTimeout(String failureMessage) {
            super(failureMessage);
        }
    }

    public static final class FailureCausedByException<E extends Exception>
    extends Failure {
        private final E exception;

        public FailureCausedByException(E exception) {
            super(((Throwable)exception).getMessage());
            this.exception = exception;
        }

        public E getException() {
            return this.exception;
        }
    }

    public static class Failure
    extends AttemptResult {
        public Failure(String failureMessage) {
            super(failureMessage);
        }
    }

    public static class Success
    extends AttemptResult {
        public static final Success EMPTY_INSTANCE = new Success();

        private Success() {
            super("");
        }

        public Success(String successMessage) {
            super(successMessage);
        }
    }

    public static abstract class AttemptResult
    extends StateTransitionResult {
        protected AttemptResult(String message) {
            super(message);
        }
    }
}

