/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.datachannel;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.RemotelyOpenedDataChannel;
import org.jitsi.videobridge.datachannel.protocol.DataChannelMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelProtocolMessageParser;
import org.jitsi.videobridge.datachannel.protocol.OpenChannelMessage;

public class DataChannelStack {
    private final Map<Integer, DataChannel> dataChannels = new HashMap<Integer, DataChannel>();
    private final DataChannelDataSender dataChannelDataSender;
    private final Logger logger;
    private DataChannelStackEventListener listener;

    public DataChannelStack(DataChannelDataSender dataChannelDataSender, Logger parentLogger) {
        this.dataChannelDataSender = dataChannelDataSender;
        this.logger = parentLogger.createChildLogger(DataChannelStack.class.getName());
    }

    public void onIncomingDataChannelPacket(ByteBuffer data2, int sid, int ppid) {
        this.logger.debug(() -> "Data channel stack received SCTP message");
        DataChannelMessage message = DataChannelProtocolMessageParser.parse(data2.array(), ppid);
        if (message instanceof OpenChannelMessage) {
            this.logger.info("Received data channel open message");
            OpenChannelMessage openChannelMessage = (OpenChannelMessage)message;
            RemotelyOpenedDataChannel dataChannel = new RemotelyOpenedDataChannel(this.dataChannelDataSender, this.logger, openChannelMessage.channelType, openChannelMessage.priority, openChannelMessage.reliability, sid, openChannelMessage.label);
            this.dataChannels.put(sid, dataChannel);
            this.listener.onDataChannelOpenedRemotely(dataChannel);
        } else {
            DataChannel dataChannel = this.dataChannels.get(sid);
            if (dataChannel == null) {
                this.logger.error("Could not find data channel for sid " + sid);
                return;
            }
            dataChannel.onIncomingMsg(message);
        }
    }

    public void onDataChannelStackEvents(DataChannelStackEventListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataChannel createDataChannel(int channelType, int priority, long reliability, int sid, String label) {
        Map<Integer, DataChannel> map = this.dataChannels;
        synchronized (map) {
            DataChannel dataChannel = new DataChannel(this.dataChannelDataSender, this.logger, channelType, priority, reliability, sid, label);
            this.dataChannels.put(sid, dataChannel);
            return dataChannel;
        }
    }

    public static interface DataChannelDataSender {
        public int send(ByteBuffer var1, int var2, int var3);
    }

    public static interface DataChannelStackEventListener {
        public void onDataChannelOpenedRemotely(DataChannel var1);
    }

    public static interface DataChannelMessageListener {
        public void onDataChannelMessage(DataChannelMessage var1);
    }

    public static interface DataChannelEventListener {
        public void onDataChannelOpened();
    }
}

