/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.colibri2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.colibri2.IqProcessingException;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.sctp.SctpManager;
import org.jitsi.videobridge.util.PayloadTypeUtil;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;
import org.jitsi.videobridge.xmpp.MediaSourceFactory;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.MUCRole;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u000bH\u0002J$\u0010\u001e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001f0\u0017*\u00020\u0011H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020$H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\r*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler;", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "addSsrcAssociation", "", "endpointId", "", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "buildFeedbackSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "handleColibri2Endpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "c2endpoint", "handleColibri2Relay", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Relay;", "c2relay", "handleConferenceModifyIQ", "Lkotlin/Pair;", "Lorg/jivesoftware/smack/packet/IQ;", "", "conferenceModifyIQ", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "parseAssociationType", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "parseSourceDescs", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Lorg/jitsi/nlj/MediaSourceDesc;", "toRtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "Lorg/jitsi/xmpp/extensions/jingle/RTPHdrExtPacketExtension;", "toSsrcAssociation", "Lorg/jitsi/xmpp/extensions/jingle/SourceGroupPacketExtension;", "jitsi-videobridge"})
public final class Colibri2ConferenceHandler {
    @NotNull
    private final Conference conference;
    @NotNull
    private final Logger logger;

    public Colibri2ConferenceHandler(@NotNull Conference conference, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.conference = conference;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final Pair<IQ, Boolean> handleConferenceModifyIQ(@NotNull ConferenceModifyIQ conferenceModifyIQ) {
        Pair<IQ, Boolean> pair;
        Intrinsics.checkNotNullParameter(conferenceModifyIQ, "conferenceModifyIQ");
        try {
            boolean expire;
            ConferenceModifiedIQ.Builder responseBuilder;
            block19: {
                block18: {
                    boolean bl;
                    block17: {
                        boolean bl2;
                        ConferenceModifiedIQ.Builder builder2 = ConferenceModifiedIQ.builder(ConferenceModifiedIQ.Builder.createResponse(conferenceModifyIQ));
                        Intrinsics.checkNotNullExpressionValue(builder2, "builder(ConferenceModifi\u2026onse(conferenceModifyIQ))");
                        responseBuilder = builder2;
                        boolean it = bl2 = conferenceModifyIQ.getExpire();
                        boolean bl3 = false;
                        if (it) {
                            this.logger.info("Received request to expire conference.");
                        }
                        expire = bl2;
                        for (Colibri2Endpoint e : conferenceModifyIQ.getEndpoints()) {
                            Intrinsics.checkNotNullExpressionValue(e, "e");
                            responseBuilder.addEndpoint(this.handleColibri2Endpoint(e));
                        }
                        for (Colibri2Relay r : conferenceModifyIQ.getRelays()) {
                            if (!RelayConfig.config.getEnabled()) {
                                throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Octo is disable in configuration.");
                            }
                            if (!WebsocketServiceConfig.config.getEnabled()) {
                                this.logger.warn("Can not use a colibri2 relay, because colibri web sockets are not enabled. See https://github.com/jitsi/jitsi-videobridge/blob/master/doc/octo.md");
                                throw new UnsupportedOperationException("Colibri websockets need to be enabled to use a colibri2 relay.");
                            }
                            Intrinsics.checkNotNullExpressionValue(r, "r");
                            responseBuilder.addRelay(this.handleColibri2Relay(r));
                        }
                        if (conferenceModifyIQ.getCreate()) break block18;
                        List<Colibri2Endpoint> list = conferenceModifyIQ.getEndpoints();
                        Intrinsics.checkNotNullExpressionValue(list, "conferenceModifyIQ.endpoints");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Colibri2Endpoint it2 = (Colibri2Endpoint)element$iv;
                                boolean bl4 = false;
                                if (!it2.getCreate()) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block19;
                }
                responseBuilder.setSources(this.buildFeedbackSources());
            }
            if (!conferenceModifyIQ.getCreate() && this.conference.getEndpointCount() == 0 && this.conference.getRelayCount() == 0) {
                this.logger.info("All endpoints and relays removed, expiring.");
                expire = true;
            }
            pair = new Pair<ConferenceModifiedIQ, Boolean>(responseBuilder.build(), expire);
        }
        catch (IqProcessingException e) {
            if (StanzaError.Condition.item_not_found == e.getCondition()) {
                this.logger.warn("Error processing conference-modify IQ: " + e);
            } else {
                this.logger.error("Error processing conference-modify IQ: " + e);
            }
            pair = new Pair<IQ, Boolean>(ErrorUtilKt.createError$default((IQ)conferenceModifyIQ, e.getCondition(), e.getMessage(), null, 8, null), false);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Sources buildFeedbackSources() {
        void $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d3;
        SourcePacketExtension $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d2;
        SourcePacketExtension sourcePacketExtension;
        Sources.Builder builder2;
        Sources.Builder $this$buildFeedbackSources_u24lambda_u2d4 = builder2 = Sources.getBuilder();
        boolean bl = false;
        SourcePacketExtension sourcePacketExtension2 = sourcePacketExtension = new SourcePacketExtension();
        MediaSource.Builder builder3 = MediaSource.getBuilder().setType(MediaType.AUDIO).setId("jvb-a0");
        Sources.Builder builder4 = $this$buildFeedbackSources_u24lambda_u2d4;
        boolean bl2 = false;
        $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d2.setSSRC(this.conference.getLocalAudioSsrc());
        $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d2.setName("jvb-a0");
        Unit unit = Unit.INSTANCE;
        builder4.addMediaSource(builder3.addSource(sourcePacketExtension).build());
        $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d2 = sourcePacketExtension = new SourcePacketExtension();
        builder3 = MediaSource.getBuilder().setType(MediaType.VIDEO).setId("jvb-v0");
        builder4 = $this$buildFeedbackSources_u24lambda_u2d4;
        boolean bl3 = false;
        $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d3.setSSRC(this.conference.getLocalVideoSsrc());
        $this$buildFeedbackSources_u24lambda_u2d4_u24lambda_u2d3.setName("jvb-v0");
        unit = Unit.INSTANCE;
        builder4.addMediaSource(builder3.addSource(sourcePacketExtension).build());
        Sources sources = builder2.build();
        Intrinsics.checkNotNullExpressionValue(sources, "getBuilder().apply {\n   \u2026)\n        )\n    }.build()");
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Endpoint handleColibri2Endpoint(Colibri2Endpoint c2endpoint) throws IqProcessingException {
        Unit unit;
        Unit unit2;
        Unit unit3;
        boolean bl;
        boolean bl2;
        Iterator<Media> iterator2;
        Iterator<Media> endpoint;
        Colibri2Endpoint.Builder respBuilder;
        block50: {
            PayloadType it;
            boolean bl3;
            Iterable $this$any$iv;
            boolean $i$f$any;
            block49: {
                Object object;
                Object object2 = Colibri2Endpoint.getBuilder();
                Colibri2Endpoint.Builder $this$handleColibri2Endpoint_u24lambda_u2d5 = object2;
                boolean bl4 = false;
                $this$handleColibri2Endpoint_u24lambda_u2d5.setId(c2endpoint.getId());
                Colibri2Endpoint.Builder builder2 = object2;
                Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder().apply { setId(c2endpoint.id) }");
                respBuilder = builder2;
                if (c2endpoint.getExpire()) {
                    Unit unit4;
                    Endpoint endpoint2 = this.conference.getLocalEndpoint(c2endpoint.getId());
                    if (endpoint2 != null) {
                        endpoint2.expire();
                        unit4 = Unit.INSTANCE;
                    } else {
                        unit4 = null;
                    }
                    respBuilder.setExpire(true);
                    Colibri2Endpoint colibri2Endpoint = respBuilder.build();
                    Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "respBuilder.build()");
                    return colibri2Endpoint;
                }
                if (c2endpoint.getCreate()) {
                    Unit unit5;
                    Unit unit6;
                    if (this.conference.getLocalEndpoint(c2endpoint.getId()) != null) {
                        throw new IqProcessingException(StanzaError.Condition.conflict, "Endpoint with ID " + c2endpoint.getId() + " already exists");
                    }
                    Transport transport = c2endpoint.getTransport();
                    if (transport == null) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create endpoint " + c2endpoint.getId() + " with no <transport>");
                    }
                    Transport transport2 = transport;
                    boolean sourceNames = c2endpoint.hasCapability("source-names");
                    boolean ssrcRewriting = sourceNames && c2endpoint.hasCapability("ssrc-rewriting");
                    Iterator iterator3 = this.conference.createLocalEndpoint(c2endpoint.getId(), transport2.getIceControlling(), sourceNames, ssrcRewriting, c2endpoint.getMucRole() == MUCRole.visitor);
                    Endpoint $this$handleColibri2Endpoint_u24lambda_u2d8 = iterator3;
                    boolean bl5 = false;
                    String string = c2endpoint.getStatsId();
                    if (string != null) {
                        String it2 = string;
                        boolean bl6 = false;
                        $this$handleColibri2Endpoint_u24lambda_u2d8.setStatsId(it2);
                        unit6 = Unit.INSTANCE;
                    } else {
                        unit6 = null;
                    }
                    Sctp sctp = transport2.getSctp();
                    if (sctp != null) {
                        Sctp sctp2 = sctp;
                        boolean bl7 = false;
                        if (!SctpConfig.config.getEnabled()) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP support is not configured");
                        }
                        if (sctp2.getRole() != null && sctp2.getRole() != Sctp.Role.SERVER) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Unsupported SCTP role: " + sctp2.getRole());
                        }
                        if (sctp2.getPort() != null) {
                            Integer n = sctp2.getPort();
                            int n2 = SctpManager.DEFAULT_SCTP_PORT;
                            if (n == null || n != n2) {
                                throw new IqProcessingException(StanzaError.Condition.bad_request, "Specific SCTP port requested, not supported.");
                            }
                        }
                        $this$handleColibri2Endpoint_u24lambda_u2d8.createSctpConnection();
                        unit5 = Unit.INSTANCE;
                    } else {
                        unit5 = null;
                    }
                    object = iterator3;
                } else {
                    object = this.conference.getLocalEndpoint(c2endpoint.getId());
                    if (object == null) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Unknown endpoint " + c2endpoint.getId());
                    }
                }
                object2 = object;
                Intrinsics.checkNotNullExpressionValue(object2, "if (c2endpoint.create) {\u2026\"\n            )\n        }");
                endpoint = object2;
                for (Media media : c2endpoint.getMedia()) {
                    List<PayloadTypePacketExtension> list = media.getPayloadTypes();
                    Intrinsics.checkNotNullExpressionValue(list, "media.payloadTypes");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Unit unit7;
                        PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                        boolean bl8 = false;
                        Intrinsics.checkNotNullExpressionValue(ptExt, "ptExt");
                        MediaType mediaType = media.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)mediaType, "media.type");
                        if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                            PayloadType it3;
                            boolean bl9 = false;
                            ((Endpoint)((Object)endpoint)).addPayloadType(it3);
                            unit7 = Unit.INSTANCE;
                        } else {
                            unit7 = null;
                        }
                        if (unit7 != null) continue;
                        this.logger.warn("Ignoring unrecognized payload type extension: " + ptExt.toXML());
                    }
                    List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
                    Intrinsics.checkNotNullExpressionValue(list2, "media.rtpHdrExts");
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Unit unit8;
                        RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                        boolean bl10 = false;
                        Intrinsics.checkNotNullExpressionValue(rtpHdrExt, "rtpHdrExt");
                        if (this.toRtpExtension(rtpHdrExt) != null) {
                            RtpExtension it4;
                            boolean bl11 = false;
                            ((Endpoint)((Object)endpoint)).addRtpExtension(it4);
                            unit8 = Unit.INSTANCE;
                        } else {
                            unit8 = null;
                        }
                        if (unit8 != null) continue;
                        this.logger.warn("Ignoring unrecognized RTP header extension: " + rtpHdrExt.toXML());
                    }
                }
                object2 = ((Endpoint)((Object)endpoint)).getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
                iterator2 = endpoint;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PayloadType)element$iv;
                        boolean bl12 = false;
                        if (!(it.getMediaType() == MediaType.AUDIO)) continue;
                        bl3 = true;
                        break block49;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
            ((Endpoint)((Object)iterator2)).setAcceptAudio(bl2);
            $this$any$iv = ((Endpoint)((Object)endpoint)).getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
            iterator2 = endpoint;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PayloadType)element$iv;
                    boolean bl13 = false;
                    if (!(it.getMediaType() == MediaType.VIDEO)) continue;
                    bl = true;
                    break block50;
                }
                bl = false;
            }
        }
        bl2 = bl;
        ((Endpoint)((Object)iterator2)).setAcceptVideo(bl2);
        AbstractPacketExtension abstractPacketExtension = c2endpoint.getTransport();
        if (abstractPacketExtension != null && (abstractPacketExtension = abstractPacketExtension.getIceUdpTransport()) != null) {
            AbstractPacketExtension it = abstractPacketExtension;
            boolean bl14 = false;
            ((Endpoint)((Object)endpoint)).setTransportInfo((IceUdpTransportPacketExtension)it);
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = null;
        }
        if (c2endpoint.getCreate()) {
            Transport.Builder builder3 = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder()");
            Transport.Builder transBuilder = builder3;
            transBuilder.setIceUdpExtension(((Endpoint)((Object)endpoint)).describeTransport());
            Transport transport = c2endpoint.getTransport();
            if ((transport != null ? transport.getSctp() : null) != null) {
                transBuilder.setSctp(new Sctp.Builder().setPort(SctpManager.DEFAULT_SCTP_PORT).setRole(Sctp.Role.SERVER).build());
            }
            respBuilder.setTransport(transBuilder.build());
        }
        Sources sources = c2endpoint.getSources();
        if (sources != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv2;
            Object element$iv2;
            Sources sources2 = sources;
            boolean bl15 = false;
            if (((Endpoint)((Object)endpoint)).getVisitor()) {
                List<MediaSource> list = sources2.getMediaSources();
                Intrinsics.checkNotNullExpressionValue(list, "sources.mediaSources");
                if (!((Collection)list).isEmpty()) {
                    throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to set sources for visitor endpoint " + c2endpoint.getId());
                }
            }
            List<MediaSource> list = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list, "sources.mediaSources");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Iterator $this$mapNotNullTo$iv$iv2;
                Object element$iv3;
                MediaSource mediaSource = (MediaSource)element$iv2;
                boolean bl16 = false;
                List<SourcePacketExtension> list3 = mediaSource.getSources();
                Intrinsics.checkNotNullExpressionValue(list3, "mediaSource.sources");
                Iterable $this$forEach$iv3 = list3;
                boolean $i$f$forEach2 = false;
                Object object = $this$forEach$iv3.iterator();
                while (object.hasNext()) {
                    element$iv3 = object.next();
                    SourcePacketExtension it5 = (SourcePacketExtension)element$iv3;
                    boolean bl17 = false;
                    long l = it5.getSSRC();
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "mediaSource.type");
                    ((Endpoint)((Object)endpoint)).addReceiveSsrc(l, mediaType);
                }
                List<SourceGroupPacketExtension> list4 = mediaSource.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue(list4, "mediaSource.ssrcGroups");
                Iterable $this$mapNotNull$iv2 = list4;
                boolean $i$f$mapNotNull = false;
                object = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach3 = false;
                Iterator iterator4 = $this$forEach$iv$iv$iv.iterator();
                while (iterator4.hasNext()) {
                    SsrcAssociation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator4.next();
                    boolean bl18 = false;
                    SourceGroupPacketExtension it6 = (SourceGroupPacketExtension)element$iv$iv;
                    boolean bl19 = false;
                    Intrinsics.checkNotNullExpressionValue(it6, "it");
                    if (this.toSsrcAssociation(it6) == null) continue;
                    boolean bl20 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv;
                $i$f$forEach2 = false;
                $this$mapNotNullTo$iv$iv2 = $this$forEach$iv3.iterator();
                while ($this$mapNotNullTo$iv$iv2.hasNext()) {
                    element$iv3 = $this$mapNotNullTo$iv$iv2.next();
                    SsrcAssociation it7 = (SsrcAssociation)element$iv3;
                    boolean bl21 = false;
                    String string = ((AbstractEndpoint)((Object)endpoint)).getId();
                    Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
                    this.addSsrcAssociation(string, it7);
                }
            }
            List<MediaSource> list5 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list5, "sources.mediaSources");
            Iterable $this$filter$iv = list5;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (MediaSource)element$iv$iv;
                boolean bl22 = false;
                if (!(((MediaSource)it).getType() == MediaType.VIDEO)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach4 = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                MediaSourceDesc it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl23 = false;
                MediaSource it8 = (MediaSource)element$iv$iv;
                boolean bl24 = false;
                if (MediaSourceFactory.createMediaSource((Collection<SourcePacketExtension>)it8.getSources(), (Collection<SourceGroupPacketExtension>)it8.getSsrcGroups(), c2endpoint.getId(), it8.getId()) == null) continue;
                boolean bl25 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newMediaSources = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = newMediaSources;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            MediaSourceDesc[] mediaSourceDescArray = thisCollection$iv.toArray(new MediaSourceDesc[0]);
            if (mediaSourceDescArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ((Endpoint)((Object)endpoint)).setMediaSources(mediaSourceDescArray);
            ArrayList<AudioSourceDesc> audioSources = new ArrayList<AudioSourceDesc>();
            List<MediaSource> list6 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list6, "sources.mediaSources");
            Iterable $this$filter$iv2 = list6;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaSource it9 = (MediaSource)element$iv$iv;
                boolean bl26 = false;
                if (!(it9.getType() == MediaType.AUDIO)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv) {
                MediaSource it10 = (MediaSource)element$iv4;
                boolean bl27 = false;
                List<SourcePacketExtension> list7 = it10.getSources();
                Intrinsics.checkNotNullExpressionValue(list7, "it.sources");
                Iterable $this$forEach$iv4 = list7;
                boolean $i$f$forEach6 = false;
                for (Object element$iv5 : $this$forEach$iv4) {
                    SourcePacketExtension s2 = (SourcePacketExtension)element$iv5;
                    boolean bl28 = false;
                    audioSources.add(new AudioSourceDesc(s2.getSSRC(), c2endpoint.getId(), it10.getId()));
                }
            }
            ((Endpoint)((Object)endpoint)).setAudioSources(audioSources);
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        ForceMute forceMute = c2endpoint.getForceMute();
        if (forceMute != null) {
            ForceMute it = forceMute;
            boolean bl29 = false;
            ((Endpoint)((Object)endpoint)).updateForceMute(it.getAudio(), it.getVideo());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Colibri2Endpoint colibri2Endpoint = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "respBuilder.build()");
        return colibri2Endpoint;
    }

    private final void addSsrcAssociation(String endpointId, SsrcAssociation ssrcAssociation) {
        this.conference.getEncodingsManager().addSsrcAssociation(endpointId, ssrcAssociation.getPrimarySsrc(), ssrcAssociation.getSecondarySsrc(), ssrcAssociation.getType());
    }

    private final SsrcAssociation toSsrcAssociation(SourceGroupPacketExtension $this$toSsrcAssociation) {
        if ($this$toSsrcAssociation.getSources().size() < 2) {
            this.logger.warn("Ignoring source group with <2 sources: " + $this$toSsrcAssociation.toXML());
            return null;
        }
        String string = $this$toSsrcAssociation.getSemantics();
        Intrinsics.checkNotNullExpressionValue(string, "semantics");
        SsrcAssociationType ssrcAssociationType = this.parseAssociationType(string);
        if (ssrcAssociationType == null) {
            return null;
        }
        SsrcAssociationType type2 = ssrcAssociationType;
        if (type2 == SsrcAssociationType.SIM) {
            return null;
        }
        return new LocalSsrcAssociation($this$toSsrcAssociation.getSources().get(0).getSSRC(), $this$toSsrcAssociation.getSources().get(1).getSSRC(), type2);
    }

    private final SsrcAssociationType parseAssociationType(String $this$parseAssociationType) {
        return StringsKt.equals($this$parseAssociationType, "FID", true) ? SsrcAssociationType.RTX : (StringsKt.equals($this$parseAssociationType, "SIM", true) ? SsrcAssociationType.SIM : (StringsKt.equals($this$parseAssociationType, "FEC-FR", true) ? SsrcAssociationType.FEC : null));
    }

    private final RtpExtension toRtpExtension(RTPHdrExtPacketExtension $this$toRtpExtension) {
        String string = $this$toRtpExtension.getURI().toString();
        Intrinsics.checkNotNullExpressionValue(string, "uri.toString()");
        RtpExtensionType rtpExtensionType = RtpExtensionType.Companion.createFromUri(string);
        if (rtpExtensionType == null) {
            return null;
        }
        RtpExtensionType type2 = rtpExtensionType;
        Byte by = Byte.valueOf($this$toRtpExtension.getID());
        Intrinsics.checkNotNullExpressionValue(by, "valueOf(id)");
        return new RtpExtension(((Number)by).byteValue(), type2);
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Relay handleColibri2Relay(Colibri2Relay c2relay) throws IqProcessingException {
        Iterable $this$forEach$iv;
        Colibri2Relay.Builder builder2 = Colibri2Relay.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder()");
        Colibri2Relay.Builder respBuilder = builder2;
        respBuilder.setId(c2relay.getId());
        if (c2relay.getExpire()) {
            Relay relay = this.conference.getRelay(c2relay.getId());
            if (relay != null) {
                relay.expire();
            }
            respBuilder.setExpire(true);
            Colibri2Relay colibri2Relay = respBuilder.build();
            Intrinsics.checkNotNullExpressionValue(colibri2Relay, "respBuilder.build()");
            return colibri2Relay;
        }
        Relay relay = null;
        if (c2relay.getCreate()) {
            if (this.conference.getRelay(c2relay.getId()) != null) {
                throw new IqProcessingException(StanzaError.Condition.conflict, "Relay with ID " + c2relay.getId() + " already exists");
            }
            Transport transport = c2relay.getTransport();
            if (transport == null) {
                throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create relay " + c2relay.getId() + " with no <transport>");
            }
            Transport transport2 = transport;
            Relay relay2 = this.conference.createRelay(c2relay.getId(), c2relay.getMeshId(), transport2.getIceControlling(), transport2.getUseUniquePort());
            Intrinsics.checkNotNullExpressionValue(relay2, "conference.createRelay(\n\u2026eUniquePort\n            )");
            relay = relay2;
        } else {
            Relay relay3 = this.conference.getRelay(c2relay.getId());
            if (relay3 == null) {
                throw new IqProcessingException(StanzaError.Condition.bad_request, "Unknown relay " + c2relay.getId());
            }
            relay = relay3;
        }
        Transport transport = c2relay.getTransport();
        if ((transport != null ? transport.getSctp() : null) != null) {
            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP is not supported for relays.");
        }
        AbstractPacketExtension abstractPacketExtension = c2relay.getTransport();
        if (abstractPacketExtension != null && (abstractPacketExtension = abstractPacketExtension.getIceUdpTransport()) != null) {
            AbstractPacketExtension it = abstractPacketExtension;
            boolean bl = false;
            relay.setTransportInfo((IceUdpTransportPacketExtension)it);
        }
        if (c2relay.getCreate()) {
            Transport.Builder builder3 = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder()");
            Transport.Builder transBuilder = builder3;
            transBuilder.setIceUdpExtension(relay.describeTransport());
            respBuilder.setTransport(transBuilder.build());
        }
        Iterator<Media> iterator2 = c2relay.getMedia().iterator();
        while (iterator2.hasNext()) {
            Object it;
            Media media;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "c2relay.media");
            List<PayloadTypePacketExtension> list = media.getPayloadTypes();
            Intrinsics.checkNotNullExpressionValue(list, "media.payloadTypes");
            $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Unit unit;
                PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(ptExt, "ptExt");
                MediaType mediaType = media.getType();
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, "media.type");
                if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                    boolean bl2 = false;
                    relay.addPayloadType((PayloadType)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                this.logger.warn("Ignoring unrecognized payload type extension: " + ptExt.toXML());
            }
            List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
            Intrinsics.checkNotNullExpressionValue(list2, "media.rtpHdrExts");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Unit unit;
                RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(rtpHdrExt, "rtpHdrExt");
                if (this.toRtpExtension(rtpHdrExt) != null) {
                    boolean bl3 = false;
                    relay.addRtpExtension((RtpExtension)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                this.logger.warn("Ignoring unrecognized RTP header extension: " + rtpHdrExt.toXML());
            }
        }
        Object object = c2relay.getEndpoints();
        if (object != null && (object = ((Endpoints)object).getEndpoints()) != null) {
            $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List<MediaSource> list;
                Object object2;
                Colibri2Endpoint endpoint = (Colibri2Endpoint)element$iv;
                boolean bl = false;
                if (endpoint.getExpire()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
                    relay.removeRemoteEndpoint(string);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(endpoint, "endpoint");
                Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> sources = this.parseSourceDescs(endpoint);
                if (endpoint.getCreate()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
                    relay.addRemoteEndpoint(string, endpoint.getStatsId(), (Collection<AudioSourceDesc>)sources.getFirst(), (Collection<MediaSourceDesc>)sources.getSecond());
                } else {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
                    relay.updateRemoteEndpoint(string, (Collection<AudioSourceDesc>)sources.getFirst(), (Collection<MediaSourceDesc>)sources.getSecond());
                }
                if ((object2 = endpoint.getSources()) == null || (object2 = (list = ((Sources)object2).getMediaSources())) == null) continue;
                Intrinsics.checkNotNullExpressionValue(object2, "mediaSources");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$forEach$iv3;
                    void $this$mapNotNullTo$iv$iv;
                    MediaSource mediaSource = (MediaSource)element$iv2;
                    boolean bl4 = false;
                    List<SourceGroupPacketExtension> list3 = mediaSource.getSsrcGroups();
                    Intrinsics.checkNotNullExpressionValue(list3, "mediaSource.ssrcGroups");
                    Iterable $this$mapNotNull$iv = list3;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        SsrcAssociation it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                        boolean bl5 = false;
                        SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue(it, "it");
                        if (this.toSsrcAssociation(it) == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        SsrcAssociation it = (SsrcAssociation)element$iv3;
                        boolean bl8 = false;
                        String string = endpoint.getId();
                        Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
                        this.addSsrcAssociation(string, it);
                    }
                }
            }
        }
        Colibri2Relay colibri2Relay = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue(colibri2Relay, "respBuilder.build()");
        return colibri2Relay;
    }

    private final Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> parseSourceDescs(Colibri2Endpoint $this$parseSourceDescs) {
        List videoSources;
        List audioSources;
        block5: {
            audioSources = new ArrayList();
            videoSources = new ArrayList();
            Sources sources = $this$parseSourceDescs.getSources();
            if (sources == null) break block5;
            Sources it = sources;
            boolean bl = false;
            List<MediaSource> list = it.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list, "it.mediaSources");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource m3 = (MediaSource)element$iv;
                boolean bl2 = false;
                if (m3.getType() == MediaType.AUDIO) {
                    if (m3.getSources().isEmpty()) {
                        this.logger.warn("Ignoring audio source " + m3.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay (no SSRCs): " + $this$parseSourceDescs.toXML());
                        continue;
                    }
                    List<SourcePacketExtension> list2 = m3.getSources();
                    Intrinsics.checkNotNullExpressionValue(list2, "m.sources");
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SourcePacketExtension it2 = (SourcePacketExtension)element$iv2;
                        boolean bl3 = false;
                        audioSources.add(new AudioSourceDesc(it2.getSSRC(), $this$parseSourceDescs.getId(), m3.getId()));
                    }
                    continue;
                }
                if (m3.getType() == MediaType.VIDEO) {
                    MediaSourceDesc desc = MediaSourceFactory.createMediaSource((Collection<SourcePacketExtension>)m3.getSources(), (Collection<SourceGroupPacketExtension>)m3.getSsrcGroups(), $this$parseSourceDescs.getId(), m3.getId());
                    if (desc == null) continue;
                    videoSources.add(desc);
                    continue;
                }
                this.logger.warn("Ignoring source " + m3.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay: unsupported type " + m3.getType());
            }
        }
        return new Pair<List<AudioSourceDesc>, List<MediaSourceDesc>>(audioSources, videoSources);
    }
}

