/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.videobridge.JvbLastNKt;
import org.jitsi.videobridge.SsrcLimitConfig;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.load_management.ConferenceSizeLastNLimits;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a,\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\f\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u00a8\u0006\u0012"}, d2={"effectiveLastN", "", "lastN", "conferenceSize", "getEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "sources", "", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "prioritize", "conferenceSources", "", "selectedSourceNames", "", "jitsi-videobridge"})
public final class PrioritizeKt {
    @NotNull
    public static final List<MediaSourceDesc> prioritize(@NotNull List<MediaSourceDesc> conferenceSources, @NotNull List<String> selectedSourceNames) {
        Intrinsics.checkNotNullParameter(conferenceSources, "conferenceSources");
        Intrinsics.checkNotNullParameter(selectedSourceNames, "selectedSourceNames");
        Iterable $this$forEach$iv = CollectionsKt.asReversed(selectedSourceNames);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSourceDesc selectedSource;
            Object v0;
            block2: {
                String selectedSourceName = (String)element$iv;
                boolean bl = false;
                Iterable iterable = conferenceSources;
                for (Object t : iterable) {
                    MediaSourceDesc it = (MediaSourceDesc)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getSourceName(), selectedSourceName)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((MediaSourceDesc)v0 == null) continue;
            boolean bl = false;
            conferenceSources.remove(selectedSource);
            conferenceSources.add(0, selectedSource);
        }
        return conferenceSources;
    }

    public static /* synthetic */ List prioritize$default(List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return PrioritizeKt.prioritize(list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<MediaSourceDesc, VideoConstraints> getEffectiveConstraints(@NotNull List<MediaSourceDesc> sources, @NotNull AllocationSettings allocationSettings) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(allocationSettings, "allocationSettings");
        int effectiveLastN = PrioritizeKt.effectiveLastN(allocationSettings.getLastN(), sources.size() + 1);
        int sourcesWithNonZeroConstraints = 0;
        Iterable $this$associateWith$iv = sources;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            VideoConstraints videoConstraints;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            if (sourcesWithNonZeroConstraints >= effectiveLastN) {
                videoConstraints = VideoConstraints.Companion.getNOTHING();
            } else {
                void source;
                VideoConstraints videoConstraints2;
                VideoConstraints it = videoConstraints2 = allocationSettings.getConstraints(source.getSourceName());
                boolean bl2 = false;
                if (!it.isDisabled()) {
                    ++sourcesWithNonZeroConstraints;
                }
                videoConstraints = videoConstraints2;
            }
            VideoConstraints videoConstraints3 = videoConstraints;
            map.put(t, videoConstraints3);
        }
        return result$iv;
    }

    private static final int effectiveLastN(int lastN, int conferenceSize) {
        int[] nArray = new int[]{lastN, JvbLastNKt.jvbLastNSingleton.getJvbLastN(), ConferenceSizeLastNLimits.Companion.getSingleton().getLastNLimit(conferenceSize), SsrcLimitConfig.config.getMaxVideoSsrcs()};
        int adjustedLastN = JvbLastNKt.calculateLastN(nArray);
        return adjustedLastN < 0 ? Integer.MAX_VALUE : adjustedLastN;
    }
}

