/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.ReceiverConstraintsMap;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.json.simple.JSONObject;

public abstract class AbstractEndpoint
implements MediaSourceContainer {
    private final String id;
    protected final Logger logger;
    private final Conference conference;
    private final Map<String, ReceiverConstraintsMap> receiverVideoConstraints = new HashMap<String, ReceiverConstraintsMap>();
    private String statsId;
    private boolean expired = false;
    @Deprecated
    protected VideoConstraints maxReceiverVideoConstraints = new VideoConstraints(0, 0.0);
    protected Map<String, VideoConstraints> maxReceiverVideoConstraintsMap = new HashMap<String, VideoConstraints>();
    protected final EventEmitter<EventHandler> eventEmitter = new SyncEventEmitter<EventHandler>();
    protected Map<String, VideoType> videoTypeCache = new HashMap<String, VideoType>();

    protected AbstractEndpoint(Conference conference, String id, Logger parentLogger) {
        this.conference = Objects.requireNonNull(conference, "conference");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("epId", id);
        this.logger = parentLogger.createChildLogger(this.getClass().getName(), context);
        this.id = Objects.requireNonNull(id, "id");
    }

    public boolean hasVideoAvailable() {
        for (MediaSourceDesc source : this.getMediaSources()) {
            if (source.getVideoType() == VideoType.NONE) continue;
            return true;
        }
        return this.videoTypeCache.values().stream().anyMatch(t -> t != VideoType.NONE);
    }

    public void setVideoType(@NotNull String sourceName, VideoType videoType) {
        MediaSourceDesc mediaSourceDesc = this.findMediaSourceDesc(sourceName);
        if (mediaSourceDesc != null && mediaSourceDesc.getVideoType() != videoType) {
            mediaSourceDesc.setVideoType(videoType);
            this.conference.getSpeechActivity().endpointVideoAvailabilityChanged();
        }
        this.videoTypeCache.put(sourceName, videoType);
    }

    protected void applyVideoTypeCache(MediaSourceDesc[] mediaSourceDescs) {
        for (MediaSourceDesc mediaSourceDesc : mediaSourceDescs) {
            VideoType videoType = this.videoTypeCache.get(mediaSourceDesc.getSourceName());
            if (videoType == null) continue;
            mediaSourceDesc.setVideoType(videoType);
            this.videoTypeCache.remove(mediaSourceDesc.getSourceName());
        }
    }

    public abstract boolean receivesSsrc(long var1);

    public abstract Set<Long> getSsrcs();

    public AbstractEndpointMessageTransport getMessageTransport() {
        return null;
    }

    @Nullable
    protected MediaSourceDesc getMediaSource() {
        return Arrays.stream(this.getMediaSources()).findFirst().orElse(null);
    }

    protected MediaSourceDesc findMediaSourceDesc(@NotNull String sourceName) {
        for (MediaSourceDesc desc : this.getMediaSources()) {
            if (!sourceName.equals(desc.getSourceName())) continue;
            return desc;
        }
        return null;
    }

    public String getStatsId() {
        return this.statsId;
    }

    @Override
    @NotNull
    public final String getId() {
        return this.id;
    }

    public Conference getConference() {
        return this.conference;
    }

    void addEventHandler(EventHandler eventHandler) {
        this.eventEmitter.addHandler(eventHandler);
    }

    void removeEventHandler(EventHandler eventHandler) {
        this.eventEmitter.removeHandler(eventHandler);
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setStatsId(String value2) {
        this.statsId = value2;
        if (value2 != null) {
            this.logger.addContext("stats_id", value2);
        }
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getId();
    }

    public void expire() {
        this.logger.info("Expiring.");
        this.expired = true;
        Conference conference = this.getConference();
        if (conference != null) {
            conference.endpointExpired(this);
        }
    }

    public abstract boolean shouldExpire();

    public Instant getLastIncomingActivity() {
        return ClockUtils.NEVER;
    }

    public abstract void requestKeyframe(long var1);

    public abstract void requestKeyframe();

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        JSONObject receiverVideoConstraints = new JSONObject();
        this.receiverVideoConstraints.forEach((sourceName, receiverConstraints) -> receiverVideoConstraints.put(sourceName, receiverConstraints.getDebugState()));
        debugState.put("receiverVideoConstraints", receiverVideoConstraints);
        debugState.put("maxReceiverVideoConstraintsMap", new HashMap<String, VideoConstraints>(this.maxReceiverVideoConstraintsMap));
        debugState.put("expired", this.expired);
        debugState.put("statsId", this.statsId);
        return debugState;
    }

    private void receiverVideoConstraintsChanged(String sourceName, int newMaxHeight) {
        VideoConstraints newReceiverMaxVideoConstraints = new VideoConstraints(newMaxHeight, -1.0);
        VideoConstraints oldReceiverMaxVideoConstraints = this.maxReceiverVideoConstraintsMap.get(sourceName);
        if (!newReceiverMaxVideoConstraints.equals(oldReceiverMaxVideoConstraints)) {
            this.maxReceiverVideoConstraintsMap.put(sourceName, newReceiverMaxVideoConstraints);
            this.sendVideoConstraintsV2(sourceName, newReceiverMaxVideoConstraints);
        }
    }

    public abstract boolean isSendingAudio();

    public abstract boolean isSendingVideo();

    public abstract void addPayloadType(PayloadType var1);

    public abstract void addRtpExtension(RtpExtension var1);

    @Deprecated
    protected abstract void sendVideoConstraints(@NotNull VideoConstraints var1);

    protected abstract void sendVideoConstraintsV2(@NotNull String var1, @NotNull VideoConstraints var2);

    public void addReceiver(@NotNull String receiverId, @NotNull String sourceName, @NotNull VideoConstraints newVideoConstraints) {
        VideoConstraints oldVideoConstraints;
        ReceiverConstraintsMap sourceConstraints = this.receiverVideoConstraints.get(sourceName);
        if (sourceConstraints == null) {
            sourceConstraints = new ReceiverConstraintsMap();
            this.receiverVideoConstraints.put(sourceName, sourceConstraints);
        }
        if ((oldVideoConstraints = sourceConstraints.put(receiverId, newVideoConstraints)) == null || !oldVideoConstraints.equals(newVideoConstraints)) {
            this.logger.debug(() -> "Changed receiver constraints: " + receiverId + "->" + sourceName + ": " + newVideoConstraints.getMaxHeight());
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    public void removeReceiver(String receiverId) {
        for (Map.Entry<String, ReceiverConstraintsMap> sourceConstraintsEntry : this.receiverVideoConstraints.entrySet()) {
            String sourceName = sourceConstraintsEntry.getKey();
            ReceiverConstraintsMap sourceConstraints = sourceConstraintsEntry.getValue();
            if (sourceConstraints.remove(receiverId) == null) continue;
            this.logger.debug(() -> "Removed receiver " + receiverId + " for " + sourceName);
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    public void removeSourceReceiver(String receiverId, String sourceName) {
        ReceiverConstraintsMap sourceConstraints = this.receiverVideoConstraints.get(sourceName);
        if (sourceConstraints != null && sourceConstraints.remove(receiverId) != null) {
            this.logger.debug(() -> "Removed receiver " + receiverId + " for " + sourceName);
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    public static interface EventHandler {
        public void iceSucceeded();

        public void iceFailed();

        public void sourcesChanged();
    }
}

