/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import jakarta.servlet.ServletContainerInitializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ContainerInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerInitializer.class);
    protected final ServletContainerInitializer _target;
    protected final Class<?>[] _interestedTypes;
    protected final Set<String> _applicableTypeNames = ConcurrentHashMap.newKeySet();
    protected final Set<String> _annotatedTypeNames = ConcurrentHashMap.newKeySet();

    public ContainerInitializer(ServletContainerInitializer target, Class<?>[] classes2) {
        this._target = target;
        this._interestedTypes = classes2;
    }

    public ContainerInitializer(ClassLoader loader, String toString2) {
        Matcher m3 = Pattern.compile("ContainerInitializer\\{(.*),interested=(.*),applicable=(.*),annotated=(.*)\\}").matcher(toString2);
        if (!m3.matches()) {
            throw new IllegalArgumentException(toString2);
        }
        try {
            this._target = (ServletContainerInitializer)loader.loadClass(m3.group(1)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] interested = StringUtil.arrayFromString(m3.group(2));
            this._interestedTypes = new Class[interested.length];
            for (int i = 0; i < interested.length; ++i) {
                this._interestedTypes[i] = loader.loadClass(interested[i]);
            }
            for (String s2 : StringUtil.arrayFromString(m3.group(3))) {
                this._applicableTypeNames.add(s2);
            }
            for (String s2 : StringUtil.arrayFromString(m3.group(4))) {
                this._annotatedTypeNames.add(s2);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(toString2, e);
        }
    }

    public ServletContainerInitializer getTarget() {
        return this._target;
    }

    public Class[] getInterestedTypes() {
        return this._interestedTypes;
    }

    public void addAnnotatedTypeName(String className) {
        this._annotatedTypeNames.add(className);
    }

    public Set<String> getAnnotatedTypeNames() {
        return Collections.unmodifiableSet(this._annotatedTypeNames);
    }

    public void addApplicableTypeName(String className) {
        this._applicableTypeNames.add(className);
    }

    public Set<String> getApplicableTypeNames() {
        return Collections.unmodifiableSet(this._applicableTypeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartup(WebAppContext context) throws Exception {
        if (this._target != null) {
            HashSet classes2 = new HashSet();
            try {
                for (String s2 : this._applicableTypeNames) {
                    classes2.add(Loader.loadClass(s2));
                }
                context.getServletContext().setExtendedListenerTypes(true);
                if (LOG.isDebugEnabled()) {
                    long start = System.nanoTime();
                    this._target.onStartup(classes2, context.getServletContext());
                    LOG.debug("ContainerInitializer {} called in {}ms", (Object)this._target.getClass().getName(), (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                } else {
                    this._target.onStartup(classes2, context.getServletContext());
                }
            }
            finally {
                context.getServletContext().setExtendedListenerTypes(false);
            }
        }
    }

    public String toString() {
        List interested = Collections.emptyList();
        if (this._interestedTypes != null) {
            interested = new ArrayList(this._interestedTypes.length);
            for (Class<?> c : this._interestedTypes) {
                interested.add(c.getName());
            }
        }
        return String.format("ContainerInitializer{%s,interested=%s,applicable=%s,annotated=%s}", this._target.getClass().getName(), interested, this._applicableTypeNames, this._annotatedTypeNames);
    }

    public void resolveClasses(WebAppContext context, Map<String, Set<String>> classMap) {
        Set<String> annotatedClassNames = this.getAnnotatedTypeNames();
        if (annotatedClassNames != null && !annotatedClassNames.isEmpty()) {
            for (String name : annotatedClassNames) {
                this.addApplicableTypeName(name);
                this.addInheritedTypes(classMap, classMap.get(name));
            }
        }
        if (this.getInterestedTypes() != null) {
            for (Class c : this.getInterestedTypes()) {
                if (c.isAnnotation()) continue;
                this.addInheritedTypes(classMap, classMap.get(c.getName()));
            }
        }
    }

    private void addInheritedTypes(Map<String, Set<String>> classMap, Set<String> names) {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String s2 : names) {
            this.addApplicableTypeName(s2);
            this.addInheritedTypes(classMap, classMap.get(s2));
        }
    }
}

