/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.rest.BadRequestExceptionWithMessage;
import org.jitsi.jicofo.xmpp.ConferenceIqHandler;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.stringprep.XmppStringprepException;

@Path(value="/conference-request/v1")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\tH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jitsi/jicofo/rest/ConferenceRequest;", "", "conferenceIqHandler", "Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "(Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;)V", "getConferenceIqHandler", "()Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "conferenceRequest", "", "Lorg/jitsi/jicofo/ConferenceRequest;", "jicofo"})
public final class ConferenceRequest {
    @NotNull
    private final ConferenceIqHandler conferenceIqHandler;

    public ConferenceRequest(@NotNull ConferenceIqHandler conferenceIqHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)conferenceIqHandler), (String)"conferenceIqHandler");
        this.conferenceIqHandler = conferenceIqHandler;
    }

    @NotNull
    public final ConferenceIqHandler getConferenceIqHandler() {
        return this.conferenceIqHandler;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NotNull
    public final String conferenceRequest(@NotNull org.jitsi.jicofo.ConferenceRequest conferenceRequest) {
        Intrinsics.checkNotNullParameter((Object)conferenceRequest, (String)"conferenceRequest");
        IQ response = null;
        try {
            response = this.conferenceIqHandler.handleConferenceIq(conferenceRequest.toConferenceIq());
        }
        catch (XmppStringprepException e) {
            throw new BadRequestExceptionWithMessage("Invalid room name: " + e.getMessage());
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage(e.getMessage());
        }
        if (!(response instanceof ConferenceIq)) {
            if (response instanceof ErrorIQ) {
                Throwable throwable;
                StanzaError.Condition condition = ((ErrorIQ)response).getError().getCondition();
                switch (condition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[condition.ordinal()]) {
                    case 1: {
                        System.err.println("Not authorised");
                        throwable = (Throwable)new ForbiddenException();
                        break;
                    }
                    case 2: {
                        System.err.println("not_acceptable");
                        throwable = (Throwable)((Object)new BadRequestExceptionWithMessage("invalid-session"));
                        break;
                    }
                    default: {
                        throwable = (Throwable)((Object)new BadRequestExceptionWithMessage(((ErrorIQ)response).getError().toString()));
                    }
                }
                throw throwable;
            }
            throw new InternalServerErrorException();
        }
        return org.jitsi.jicofo.ConferenceRequest.Companion.fromConferenceIq((ConferenceIq)response).toJson();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StanzaError.Condition.values().length];
            nArray[StanzaError.Condition.not_authorized.ordinal()] = 1;
            nArray[StanzaError.Condition.not_acceptable.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

