/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.Offer;
import org.jitsi.jicofo.bridge.colibri.BridgeSelectionFailedException;
import org.jitsi.jicofo.bridge.colibri.ColibriAllocation;
import org.jitsi.jicofo.bridge.colibri.ColibriAllocationFailedException;
import org.jitsi.jicofo.bridge.colibri.ColibriSessionManager;
import org.jitsi.jicofo.bridge.colibri.ConferenceAlreadyExistsException;
import org.jitsi.jicofo.bridge.colibri.ParticipantAllocationParameters;
import org.jitsi.jicofo.codec.JingleOfferFactory;
import org.jitsi.jicofo.codec.OfferOptions;
import org.jitsi.jicofo.conference.ConferenceUtilKt;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.UnsupportedFeatureConfigurationException;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.util.Cancelable;
import org.jitsi.jicofo.util.OfferOptionsUtilKt;
import org.jitsi.jicofo.xmpp.jingle.JingleSession;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleUtils;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SctpMapExtension;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeSessionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StartMutedPacketExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class ParticipantInviteRunnable
implements Runnable,
Cancelable {
    private final Logger logger;
    private final JitsiMeetConferenceImpl meetConference;
    @NotNull
    private final ColibriSessionManager colibriSessionManager;
    private volatile boolean canceled = false;
    private final boolean startAudioMuted;
    private final boolean startVideoMuted;
    private final boolean forceMuteAudio;
    private final boolean forceMuteVideo;
    private final boolean reInvite;
    @NotNull
    private final Participant participant;

    public ParticipantInviteRunnable(JitsiMeetConferenceImpl meetConference, @NotNull ColibriSessionManager colibriSessionManager, @NotNull Participant participant, boolean startAudioMuted, boolean startVideoMuted, boolean reInvite, Logger parentLogger) {
        this.meetConference = meetConference;
        this.colibriSessionManager = colibriSessionManager;
        boolean forceMuteAudio = false;
        boolean forceMuteVideo = false;
        ChatRoom chatRoom = meetConference.getChatRoom();
        if (chatRoom != null && !participant.hasModeratorRights() && !participant.shouldSuppressForceMute()) {
            if (chatRoom.isAvModerationEnabled(MediaType.AUDIO)) {
                forceMuteAudio = true;
            }
            if (chatRoom.isAvModerationEnabled(MediaType.VIDEO)) {
                forceMuteVideo = true;
            }
        }
        this.forceMuteAudio = forceMuteAudio;
        this.forceMuteVideo = forceMuteVideo;
        this.startAudioMuted = startAudioMuted || forceMuteAudio;
        this.startVideoMuted = startVideoMuted || forceMuteVideo;
        this.reInvite = reInvite;
        this.participant = participant;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.logger.addContext("participant", participant.getChatMember().getName());
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            this.logger.error((Object)"Channel allocator failed: ", e);
            this.cancel();
        }
        finally {
            this.participant.inviteRunnableCompleted(this);
        }
    }

    private void doRun() {
        ColibriAllocation colibriAllocation;
        Offer offer;
        try {
            offer = this.createOffer();
        }
        catch (UnsupportedFeatureConfigurationException e) {
            this.logger.error((Object)"Error creating offer", (Throwable)e);
            return;
        }
        if (this.canceled) {
            return;
        }
        try {
            HashSet medias = new HashSet();
            offer.getContents().forEach(content -> {
                Media media = ConferenceUtilKt.toMedia(content);
                if (media != null) {
                    medias.add(media);
                } else {
                    this.logger.warn((Object)("Failed to convert ContentPacketExtension to Media: " + String.valueOf(content.toXML())));
                }
            });
            ParticipantAllocationParameters participantOptions = new ParticipantAllocationParameters(this.participant.getEndpointId(), this.participant.getStatId(), this.participant.getChatMember().getRegion(), this.participant.getSources(), this.participant.hasSourceNameSupport(), this.participant.useSsrcRewriting(), this.forceMuteAudio, this.forceMuteVideo, offer.getContents().stream().anyMatch(c -> c.getName() == "data"), this.participant.getChatMember().getRole() == MemberRole.VISITOR, medias);
            colibriAllocation = this.colibriSessionManager.allocate(participantOptions);
        }
        catch (BridgeSelectionFailedException e) {
            this.logger.error((Object)"Can not invite participant, no bridge available.");
            this.cancel();
            return;
        }
        catch (ConferenceAlreadyExistsException e) {
            this.logger.warn((Object)"Can not allocate colibri channels, conference already exists.");
            this.cancel();
            return;
        }
        catch (ColibriAllocationFailedException e) {
            this.logger.error((Object)"Failed to allocate colibri channels", (Throwable)e);
            this.cancel();
            return;
        }
        if (this.canceled) {
            return;
        }
        offer = this.updateOffer(offer, colibriAllocation);
        if (this.canceled) {
            return;
        }
        try {
            this.invite(offer, colibriAllocation);
        }
        catch (SmackException.NotConnectedException e) {
            this.logger.error((Object)"Failed to invite participant: ", (Throwable)e);
            this.colibriSessionManager.removeParticipant(this.participant.getEndpointId());
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public String toString() {
        return String.format("%s[%s]@%d", this.getClass().getSimpleName(), this.participant, this.hashCode());
    }

    private Offer createOffer() throws UnsupportedFeatureConfigurationException {
        OfferOptions offerOptions = new OfferOptions();
        OfferOptionsUtilKt.applyConstraints(offerOptions, this.participant);
        if (!offerOptions.getTcc() && this.participant.hasRembSupport()) {
            offerOptions.setRemb(true);
        }
        return new Offer(new ConferenceSourceMap(), JingleOfferFactory.INSTANCE.createOffer(offerOptions));
    }

    private void invite(Offer offer, ColibriAllocation colibriAllocation) throws SmackException.NotConnectedException {
        boolean expireChannels = false;
        EntityFullJid address = this.participant.getMucJid();
        ChatRoom chatRoom = this.meetConference.getChatRoom();
        if (chatRoom == null) {
            this.logger.info((Object)("Expiring " + String.valueOf(address) + " channels - conference disposed"));
            expireChannels = true;
        } else if (!this.meetConference.hasMember((Jid)address)) {
            this.logger.info((Object)("Expiring " + String.valueOf(address) + " channels - participant has left"));
            expireChannels = true;
        } else if (!this.canceled && !this.doInviteOrReinvite(offer, colibriAllocation)) {
            expireChannels = true;
        }
        if (expireChannels || this.canceled) {
            this.meetConference.onInviteFailed(this);
        }
    }

    private boolean doInviteOrReinvite(Offer offer, ColibriAllocation colibriAllocation) throws SmackException.NotConnectedException {
        boolean ack;
        JingleSession jingleSession = this.participant.getJingleSession();
        boolean initiateSession = !this.reInvite || jingleSession == null;
        ArrayList<Object> additionalExtensions = new ArrayList<Object>();
        if (this.startAudioMuted || this.startVideoMuted) {
            StartMutedPacketExtension startMutedExt = new StartMutedPacketExtension();
            startMutedExt.setAudioMute(this.startAudioMuted);
            startMutedExt.setVideoMute(this.startVideoMuted);
            additionalExtensions.add(startMutedExt);
        }
        additionalExtensions.add(new BridgeSessionPacketExtension(colibriAllocation.getBridgeSessionId(), colibriAllocation.getRegion()));
        ConferenceSourceMap sources = this.participant.resetSignaledSources(offer.getSources());
        if (initiateSession) {
            jingleSession = this.participant.createNewJingleSession();
            this.logger.info((Object)("Sending session-initiate to: " + String.valueOf(this.participant.getMucJid()) + " sources=" + String.valueOf(sources)));
            ack = jingleSession.initiateSession(offer.getContents(), additionalExtensions, sources);
        } else {
            ack = jingleSession.replaceTransport(offer.getContents(), additionalExtensions, sources);
        }
        if (!ack) {
            this.logger.info((Object)("Expiring " + String.valueOf(this.participant.getMucJid()) + " channels - no RESULT for " + (initiateSession ? "session-initiate" : "transport-replace")));
            return false;
        }
        return true;
    }

    @NotNull
    private Offer updateOffer(Offer offer, ColibriAllocation colibriAllocation) {
        ConferenceSourceMap conferenceSources = !this.participant.useSsrcRewriting() ? this.meetConference.getSources().copy() : new ConferenceSourceMap();
        conferenceSources.add(colibriAllocation.getSources());
        conferenceSources.remove(this.participant.getEndpointId());
        for (ContentPacketExtension cpe : offer.getContents()) {
            RtpDescriptionPacketExtension rtpDescPe;
            try {
                IceUdpTransportPacketExtension empty = (IceUdpTransportPacketExtension)cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                cpe.getChildExtensions().remove(empty);
                IceUdpTransportPacketExtension copy = IceUdpTransportPacketExtension.cloneTransportAndCandidates((IceUdpTransportPacketExtension)colibriAllocation.getTransport(), (boolean)true);
                if ("data".equalsIgnoreCase(cpe.getName())) {
                    SctpMapExtension sctpMap = new SctpMapExtension();
                    Integer sctpPort = colibriAllocation.getSctpPort();
                    if (sctpPort == null) {
                        throw new IllegalStateException("SCTP port must not be null");
                    }
                    sctpMap.setPort(sctpPort.intValue());
                    sctpMap.setProtocol(SctpMapExtension.Protocol.WEBRTC_CHANNEL);
                    sctpMap.setStreams(1024);
                    copy.addChildExtension((ExtensionElement)sctpMap);
                }
                cpe.addChildExtension((ExtensionElement)copy);
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            if ((rtpDescPe = JingleUtils.getRtpDescription((ContentPacketExtension)cpe)) == null) continue;
            rtpDescPe.addChildExtension((ExtensionElement)new JingleRtcpmuxPacketExtension());
        }
        return new Offer(conferenceSources, offer.getContents());
    }

    @NotNull
    public Participant getParticipant() {
        return this.participant;
    }
}

