/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jitsi.cmd.ParseException;
import org.jitsi.config.JitsiConfig;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class Main {
    private static final Logger logger = new LoggerImpl(Main.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException {
        JicofoServices jicofoServices;
        logger.info((Object)"Starting Jicofo.");
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error((Object)("An uncaught exception occurred in thread=" + String.valueOf(t)), e));
        Main.setupMetaconfigLogger();
        JitsiConfig.Companion.reloadNewConfig();
        ConfigUtils.PASSWORD_SYS_PROPS = "pass";
        ConfigUtils.PASSWORD_CMD_LINE_ARGS = "user_password";
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((ShutdownServiceImpl)shutdownService).beginShutdown()));
        try {
            Object object = JicofoServices.getJicofoServicesSingletonSyncRoot();
            synchronized (object) {
                jicofoServices = new JicofoServices();
                JicofoServices.setJicofoServicesSingleton(jicofoServices);
            }
        }
        catch (Exception e2) {
            logger.error((Object)"Failed to start jicofo: ", (Throwable)e2);
            TaskPools.shutdown();
            return;
        }
        try {
            shutdownService.waitForShutdown();
        }
        catch (Exception e3) {
            logger.error((Object)e3, (Throwable)e3);
        }
        logger.info((Object)"Stopping services.");
        jicofoServices.shutdown();
        TaskPools.shutdown();
        JicofoServices.setJicofoServicesSingleton(null);
    }

    private static void setupMetaconfigLogger() {
        LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger((Logger)configLogger){
            final /* synthetic */ Logger val$configLogger;
            {
                this.val$configLogger = logger;
            }

            public void warn(@NotNull Function0<String> function0) {
                this.val$configLogger.warn(() -> function0.invoke());
            }

            public void error(@NotNull Function0<String> function0) {
                this.val$configLogger.error(() -> function0.invoke());
            }

            public void debug(@NotNull Function0<String> function0) {
                this.val$configLogger.debug(() -> function0.invoke());
            }
        });
    }
}

