;;;
;;; irchat-pj-jisx0201.el
;;;
;;; This file is based on jisx0201.el (Mule 2.3)
;;; I referred mew-lang-jp.el (Mew 1.93) when editting.
;;; Thanks to Mule Project and Mew Project
;;;
;;; last modify : Sun, 27 Jun 1999 by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;;
;;; see file irchat-copyright.el for change log and copyright info

(provide 'irchat-pj-jisx0201)

(defvar irchat-pj-katakana-alist
  '(( 161 . "(I'(B" )
    ( 162 . "(I1(B" )
    ( 163 . "(I((B" )
    ( 164 . "(I2(B" )
    ( 165 . "(I)(B" )
    ( 166 . "(I3(B" )
    ( 167 . "(I*(B" )
    ( 168 . "(I4(B" )
    ( 169 . "(I+(B" )
    ( 170 . "(I5(B" )
    ( 171 . "(I6(B" )
    ( 172 . "(I6^(B" )
    ( 173 . "(I7(B" )
    ( 174 . "(I7^(B" )
    ( 175 . "(I8(B" )
    ( 176 . "(I8^(B" )
    ( 177 . "(I9(B" )
    ( 178 . "(I9^(B" )
    ( 179 . "(I:(B" )
    ( 180 . "(I:^(B" )
    ( 181 . "(I;(B" )
    ( 182 . "(I;^(B" )
    ( 183 . "(I<(B" )
    ( 184 . "(I<^(B" )
    ( 185 . "(I=(B" )
    ( 186 . "(I=^(B" )
    ( 187 . "(I>(B" )
    ( 188 . "(I>^(B" )
    ( 189 . "(I?(B" )
    ( 190 . "(I?^(B" )
    ( 191 . "(I@(B" )
    ( 192 . "(I@^(B" )
    ( 193 . "(IA(B" )
    ( 194 . "(IA^(B" )
    ( 195 . "(I/(B" )
    ( 196 . "(IB(B" )
    ( 197 . "(IB^(B" )
    ( 198 . "(IC(B" )
    ( 199 . "(IC^(B" )
    ( 200 . "(ID(B" )
    ( 201 . "(ID^(B" )
    ( 202 . "(IE(B" )
    ( 203 . "(IF(B" )
    ( 204 . "(IG(B" )
    ( 205 . "(IH(B" )
    ( 206 . "(II(B" )
    ( 207 . "(IJ(B" )
    ( 208 . "(IJ^(B" )
    ( 209 . "(IJ_(B" )
    ( 210 . "(IK(B" )
    ( 211 . "(IK^(B" )
    ( 212 . "(IK_(B" )
    ( 213 . "(IL(B" )
    ( 214 . "(IL^(B" )
    ( 215 . "(IL_(B" )
    ( 216 . "(IM(B" )
    ( 217 . "(IM^(B" )
    ( 218 . "(IM_(B" )
    ( 219 . "(IN(B" )
    ( 220 . "(IN^(B" )
    ( 221 . "(IN_(B" )
    ( 222 . "(IO(B" )
    ( 223 . "(IP(B" )
    ( 224 . "(IQ(B" )
    ( 225 . "(IR(B" )
    ( 226 . "(IS(B" )
    ( 227 . "(I,(B" )
    ( 228 . "(IT(B" )
    ( 229 . "(I-(B" )
    ( 230 . "(IU(B" )
    ( 231 . "(I.(B" )
    ( 232 . "(IV(B" )
    ( 233 . "(IW(B" )
    ( 234 . "(IX(B" )
    ( 235 . "(IY(B" )
    ( 236 . "(IZ(B" )
    ( 237 . "(I[(B" )
    ( 239 . "(I\(B" ) ; (I\(B -> $B%o(B $B$KJQ49$9$k$h$&$K(B
    ( 238 . "(I\(B" ) ; $B%o$H%n$N=gHV$,8r49$7$F$"$k!#(B
    ( 240 . "(I((B" )
    ( 241 . "(I*(B" )
    ( 242 . "(I&(B" )
    ( 243 . "(I](B" )
    ( 244 . "(I3^(B" )
    ( 245 . "(I6(B" )
    ( 246 . "(I9(B" )))

(defvar irchat-pj-katakana-kigou-alist
  '(( 162 . "(I$(B" )
    ( 163 . "(I!(B" )
    ( 166 . "(I%(B" )
    ( 171 . "(I^(B" )
    ( 172 . "(I_(B" )
    ( 188 . "(I0(B" )
    ( 214 . "(I"(B" )
    ( 215 . "(I#(B" )))

(defvar irchat-pj-dakuon-list
  '( ?$B%+(B ?$B%-(B ?$B%/(B ?$B%1(B ?$B%3(B
     ?$B%5(B ?$B%7(B ?$B%9(B ?$B%;(B ?$B%=(B
     ?$B%?(B ?$B%A(B ?$B%D(B ?$B%F(B ?$B%H(B
     ?$B%O(B ?$B%R(B ?$B%U(B ?$B%X(B ?$B%[(B))

;;(defvar irchat-pj-handakuon-list (memq ?$B%O(B 'irchat-pj-dakuon-list))
(defvar irchat-pj-handakuon-list 
  '( ?$B%O(B ?$B%R(B ?$B%U(B ?$B%X(B ?$B%[(B))

(defun irchat-pj-search-henkan-alist (ch list)
  (let ((ptr list)
	(result nil))
    (while ptr
      (if (string= ch (cdr (car ptr)))
	  (progn
	    (setq result (car (car ptr)))
	    (setq ptr nil))
	(setq ptr (cdr ptr))))
    result))

(defun irchat-pj-make-jisx0208-katakana (ch)
  (cond ((featurep 'xemacs)
	 (message "XEmacs")
	 (make-char 'japanese-jisx0208 37 (- ch 128)))
	((>= (string-to-int (substring emacs-version 0 2)) 20)
	 (message "Emacs20")
	 (make-char 'japanese-jisx0208 ?\245 ch))
	(t
	 (message "Other")
	 (make-character lc-jp ?\245 ch))))

(defun irchat-pj-make-jisx0208-kigou (ch)
  (cond ((featurep 'xemacs)
	 (message "XEmacs")
	 (make-char 'japanese-jisx0208 33 (- ch 128)))
	((>= (string-to-int (substring emacs-version 0 2)) 20)
	 (message "Emacs20")
	 (make-char 'japanese-jisx0208 ?\241 ch))
	(t
	 (message "Other")
	 (make-character lc-jp ?\241 ch))))

(defun irchat-pj-zenkaku-katakana-string (string)
  "Convert jisx0201 katakana to jisx0208."
  (let ((return "")
	(ch nil)
	(wk nil)
	(point 0))
    (if (null (string-match "\\ck" string))
	(setq return string)
      (while (< point (length string))
	(setq ch (elt string point))
	(setq wk (char-to-string ch))
	(if (null (string-match "\\ck" wk))
	    (setq return (concat return wk))
	  (cond ((= ch ?(I^(B)
		 (if (= 0 point)
		     (setq return (concat return "$B!+(B"))
		   (setq wk (elt return (1- (length return))))
		   (cond ((= wk ?$B%&(B)
			  (setq return (substring return 0 (1- (length return))))
			  (setq return (concat return "$B%t(B")))
			 ((setq wk (memq wk irchat-pj-dakuon-list))
			  (setq return (substring return 0 (1- (length return))))
			  (setq return (concat return (char-to-string (1+ (car wk))))))
			 (t
			  (setq return (concat return "$B!+(B"))))))
		((= ch ?(I_(B)
		 (if (= 0 point)
		     (setq return (concat return "$B!,(B"))
		   (setq wk (elt return (1- (length return))))
		   (cond ((setq wk (memq wk irchat-pj-handakuon-list))
			  (setq return (substring return 0 (1- (length return))))
			  (setq return (concat return (char-to-string (+ 2 (car wk))))))
			 (t
			  (setq return (concat return "$B!,(B"))))))
		((setq wk (irchat-pj-search-henkan-alist
			   (char-to-string ch) irchat-pj-katakana-alist))
		 (setq return
		       (concat return
			       (char-to-string (irchat-pj-make-jisx0208-katakana wk)))))
		((setq wk (irchat-pj-search-henkan-alist
			   (char-to-string ch) irchat-pj-katakana-kigou-alist))
		 (setq return
		       (concat return
			       (char-to-string (irchat-pj-make-jisx0208-kigou wk)))))))
	(setq point (1+ point))))
    return))

;;;
;;; eof
;;;
