/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class CompressedRead {
    private final byte[] data;
    private static final Checksum DIGESTER = new CRC32();
    private final int hashCode;
    public int readIndex;

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof CompressedRead)) {
            return false;
        }
        CompressedRead other = (CompressedRead)o;
        return Arrays.equals(this.data, other.data);
    }

    public CompressedRead(byte[] byteBuffer) {
        this.data = byteBuffer;
        this.hashCode = CompressedRead.hashCode(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hashCode(byte[] data) {
        Checksum checksum = DIGESTER;
        synchronized (checksum) {
            long digest = CompressedRead.hashCodeLong(data);
            return 32 >> (int)digest ^ (int)digest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hashCodeLong(byte[] data) {
        Checksum checksum = DIGESTER;
        synchronized (checksum) {
            DIGESTER.reset();
            DIGESTER.update(data, 0, data.length);
            return DIGESTER.getValue();
        }
    }

    public static long hashCodeLongNotSynchronized(byte[] data) {
        DIGESTER.reset();
        DIGESTER.update(data, 0, data.length);
        return DIGESTER.getValue();
    }

    public final long hashCodeLong() {
        return CompressedRead.hashCodeLong(this.data);
    }
}

