/*****
 NAME
	pmemorys.h - protocol definition for Object class group
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PMEMORY_H_INCLUDED)
#define	PMEMORY_H_INCLUDED

#include <coconut/pobject.h>

/*****
 PROTOCOL:
   NAME: PMemory

 */
@protocol PMemory <PObject>
  - (void *) new: (size_t) reqsize ;
  - (void *) copy: (const void *) src size: (size_t) size ;
  - (void *) changeSize: (size_t) newsize ;
  - (void *) increaseSize: (size_t) newsize ;
  - (void *) decreaseSize: (size_t) newsize ;
  - (void *) ptr ;
  - (size_t) size ;
  - (void *) append: (const void *) src size: (size_t) size ;
  - (void *) prepend: (const void *) src size: (size_t) size ;
  - (void *) insert: (u_int) pos src: (const void *) src size: (size_t) size ;
    /* this method overwite the original last byte (maybe '\0') */
  - (void *) remove: (u_int) frompos size: (size_t) size ;
  - clear ;

  - (id <PMemory>) duplicate ;

  /* this is dangerous method, give a pointer of already allocated memory
     object to "src". */
  - setAlreadyAllocated: (void *) src size: (size_t) size ;
@end

#endif	/* !defined(PMEMORY_H_INCLUDED) */

