/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.net.AbstractEndpoint;

public abstract class AbstractProtocol
implements ProtocolHandler {
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    private int nameIndex = 0;
    private int maxCookieCount = 200;

    protected abstract AbstractEndpoint getEndpoint();

    public int getMaxHeaderCount() {
        return this.getEndpoint().getMaxHeaderCount();
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.getEndpoint().setMaxHeaderCount(maxHeaderCount);
    }

    public int getLocalPort() {
        return this.getEndpoint().getLocalPort();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = AbstractProtocol.nextNameIndex();
        }
        return this.nameIndex;
    }

    public static int nextNameIndex() {
        return nameCounter.incrementAndGet();
    }

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int maxCookieCount) {
        this.maxCookieCount = maxCookieCount;
    }

    protected String createName(String prefix, InetAddress address, int port) {
        StringBuilder name = new StringBuilder(prefix);
        name.append('-');
        if (address != null) {
            String strAddr = address.toString();
            if (strAddr.startsWith("/")) {
                strAddr = strAddr.substring(1);
            }
            name.append(URLEncoder.encode(strAddr)).append('-');
        }
        if (port == 0) {
            name.append("auto-");
            name.append(this.getNameIndex());
            port = this.getLocalPort();
            if (port != -1) {
                name.append('-');
                name.append(port);
            }
        } else {
            name.append(port);
        }
        return name.toString();
    }
}

