/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DualFloatFunction;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.LongConstValueSource;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.util.DateMathParser;

class DateValueSourceParser
extends ValueSourceParser {
    DateValueSourceParser() {
    }

    @Override
    public void init(NamedList args) {
    }

    public Date getDate(FunctionQParser fp, String arg) {
        if (arg == null) {
            return null;
        }
        if (arg.startsWith("NOW") || arg.length() > 1 && Character.isDigit(arg.charAt(1))) {
            Date now = null;
            return DateMathParser.parseMath(now, arg);
        }
        return null;
    }

    public ValueSource getValueSource(FunctionQParser fp, String arg) {
        if (arg == null) {
            return null;
        }
        SchemaField f = fp.req.getSchema().getField(arg);
        return f.getType().getValueSource(f, fp);
    }

    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        long ms2;
        Date d1;
        String first = fp.parseArg();
        String second = fp.parseArg();
        if (first == null) {
            first = "NOW";
        }
        ValueSource v1 = (d1 = this.getDate(fp, first)) == null ? this.getValueSource(fp, first) : null;
        Date d2 = this.getDate(fp, second);
        ValueSource v2 = d2 == null ? this.getValueSource(fp, second) : null;
        final long ms1 = d1 == null ? 0L : d1.getTime();
        long l = ms2 = d2 == null ? 0L : d2.getTime();
        if (d1 != null && v2 == null) {
            return new LongConstValueSource(ms1 - ms2);
        }
        if (v1 != null && v2 == null && d2 == null) {
            return v1;
        }
        if (d1 != null && v2 != null) {
            return new DualFloatFunction((ValueSource)new LongConstValueSource(ms1), v2){

                protected String name() {
                    return "ms";
                }

                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                    return ms1 - bVals.longVal(doc);
                }
            };
        }
        if (v1 != null && d2 != null) {
            return new DualFloatFunction(v1, (ValueSource)new LongConstValueSource(ms2)){

                protected String name() {
                    return "ms";
                }

                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                    return aVals.longVal(doc) - ms2;
                }
            };
        }
        if (v1 != null && v2 != null) {
            return new DualFloatFunction(v1, v2){

                protected String name() {
                    return "ms";
                }

                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
                    return aVals.longVal(doc) - bVals.longVal(doc);
                }
            };
        }
        return null;
    }
}

