/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.endpoints;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.endpoints.S3AccessPointEndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3BucketEndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactoryContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointUtils;
import software.amazon.awssdk.services.s3.internal.endpoints.S3ObjectLambdaOperationEndpointResolver;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest;

@SdkInternalApi
public final class S3EndpointResolverFactory {
    private static final S3EndpointResolver ACCESS_POINT_ENDPOINT_RESOLVER = S3AccessPointEndpointResolver.create();
    private static final S3EndpointResolver BUCKET_ENDPOINT_RESOLVER = S3BucketEndpointResolver.create();
    private static final S3EndpointResolver OBJECT_LAMBDA_OPERATION_RESOLVER = S3ObjectLambdaOperationEndpointResolver.create();

    private S3EndpointResolverFactory() {
    }

    public static S3EndpointResolver getEndpointResolver(S3EndpointResolverFactoryContext context) {
        Optional<String> bucketName = context.bucketName();
        if (bucketName.isPresent() && S3EndpointUtils.isArn(bucketName.get())) {
            return ACCESS_POINT_ENDPOINT_RESOLVER;
        }
        if (S3EndpointResolverFactory.isObjectLambdaRequest(context.originalRequest())) {
            return OBJECT_LAMBDA_OPERATION_RESOLVER;
        }
        return BUCKET_ENDPOINT_RESOLVER;
    }

    private static boolean isObjectLambdaRequest(S3Request request) {
        return request instanceof WriteGetObjectResponseRequest;
    }
}

