/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitSet;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UniqueBlockAgg;
import org.apache.solr.search.join.BlockJoinParentQParser;

public class UniqueBlockQueryAgg
extends UniqueBlockAgg {
    private final Query query;

    public UniqueBlockQueryAgg(Query query) {
        super(null);
        this.query = query;
        this.arg = query.toString();
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        return new UniqueBlockQuerySlotAcc(fcontext, this.query, numSlots);
    }

    private static final class UniqueBlockQuerySlotAcc
    extends UniqueBlockAgg.UniqueBlockSlotAcc {
        private Query query;
        private BitSet parentBitSet;

        private UniqueBlockQuerySlotAcc(FacetContext fcontext, Query query, int numSlots) throws IOException {
            super(fcontext, null, numSlots);
            this.query = query;
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            this.parentBitSet = BlockJoinParentQParser.getCachedFilter(this.fcontext.req, this.query).getFilter().getBitSet(readerContext);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) {
            int ord;
            if (this.parentBitSet != null && (ord = this.parentBitSet.nextSetBit(doc)) != Integer.MAX_VALUE) {
                this.collectOrdToSlot(slotNum, ord);
            }
        }
    }
}

