/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Color;

public class ColorUtil {
    private ColorUtil() {
    }

    public static Color lighter(Color color) {
        return ColorUtil.lighter(color, -0.1f);
    }

    public static Color brighter(Color color) {
        return ColorUtil.brighter(color, 0.05f);
    }

    public static Color darker(Color color) {
        return ColorUtil.brighter(color, -0.05f);
    }

    public static Color brighter(Color color, float factor) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        return ColorUtil.setBrightness(color, hsbvals[2] + factor);
    }

    public static float getBrightness(Color color) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        return hsbvals[2];
    }

    public static Color lighter(Color color, float factor) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        return ColorUtil.setSaturation(color, hsbvals[1] + factor);
    }

    public static Color setSaturation(Color color, float saturation) {
        if (saturation < 0.0f || saturation > 1.0f) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[1] = saturation;
        color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
        return color;
    }

    public static Color setBrightness(Color color, float brightness) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[2] = brightness;
        hsbvals[2] = Math.min(hsbvals[2], 1.0f);
        hsbvals[2] = Math.max(hsbvals[2], 0.0f);
        color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
        return color;
    }
}

