/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.fife.jgoodies.looks.common.ShadowPopupBorder;
import org.fife.jgoodies.looks.common.ShadowPopupFactory;
import org.fife.rsta.ui.DecorativeIconPanel;
import org.fife.rtext.RText;
import org.fife.rtext.StoreKeeper;
import org.fife.ui.OS;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.UIUtil;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.templates.StaticCodeTemplate;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.Utilities;
import org.fife.ui.rtextfilechooser.filters.ExtensionFileFilter;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.util.DynamicIntArray;
import org.fife.util.TranslucencyUtil;

public class RTextUtilities {
    public static final String MACRO_EXTENSION = ".macro";
    private static final String FILE_FILTERS_FILE = "ExtraFileChooserFilters.xml";
    private static String currentLaF;
    private static boolean dropShadowsEnabledInEditor;

    public static final void addDefaultCodeTemplates() {
        CodeTemplateManager ctm = RSyntaxTextArea.getCodeTemplateManager();
        StaticCodeTemplate t = new StaticCodeTemplate("dob", "do {\n\t", "\n} while ();");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("forb", "for (", ") {\n\t\n}");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("ifb", "if (", ") {\n\t\n}");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("pb", "public ", "");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("pkgb", "package ", "");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("stb", "static ", "");
        ctm.addTemplate(t);
        t = new StaticCodeTemplate("whileb", "while (", ") {\n\t\n}");
        ctm.addTemplate(t);
    }

    private static final void addFilter(RTextFileChooser chooser, ResourceBundle msg, String key, Object extensions) {
        ExtensionFileFilter filter = null;
        filter = extensions instanceof String ? new ExtensionFileFilter(msg.getString(key), (String)extensions) : new ExtensionFileFilter(msg.getString(key), (String[])extensions);
        chooser.addChoosableFileFilter((FileFilter)filter);
    }

    public static void centerSelectionVertically(RSyntaxTextArea textArea) {
        Rectangle visible = textArea.getVisibleRect();
        Rectangle r = null;
        try {
            r = textArea.modelToView(textArea.getCaretPosition());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return;
        }
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i = textArea.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }

    public static final void configureFindInFilesDialog(FindInFilesDialog fnfd) {
        fnfd.addInFilesComboBoxFilter("*.asm");
        fnfd.addInFilesComboBoxFilter("*.bat *.cmd");
        fnfd.addInFilesComboBoxFilter("*.c *.cpp *.cxx *.h");
        fnfd.addInFilesComboBoxFilter("*.cs");
        fnfd.addInFilesComboBoxFilter("*.htm *.html");
        fnfd.addInFilesComboBoxFilter("*.java");
        fnfd.addInFilesComboBoxFilter("*.js");
        fnfd.addInFilesComboBoxFilter("*.pl *.perl *.pm");
        fnfd.addInFilesComboBoxFilter("*.py");
        fnfd.addInFilesComboBoxFilter("*.sh *.bsh *.csh *.ksh");
        fnfd.addInFilesComboBoxFilter("*.txt");
    }

    public static JPanel createAssistancePanel(JComponent comp, DecorativeIconPanel iconPanel) {
        if (iconPanel == null) {
            iconPanel = new DecorativeIconPanel();
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)iconPanel, "Before");
        panel.add(comp);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RTextFileChooser createFileChooser(RText rtext) {
        rtext.setCursor(Cursor.getPredefinedCursor(3));
        RTextFileChooser chooser = null;
        try {
            chooser = new RTextFileChooser();
            ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.FileFilters");
            RTextUtilities.addFilter(chooser, msg, "ActionScript", new String[]{"as", "asc"});
            RTextUtilities.addFilter(chooser, msg, "AssemblerX86", "asm");
            RTextUtilities.addFilter(chooser, msg, "BBCode", "bbc");
            RTextUtilities.addFilter(chooser, msg, "CPlusPlus", new String[]{"c", "cpp", "cxx", "h"});
            RTextUtilities.addFilter(chooser, msg, "Clojure", "clj");
            RTextUtilities.addFilter(chooser, msg, "CSharp", "cs");
            RTextUtilities.addFilter(chooser, msg, "CSS", "css");
            RTextUtilities.addFilter(chooser, msg, "D", "d");
            RTextUtilities.addFilter(chooser, msg, "Dart", "dart");
            RTextUtilities.addFilter(chooser, msg, "Delphi", "pas");
            RTextUtilities.addFilter(chooser, msg, "DTD", "dtd");
            RTextUtilities.addFilter(chooser, msg, "Flex", "mxml");
            RTextUtilities.addFilter(chooser, msg, "Fortran", new String[]{"f", "for", "fort", "f77", "f90"});
            RTextUtilities.addFilter(chooser, msg, "Groovy", new String[]{"groovy", "grv"});
            RTextUtilities.addFilter(chooser, msg, "HTML", new String[]{"htm", "html"});
            RTextUtilities.addFilter(chooser, msg, "Java", "java");
            RTextUtilities.addFilter(chooser, msg, "JavaScript", "js");
            RTextUtilities.addFilter(chooser, msg, "JSON", "json");
            RTextUtilities.addFilter(chooser, msg, "JSP", "jsp");
            RTextUtilities.addFilter(chooser, msg, "LaTeX", new String[]{"tex", "ltx", "latex"});
            RTextUtilities.addFilter(chooser, msg, "Lisp", new String[]{"cl", "clisp", "el", "l", "lisp", "lsp", "ml"});
            RTextUtilities.addFilter(chooser, msg, "Lua", "lua");
            RTextUtilities.addFilter(chooser, msg, "Makefile", new String[]{"Makefile", "makefile"});
            RTextUtilities.addFilter(chooser, msg, "Nsis", "nsi");
            RTextUtilities.addFilter(chooser, msg, "Perl", new String[]{"pl", "perl", "pm"});
            RTextUtilities.addFilter(chooser, msg, "PHP", new String[]{"php"});
            RTextUtilities.addFilter(chooser, msg, "PropertiesFiles", "properties");
            RTextUtilities.addFilter(chooser, msg, "Python", "py");
            RTextUtilities.addFilter(chooser, msg, "Ruby", "rb");
            RTextUtilities.addFilter(chooser, msg, "SAS", "sas");
            RTextUtilities.addFilter(chooser, msg, "Scala", "scala");
            RTextUtilities.addFilter(chooser, msg, "SQL", "sql");
            RTextUtilities.addFilter(chooser, msg, "PlainText", "txt");
            RTextUtilities.addFilter(chooser, msg, "Tcl", "tcl");
            RTextUtilities.addFilter(chooser, msg, "UnixShell", new String[]{"sh", "bsh", "csh", "ksh"});
            RTextUtilities.addFilter(chooser, msg, "VisualBasic", "vb");
            RTextUtilities.addFilter(chooser, msg, "WindowsBatch", new String[]{"bat", "cmd"});
            RTextUtilities.addFilter(chooser, msg, "XML", new String[]{"xml", "xsl", "xsd", "wsdl", "jnlp", "macro", "manifest"});
            File file = new File(rtext.getInstallLocation(), FILE_FILTERS_FILE);
            try {
                Utilities.addFileFilters((File)file, (RTextFileChooser)chooser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(msg.getString("AllSupported"), new String[]{"as", "asc", "asm", "bbc", "c", "cpp", "cxx", "h", "clj", "cs", "css", "d", "dart", "pas", "dtd", "mxml", "f", "for", "fort", "f77", "f90", "groovy", "grv", "htm", "html", "java", "js", "json", "jsp", "tex", "ltx", "latex", "cl", "clisp", "el", "l", "lisp", "lsp", "ml", "lua", "Makefile", "makefile", "nsi", "perl", "pl", "pm", "php", "properties", "py", "rb", "sas", "scala", "sql", "tcl", "txt", "sh", "bsh", "csh", "ksh", "vb", "bat", "cmd", "xml", "xsl", "xsd", "wsdl", "jnlp", "macro", "manifest"}, 0, false));
            chooser.setFileFilter(null);
            chooser.setCurrentDirectory(rtext.getWorkingDirectory());
            File favoritesFile = RTextUtilities.getFileChooserFavoritesFile();
            if (favoritesFile.isFile()) {
                try {
                    chooser.loadFavorites(favoritesFile);
                }
                catch (IOException ioe) {
                    rtext.displayException(ioe);
                }
            }
        }
        finally {
            rtext.setCursor(Cursor.getPredefinedCursor(0));
        }
        return chooser;
    }

    private static String createRegexForFileFilter(String filter) {
        StringBuilder sb = new StringBuilder("^");
        block6: for (int i = 0; i < filter.length(); ++i) {
            char ch = filter.charAt(i);
            switch (ch) {
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.append('$').toString();
    }

    public static boolean enableTemplates(RText rtext, boolean enabled) {
        boolean old = RSyntaxTextArea.getTemplatesEnabled();
        if (old != enabled) {
            RSyntaxTextArea.setTemplatesEnabled(enabled);
            if (enabled) {
                File f = new File(RTextUtilities.getPreferencesDirectory(), "templates");
                if (!f.isDirectory() && !f.mkdirs()) {
                    return false;
                }
                return RSyntaxTextArea.setTemplateDirectory(f.getAbsolutePath());
            }
        }
        return true;
    }

    public static final String escapeForHTML(String s, String newlineReplacement) {
        return RTextUtilities.escapeForHTML(s, newlineReplacement, false);
    }

    public static final String escapeForHTML(String s, String newlineReplacement, boolean inPreBlock) {
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = "   ";
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    if (inPreBlock) {
                        sb.append(' ');
                        continue block8;
                    }
                    sb.append("&nbsp;");
                    continue block8;
                }
                case '\n': {
                    sb.append(newlineReplacement);
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\t': {
                    sb.append(tabString);
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static boolean getDropShadowsEnabledInEditor() {
        return dropShadowsEnabledInEditor;
    }

    private static File getFileChooserFavoritesFile() {
        return new File(RTextUtilities.getPreferencesDirectory(), "fileChooser.favorites");
    }

    public static Image getImageFromFile(String fileName) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new URL("file:///" + fileName));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public static String getLookAndFeelToSave() {
        String laf = currentLaF;
        if (laf == null) {
            laf = UIManager.getLookAndFeel().getClass().getName();
        }
        return laf;
    }

    public static final File getMacroDirectory() {
        File f = new File(RTextUtilities.getPreferencesDirectory(), "macros");
        if (!f.isDirectory() && !f.mkdirs()) {
            return null;
        }
        return f;
    }

    public static final String getMacroName(File macroFile) {
        String name = null;
        if (macroFile != null && (name = macroFile.getName()).endsWith(MACRO_EXTENSION)) {
            name = name.substring(0, name.length() - MACRO_EXTENSION.length());
        }
        return name;
    }

    public static File getPreferencesDirectory() {
        return new File(System.getProperty("user.home"), ".rtext");
    }

    public static Pattern getPatternForFileFilter(String fileFilter, boolean showErrorDialog) {
        String pattern = RTextUtilities.createRegexForFileFilter(fileFilter);
        int flags = OS.get().isCaseSensitive() ? 0 : 66;
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException pse) {
            if (showErrorDialog) {
                String text = pse.getMessage();
                if (text == null) {
                    text = pse.toString();
                }
                JOptionPane.showMessageDialog(null, "Error in the regular expression '" + pattern + "' formed from parameter '" + fileFilter + "':\n" + text + "\nPlease use only valid filename characters " + "or wildcards (* or ?).\n" + "If you have, please report this error at: " + "http://sourceforge.net/projects/rtext", "Error", 0);
            }
            return null;
        }
    }

    public static final File[] getSavedMacroFiles() {
        File[] allFiles;
        File macroDir = RTextUtilities.getMacroDirectory();
        if (macroDir != null && macroDir.isDirectory() && (allFiles = macroDir.listFiles()) != null && allFiles.length > 0) {
            int count = allFiles.length;
            DynamicIntArray dia = new DynamicIntArray();
            for (int i = 0; i < count; ++i) {
                if (!allFiles[i].getName().endsWith(MACRO_EXTENSION)) continue;
                dia.add(i);
            }
            count = dia.getSize();
            File[] macroFiles = new File[count];
            for (int i = 0; i < count; ++i) {
                macroFiles[i] = allFiles[dia.get(i)];
            }
            return macroFiles;
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getTranslucentImage(RText rtext, Image image, float alpha) {
        alpha = Math.max(0.0f, alpha);
        alpha = Math.min(alpha, 1.0f);
        BufferedImage bi = null;
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        bi = rtext.getGraphicsConfiguration().createCompatibleImage(w, h);
        Graphics2D g2d = bi.createGraphics();
        try {
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, w, h);
            g2d.setComposite(AlphaComposite.getInstance(3, alpha));
            g2d.drawImage(image, 0, 0, null);
        }
        finally {
            g2d.dispose();
        }
        return bi;
    }

    public static final String join(String[] array) {
        return RTextUtilities.join(array, ", ");
    }

    public static final String join(String[] array, String connector) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(connector).append(array[i]);
        }
        return sb.toString();
    }

    public static void openAllFilesIn(RText rtext, File directory) {
        if (directory != null && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int count = files.length;
            for (int i = 0; i < count; ++i) {
                if (files[i].isDirectory()) {
                    RTextUtilities.openAllFilesIn(rtext, files[i]);
                    continue;
                }
                rtext.openFile(files[i].getAbsolutePath());
            }
        }
    }

    public static void removeTabbedPaneFocusTraversalKeyBindings(JComponent c) {
        InputMap im = c.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(34, 2), "nothing");
        im.put(KeyStroke.getKeyStroke(33, 2), "nothing");
        im = c.getInputMap();
        im.put(KeyStroke.getKeyStroke(34, 2), "nothing");
        im.put(KeyStroke.getKeyStroke(33, 2), "nothing");
    }

    public static void saveFileChooserFavorites(RText rtext) {
        RTextFileChooser chooser = rtext.getFileChooser();
        try {
            chooser.saveFavorites(RTextUtilities.getFileChooserFavoritesFile());
        }
        catch (IOException ioe) {
            rtext.displayException(ioe);
        }
    }

    public static void setDropShadowsEnabledInEditor(boolean enabled) {
        if (enabled != dropShadowsEnabledInEditor) {
            dropShadowsEnabledInEditor = enabled;
            if (dropShadowsEnabledInEditor) {
                TranslucencyUtil util = TranslucencyUtil.get();
                if (util != null && util.isTranslucencySupported(true)) {
                    PopupWindowDecorator.set(new PopupWindowDecorator(){

                        public void decorate(JWindow window) {
                            Container cp = window.getContentPane();
                            if (cp instanceof JComponent) {
                                TranslucencyUtil util = TranslucencyUtil.get();
                                util.setOpaque((Window)window, false);
                                ((JComponent)cp).setBorder(BorderFactory.createCompoundBorder((Border)ShadowPopupBorder.getInstance(), ((JComponent)cp).getBorder()));
                            }
                        }
                    });
                }
            } else {
                PopupWindowDecorator.set(null);
            }
        }
    }

    public static void setLookAndFeel(RText rtext, String lnfClassName) {
        String current = UIManager.getLookAndFeel().getClass().getName();
        if (lnfClassName != null && !current.equals(lnfClassName)) {
            try {
                currentLaF = lnfClassName;
                ClassLoader cl = rtext.getLookAndFeelManager().getLAFClassLoader();
                if (WebLookAndFeelUtils.isWebLookAndFeel((String)lnfClassName)) {
                    ShadowPopupFactory.uninstall();
                    WebLookAndFeelUtils.installWebLookAndFeelProperties((ClassLoader)cl);
                } else {
                    ShadowPopupFactory.install();
                }
                Class<?> c = cl.loadClass(lnfClassName);
                LookAndFeel lnf = (LookAndFeel)c.newInstance();
                boolean curSubstance = SubstanceUtils.isSubstanceInstalled();
                boolean nextSubstance = SubstanceUtils.isASubstanceLookAndFeel((LookAndFeel)lnf);
                if (curSubstance != nextSubstance) {
                    String message = rtext.getString("Info.LookAndFeel.LoadOnNextRestart", new Object[0]);
                    String title = rtext.getString("InfoDialogHeader", new Object[0]);
                    JOptionPane.showMessageDialog((Component)((Object)rtext), message, title, 1);
                    return;
                }
                UIManager.setLookAndFeel(lnf);
                UIManager.getLookAndFeelDefaults().put("ClassLoader", cl);
                UIUtil.installOsSpecificLafTweaks();
                StoreKeeper.updateLookAndFeels(lnf);
            }
            catch (NoClassDefFoundError ncdfe) {
                rtext.displayException(ncdfe);
            }
            catch (Exception e) {
                rtext.displayException(e);
            }
        }
    }

    public static String stripBackupExtensions(String fileName) {
        if (fileName != null) {
            if (fileName.endsWith(".bak") || fileName.endsWith(".old")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            } else if (fileName.endsWith(".orig")) {
                fileName = fileName.substring(0, fileName.length() - 5);
            }
        }
        return fileName;
    }
}

