/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

import java.util.Vector;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.Piece;
import net.sourceforge.squirrel_sql.client.util.codereformat.PieceMarkerSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.StateOfPosition;

public class CodeReformatorKernel {
    private String _statementSeparator;
    private CommentSpec[] _commentSpecs;
    private PieceMarkerSpec[] _pieceSpecs;
    private StateOfPosition[] _statesOfPosition;

    public CodeReformatorKernel(String statementSeparator, PieceMarkerSpec[] pieceSpecs, CommentSpec[] commentSpecs) {
        this._commentSpecs = commentSpecs;
        this._pieceSpecs = pieceSpecs;
        this._statementSeparator = statementSeparator;
    }

    public String[] toPieces(String in) {
        this._statesOfPosition = this.getStatesOfPosition(in);
        Vector<String> ret = new Vector<String>();
        String upperIn = in.replaceAll("\u00df", "s");
        upperIn = upperIn.toUpperCase();
        int begin = 0;
        while (begin < in.length()) {
            Piece p = this.getNextToplevelPiece(begin, upperIn);
            if (null == p.spec) {
                ret.add(in.substring(begin).trim());
                begin = in.length();
                continue;
            }
            int type = p.spec.getType();
            switch (type) {
                case 0: {
                    if (begin < p.beginsAt && 0 < in.substring(begin, p.beginsAt).trim().length()) {
                        ret.add(in.substring(begin, p.beginsAt).trim());
                    }
                    int afterPieceMarker = p.beginsAt + p.spec.getLengthRightSpaced();
                    Piece nextP = this.getNextToplevelPiece(afterPieceMarker, upperIn);
                    if (null == nextP.spec) {
                        ret.add(in.substring(p.beginsAt).trim());
                        begin = in.length();
                        break;
                    }
                    if (1 == nextP.spec.getType()) {
                        if (nextP.beginsAt + nextP.spec.getLengthRightSpaced() < in.length()) {
                            ret.add(in.substring(p.beginsAt, nextP.beginsAt + nextP.spec.getLengthRightSpaced()).trim());
                        } else {
                            ret.add(in.substring(p.beginsAt).trim());
                        }
                        begin = nextP.beginsAt + nextP.spec.getLengthRightSpaced();
                        break;
                    }
                    ret.add(in.substring(p.beginsAt, nextP.beginsAt).trim());
                    begin = nextP.beginsAt;
                    break;
                }
                case 1: {
                    if (p.beginsAt + p.spec.getLengthRightSpaced() < in.length()) {
                        ret.add(in.substring(begin, p.beginsAt + p.spec.getLengthRightSpaced()).trim());
                    } else {
                        ret.add(in.substring(begin).trim());
                    }
                    begin = p.beginsAt + p.spec.getLengthRightSpaced();
                    break;
                }
                case 2: {
                    if (begin < p.beginsAt && 0 < in.substring(begin, p.beginsAt).trim().length()) {
                        ret.add(in.substring(begin, p.beginsAt).trim());
                    }
                    if (p.beginsAt + p.spec.getLengthRightSpaced() < in.length()) {
                        ret.add(in.substring(p.beginsAt, p.beginsAt + p.spec.getLengthRightSpaced()).trim());
                    } else {
                        ret.add(in.substring(p.beginsAt).trim());
                    }
                    begin = p.beginsAt + p.spec.getLengthRightSpaced();
                }
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    private Piece getNextToplevelPiece(int startAt, String in) {
        Piece ret = new Piece();
        ret.beginsAt = in.length();
        for (int i = 0; i < this._pieceSpecs.length; ++i) {
            int buf = this.getTopLevelIndex(startAt, in, this._pieceSpecs[i]);
            if (-1 >= buf || buf >= ret.beginsAt) continue;
            ret.spec = this._pieceSpecs[i];
            ret.beginsAt = buf;
        }
        if (null == ret.spec) {
            ret.beginsAt = startAt;
        }
        return ret;
    }

    private int getTopLevelIndex(int startAt, String in, PieceMarkerSpec pieceSpec) {
        int ix = in.indexOf(pieceSpec.getPieceMarker(), startAt);
        while (-1 != ix) {
            if (this._statesOfPosition[ix].isTopLevel) {
                if (pieceSpec.needsSuroundingWhiteSpaces()) {
                    char after;
                    char before = 0 == ix ? (char)' ' : (char)in.charAt(ix - 1);
                    int pieceMArkerEnd = ix + pieceSpec.getPieceMarker().length() - 1;
                    char c = after = pieceMArkerEnd == in.length() - 1 ? (char)' ' : (char)in.charAt(pieceMArkerEnd + 1);
                    if (Character.isWhitespace(before) && Character.isWhitespace(after)) {
                        return ix;
                    }
                } else {
                    return ix;
                }
            }
            ix = in.indexOf(pieceSpec.getPieceMarker(), ix + 1);
        }
        return -1;
    }

    public StateOfPosition[] getStatesOfPosition(String in) {
        StateOfPosition[] ret = new StateOfPosition[in.length()];
        StateOfPosition buf = new StateOfPosition();
        for (int i = 0; i < in.length(); ++i) {
            if ('\'' == in.charAt(i)) {
                ++buf.literalSepCount;
            }
            if (0 == buf.literalSepCount % 2) {
                for (int j = 0; j < this._commentSpecs.length; ++j) {
                    if (in.substring(i).startsWith(this._commentSpecs[j].commentBegin) && -1 == buf.commentIndex) {
                        buf.commentIndex = j;
                    }
                    if (!in.substring(i).startsWith(this._commentSpecs[j].commentEnd) || j != buf.commentIndex) continue;
                    buf.commentIndex = -1;
                }
            }
            if (0 == buf.literalSepCount % 2 && -1 == buf.commentIndex) {
                if ('(' == in.charAt(i)) {
                    ++buf.braketDepth;
                }
                if (')' == in.charAt(i)) {
                    --buf.braketDepth;
                }
            }
            buf.isTopLevel = -1 == buf.commentIndex && 0 == buf.literalSepCount % 2 && 0 == buf.braketDepth;
            ret[i] = (StateOfPosition)buf.clone();
        }
        return ret;
    }
}

