/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nimrod;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.Kernel;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sf.nimrod.NimRODBorders;
import net.sf.nimrod.NimRODIconFactory;
import net.sf.nimrod.NimRODTheme;
import net.sf.nimrod.NimRODUtils;

public class NimRODLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 7191199335214123414L;
    String fichTheme;
    protected static MetalTheme theme;

    public NimRODLookAndFeel() {
        NimRODTheme nt;
        block14: {
            this.fichTheme = "";
            nt = new NimRODTheme("NimRODThemeFile.theme");
            String nomFich = null;
            String nomURL = null;
            try {
                nomFich = System.getProperty("nimrodlf.themeFile");
                nomURL = System.getProperty("nimrodlf.themeURL");
            }
            catch (Exception ex) {
                // empty catch block
            }
            nomFich = nomFich == null ? "NimRODThemeFile.theme" : nomFich;
            try {
                NimRODTheme ntt;
                if (nomURL != null) {
                    try {
                        nt = ntt = new NimRODTheme(new URL(nomURL));
                    }
                    catch (Exception ex) {
                        System.err.println(nomURL + " theme file is wrong or doesn't exist...");
                        System.err.println(ex);
                    }
                } else {
                    try {
                        nt = ntt = new NimRODTheme(nomFich);
                    }
                    catch (Exception ex) {
                        System.err.println(nomFich + " theme file is wrong or doesn't exist...");
                        System.err.println(ex);
                    }
                }
                this.fichTheme = nomFich;
            }
            catch (Exception ex) {
                nt = new NimRODTheme("NimRODThemeFile.theme");
            }
            try {
                String selection = System.getProperty("nimrodlf.selection");
                String background = System.getProperty("nimrodlf.background");
                String p1 = System.getProperty("nimrodlf.p1");
                String p2 = System.getProperty("nimrodlf.p2");
                String p3 = System.getProperty("nimrodlf.p3");
                String s1 = System.getProperty("nimrodlf.s1");
                String s2 = System.getProperty("nimrodlf.s2");
                String s3 = System.getProperty("nimrodlf.s3");
                String w = System.getProperty("nimrodlf.w");
                String b = System.getProperty("nimrodlf.b");
                String opMenu = System.getProperty("nimrodlf.menuOpacity");
                String opFrame = System.getProperty("nimrodlf.frameOpacity");
                nt = NimRODUtils.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, opMenu, opFrame);
            }
            catch (Exception ex) {
                if (this.fichTheme.length() != 0) break block14;
                nt = new NimRODTheme("NimRODThemeFile.theme");
            }
        }
        NimRODLookAndFeel.setCurrentTheme(nt);
        float[] elements = new float[25];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = 0.1f;
        }
        int mid = 3;
        elements[mid * mid] = 0.2f;
        NimRODUtils.kernelFat = new Kernel(5, 5, elements);
        elements = new float[9];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = 0.1f;
        }
        mid = 2;
        elements[mid * mid] = 0.2f;
        NimRODUtils.kernelThin = new Kernel(3, 3, elements);
    }

    @Override
    public void initialize() {
        try {
            LookAndFeel laf = (LookAndFeel)Class.forName(UIManager.getSystemLookAndFeelClassName()).newInstance();
            UIDefaults systemDefaults = laf.getDefaults();
            Enumeration keys = systemDefaults.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                if (!key.contains("InputMap")) continue;
                UIManager.getDefaults().put(key, systemDefaults.get(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getID() {
        return "NimROD";
    }

    @Override
    public String getName() {
        return "NimROD";
    }

    @Override
    public String getDescription() {
        return "Look and Feel NimROD, by Nilo J. Gonzalez 2005-2007";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public static void setCurrentTheme(MetalTheme t) {
        MetalLookAndFeel.setCurrentTheme(t);
        theme = t;
        NimRODUtils.rollColor = null;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.put("ButtonUI", "net.sf.nimrod.NimRODButtonUI");
        table.put("ToggleButtonUI", "net.sf.nimrod.NimRODToggleButtonUI");
        table.put("TextFieldUI", "net.sf.nimrod.NimRODTextFieldUI");
        table.put("TextAreaUI", "net.sf.nimrod.NimRODTextAreaUI");
        table.put("PasswordFieldUI", "net.sf.nimrod.NimRODPasswordFieldUI");
        table.put("CheckBoxUI", "net.sf.nimrod.NimRODCheckBoxUI");
        table.put("RadioButtonUI", "net.sf.nimrod.NimRODRadioButtonUI");
        table.put("FormattedTextFieldUI", "net.sf.nimrod.NimRODFormattedTextFieldUI");
        table.put("SliderUI", "net.sf.nimrod.NimRODSliderUI");
        table.put("SpinnerUI", "net.sf.nimrod.NimRODSpinnerUI");
        table.put("ListUI", "net.sf.nimrod.NimRODListUI");
        table.put("ComboBoxUI", "net.sf.nimrod.NimRODComboBoxUI");
        table.put("ScrollBarUI", "net.sf.nimrod.NimRODScrollBarUI");
        table.put("ToolBarUI", "net.sf.nimrod.NimRODToolBarUI");
        table.put("ProgressBarUI", "net.sf.nimrod.NimRODProgressBarUI");
        table.put("ScrollPaneUI", "net.sf.nimrod.NimRODScrollPaneUI");
        table.put("TabbedPaneUI", "net.sf.nimrod.NimRODTabbedPaneUI");
        table.put("TableHeaderUI", "net.sf.nimrod.NimRODTableHeaderUI");
        table.put("SplitPaneUI", "net.sf.nimrod.NimRODSplitPaneUI");
        table.put("InternalFrameUI", "net.sf.nimrod.NimRODInternalFrameUI");
        table.put("DesktopIconUI", "net.sf.nimrod.NimRODDesktopIconUI");
        table.put("ToolTipUI", "net.sf.nimrod.NimRODToolTipUI");
        table.put("MenuBarUI", "net.sf.nimrod.NimRODMenuBarUI");
        table.put("MenuUI", "net.sf.nimrod.NimRODMenuUI");
        table.put("SeparatorUI", "net.sf.nimrod.NimRODSeparatorUI");
        table.put("PopupMenuUI", "net.sf.nimrod.NimRODPopupMenuUI");
        table.put("PopupMenuSeparatorUI", "net.sf.nimrod.NimRODPopupMenuSeparatorUI");
        table.put("MenuItemUI", "net.sf.nimrod.NimRODMenuItemUI");
        table.put("CheckBoxMenuItemUI", "net.sf.nimrod.NimRODCheckBoxMenuItemUI");
        table.put("RadioButtonMenuItemUI", "net.sf.nimrod.NimRODRadioButtonMenuItemUI");
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("textInactiveText", NimRODLookAndFeel.getInactiveSystemTextColor().darker());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        try {
            ColorUIResource cFore = (ColorUIResource)table.get("MenuItem.disabledForeground");
            ColorUIResource cBack = (ColorUIResource)table.get("MenuItem.foreground");
            ColorUIResource col = NimRODUtils.getColorTercio(cBack, cFore);
            table.put("MenuItem.disabledForeground", col);
            table.put("Label.disabledForeground", col);
            table.put("CheckBoxMenuItem.disabledForeground", col);
            table.put("Menu.disabledForeground", col);
            table.put("RadioButtonMenuItem.disabledForeground", col);
            table.put("ComboBox.disabledForeground", col);
            table.put("Button.disabledText", col);
            table.put("ToggleButton.disabledText", col);
            table.put("CheckBox.disabledText", col);
            table.put("RadioButton.disabledText", col);
            ColorUIResource col2 = NimRODUtils.getColorTercio(NimRODLookAndFeel.getWhite(), (Color)table.get("TextField.inactiveBackground"));
            table.put("TextField.inactiveBackground", col2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        table.put("MenuBar.border", NimRODBorders.getMenuBarBorder());
        Font fontMenu = ((Font)table.get("Menu.font")).deriveFont(1);
        table.put("MenuItem.acceleratorFont", fontMenu);
        table.put("RadioButtonMenuItem.acceleratorFont", fontMenu);
        table.put("CheckBoxMenuItem.acceleratorFont", fontMenu);
        ColorUIResource colAcce = NimRODUtils.getColorTercio((ColorUIResource)table.get("MenuItem.foreground"), (ColorUIResource)table.get("MenuItem.acceleratorForeground"));
        table.put("MenuItem.acceleratorForeground", colAcce);
        table.put("RadioButtonMenuItem.acceleratorForeground", colAcce);
        table.put("CheckBoxMenuItem.acceleratorForeground", colAcce);
        table.put("BorderPopupMenu.SombraBajIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/SombraMenuBajo.png"));
        table.put("BorderPopupMenu.SombraDerIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/SombraMenuDer.png"));
        table.put("BorderPopupMenu.SombraEsqIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/SombraMenuEsq.png"));
        table.put("BorderPopupMenu.SombraUpIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/SombraMenuUp.png"));
        table.put("BorderPopupMenu.SombraIzqIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/SombraMenuIzq.png"));
        table.put("Tree.collapsedIcon", NimRODIconFactory.getTreeCollapsedIcon());
        table.put("Tree.expandedIcon", NimRODIconFactory.getTreeExpandedIcon());
        table.put("Tree.closedIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/TreeDirCerrado.png"));
        table.put("Tree.openIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/TreeDirAbierto.png"));
        table.put("Tree.leafIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/TreeFicheroIcon.png"));
        table.put("Tree.PelotillaIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/TreePelotilla.png"));
        table.put("FileView.directoryIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogDirCerrado.png"));
        table.put("FileView.fileIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogFicheroIcon.png"));
        table.put("FileView.floppyDriveIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogFloppyIcon.png"));
        table.put("FileView.hardDriveIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogHDIcon.png"));
        table.put("FileChooser.newFolderIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogNewDir.png"));
        table.put("FileChooser.homeFolderIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogHome.png"));
        table.put("FileChooser.upFolderIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogDirParriba.png"));
        table.put("FileChooser.detailsViewIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogDetails.png"));
        table.put("FileChooser.listViewIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/DialogList.png"));
        table.put("CheckBoxMenuItem.checkIcon", NimRODIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", NimRODIconFactory.getRadioButtonMenuItemIcon());
        table.put("ComboBox.flechaIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/ComboButtonDown.png"));
        table.put("ComboBox.buttonDownIcon", NimRODIconFactory.getComboFlechaIcon());
        table.put("Menu.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuItem.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuCheckBox.iconBase", NimRODUtils.loadRes("/net/sf/nimrod/icons/MenuCheckBoxBase.png"));
        table.put("MenuCheckBox.iconTick", NimRODUtils.loadRes("/net/sf/nimrod/icons/MenuCheckBoxTick.png"));
        table.put("MenuRadioButton.iconBase", NimRODUtils.loadRes("/net/sf/nimrod/icons/MenuRadioBase.png"));
        table.put("MenuRadioButton.iconTick", NimRODUtils.loadRes("/net/sf/nimrod/icons/MenuRadioTick.png"));
        table.put("CheckBox.iconBase", NimRODUtils.loadRes("/net/sf/nimrod/icons/CheckBoxBase.png"));
        table.put("CheckBox.iconTick", NimRODUtils.loadRes("/net/sf/nimrod/icons/CheckBoxTick.png"));
        table.put("RadioButton.iconBase", NimRODUtils.loadRes("/net/sf/nimrod/icons/RadioButtonBase.png"));
        table.put("RadioButton.iconTick", NimRODUtils.loadRes("/net/sf/nimrod/icons/RadioButtonTick.png"));
        table.put("BordeGenSup", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenSup.png"));
        table.put("BordeGenSupDer", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenSupDer.png"));
        table.put("BordeGenDer", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenDer.png"));
        table.put("BordeGenInfDer", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenInfDer.png"));
        table.put("BordeGenInf", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenInf.png"));
        table.put("BordeGenInfIzq", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenInfIzq.png"));
        table.put("BordeGenIzq", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenIzq.png"));
        table.put("BordeGenSupIzq", NimRODUtils.loadRes("/net/sf/nimrod/icons/BordeGenSupIzq.png"));
        table.put("List.border", NimRODBorders.getGenBorder());
        table.put("ScrollPane.viewportBorder", NimRODBorders.getGenBorder());
        table.put("Menu.border", NimRODBorders.getGenMenuBorder());
        table.put("ToolBar.border", NimRODBorders.getToolBarBorder());
        table.put("TextField.border", NimRODBorders.getTextFieldBorder());
        table.put("TextArea.border", NimRODBorders.getTextFieldBorder());
        table.put("FormattedTextField.border", NimRODBorders.getTextFieldBorder());
        table.put("PasswordField.border", NimRODBorders.getTextFieldBorder());
        table.put("ToolTip.border", NimRODBorders.getToolTipBorder());
        table.put("Table.focusCellHighlightBorder", NimRODBorders.getCellFocusBorder());
        table.put("ScrollPane.border", NimRODBorders.getScrollPaneBorder());
        ColorUIResource col2 = NimRODUtils.getColorTercio(NimRODLookAndFeel.getFocusColor(), (Color)table.get("TextField.inactiveBackground"));
        table.put("ToolTip.background", col2);
        table.put("ToolTip.font", (Font)table.get("Menu.font"));
        table.put("Spinner.editorBorderPainted", new Boolean(false));
        table.put("Spinner.border", NimRODBorders.getTextFieldBorder());
        table.put("Spinner.arrowButtonBorder", BorderFactory.createEmptyBorder());
        table.put("Spinner.nextIcon", NimRODIconFactory.getSpinnerNextIcon());
        table.put("Spinner.previousIcon", NimRODIconFactory.getSpinnerPreviousIcon());
        table.put("OptionPane.errorIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/Error.png"));
        table.put("OptionPane.informationIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/Inform.png"));
        table.put("OptionPane.warningIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/Warn.png"));
        table.put("OptionPane.questionIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/Question.png"));
        table.put("Slider.horizontalThumbIcon", NimRODIconFactory.getSliderHorizontalIcon());
        table.put("Slider.verticalThumbIcon", NimRODIconFactory.getSliderVerticalIcon());
        table.put("Slider.horizontalThumbIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/HorizontalThumbIconImage.png"));
        table.put("Slider.verticalThumbIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/VerticalThumbIconImage.png"));
        table.put("ScrollBar.horizontalThumbIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/HorizontalScrollIconImage.png"));
        table.put("ScrollBar.verticalThumbIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/VerticalScrollIconImage.png"));
        table.put("ScrollBar.northButtonIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/ScrollBarNorthButtonIconImage.png"));
        table.put("ScrollBar.southButtonIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/ScrollBarSouthButtonIconImage.png"));
        table.put("ScrollBar.eastButtonIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/ScrollBarEastButtonIconImage.png"));
        table.put("ScrollBar.westButtonIconImage", NimRODUtils.loadRes("/net/sf/nimrod/icons/ScrollBarWestButtonIconImage.png"));
        table.put("ScrollBar.northButtonIcon", NimRODIconFactory.getScrollBarNorthButtonIcon());
        table.put("ScrollBar.southButtonIcon", NimRODIconFactory.getScrollBarSouthButtonIcon());
        table.put("ScrollBar.eastButtonIcon", NimRODIconFactory.getScrollBarEastButtonIcon());
        table.put("ScrollBar.westButtonIcon", NimRODIconFactory.getScrollBarWestButtonIcon());
        table.put("Button.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("ToggleButton.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("Desktop.background", table.get("MenuItem.background"));
        table.put("InternalFrame.border", NimRODBorders.getInternalFrameBorder());
        table.put("InternalFrame.NimCloseIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameClose.png"));
        table.put("InternalFrame.NimCloseIconRoll", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameCloseRoll.png"));
        table.put("InternalFrame.NimCloseIconPush", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameClosePush.png"));
        table.put("InternalFrame.NimMaxIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMaximiza.png"));
        table.put("InternalFrame.NimMaxIconRoll", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMaximizaRoll.png"));
        table.put("InternalFrame.NimMaxIconPush", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMaximizaPush.png"));
        table.put("InternalFrame.NimMinIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMinimiza.png"));
        table.put("InternalFrame.NimMinIconRoll", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMinimizaRoll.png"));
        table.put("InternalFrame.NimMinIconPush", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameMinimizaPush.png"));
        table.put("InternalFrame.NimResizeIcon", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameResize.png"));
        table.put("InternalFrame.NimResizeIconRoll", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameResizeRoll.png"));
        table.put("InternalFrame.NimResizeIconPush", NimRODUtils.loadRes("/net/sf/nimrod/icons/FrameResizePush.png"));
        table.put("InternalFrame.closeIcon", NimRODIconFactory.getFrameCloseIcon());
        table.put("InternalFrame.minimizeIcon", NimRODIconFactory.getFrameAltMaximizeIcon());
        table.put("InternalFrame.maximizeIcon", NimRODIconFactory.getFrameMaxIcon());
        table.put("InternalFrame.iconifyIcon", NimRODIconFactory.getFrameMinIcon());
        table.put("InternalFrame.icon", NimRODUtils.loadRes("/net/sf/nimrod/icons/Frame.png"));
        table.put("NimRODInternalFrameIconLit.width", new Integer(20));
        table.put("NimRODInternalFrameIconLit.height", new Integer(20));
        Font fontIcon = ((Font)table.get("InternalFrame.titleFont")).deriveFont(1);
        table.put("DesktopIcon.font", fontIcon);
        table.put("NimRODDesktopIcon.width", new Integer(80));
        table.put("NimRODDesktopIcon.height", new Integer(60));
        table.put("NimRODDesktopIconBig.width", new Integer(48));
        table.put("NimRODDesktopIconBig.height", new Integer(48));
        table.put("InternalFrame.activeTitleBackground", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("InternalFrame.activeTitleGradient", NimRODLookAndFeel.getMenuSelectedBackground().darker());
        table.put("InternalFrame.inactiveTitleBackground", NimRODLookAndFeel.getMenuBackground().brighter());
        table.put("InternalFrame.inactiveTitleGradient", NimRODLookAndFeel.getMenuBackground().darker());
    }
}

